/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.IGravityPartMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@DataGeneratorScanned
public class MaintenanceHatchProvider
extends CapabilityBlockProvider<IMaintenanceMachine> {
    private static final String KEY_DURATION_MULTIPLIER = "durationMultiplier";
    private static final String KEY_GRAVITY = "gravity";
    private static final String DURATION_MULTIPLIER = "gtocore.machine.duration_multiplier.tooltip";
    @RegisterLanguage(cn="\u5f53\u524d\u91cd\u529b: %s", en="Current Gravity: %s")
    private static final String GRAVITY = "tooltip.jade.current_gravity";

    public MaintenanceHatchProvider() {
        super(GTOCore.id((String)"maintenance_hatch_provider"));
    }

    @Nullable
    protected IMaintenanceMachine getCapability(Level level, BlockPos blockPos, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        MetaMachine machine = MetaMachine.getMachine((BlockEntity)blockEntity);
        if (machine instanceof IMaintenanceMachine) {
            IMaintenanceMachine mm = (IMaintenanceMachine)machine;
            return mm;
        }
        return null;
    }

    protected void write(CompoundTag tag, IMaintenanceMachine machine) {
        tag.m_128350_(KEY_DURATION_MULTIPLIER, machine.getDurationMultiplier());
        if (machine instanceof IGravityPartMachine) {
            IGravityPartMachine gm = (IGravityPartMachine)machine;
            tag.m_128405_(KEY_GRAVITY, gm.getCurrentGravity());
        }
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor accessor, BlockEntity blockEntity, IPluginConfig config) {
        float multiplier;
        if (capData.m_128441_(KEY_DURATION_MULTIPLIER) && (multiplier = capData.m_128457_(KEY_DURATION_MULTIPLIER)) != 1.0f) {
            MutableComponent multiplierText = Component.m_237113_((String)FormattingUtil.formatNumbers((double)multiplier)).m_130940_(multiplier > 1.0f ? ChatFormatting.RED : ChatFormatting.GREEN);
            tooltip.add((Component)Component.m_237110_((String)DURATION_MULTIPLIER, (Object[])new Object[]{multiplierText}));
        }
        if (capData.m_128441_(KEY_GRAVITY)) {
            tooltip.add((Component)Component.m_237110_((String)GRAVITY, (Object[])new Object[]{capData.m_128451_(KEY_GRAVITY)}));
        }
    }
}

