/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.ftbquests;

import com.gtocore.integration.ftbquests.AdditionalTeamData;
import com.gtolib.utils.ServerUtils;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class ScheduledTask
extends AbstractBooleanTask {
    static TaskType SCHEDULED;
    private boolean isInGame = false;
    private boolean refreshInFixedTime = false;
    private long intervalInSeconds = 0L;

    public ScheduledTask(long id, Quest quest) {
        super(id, quest);
    }

    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        long currentTimeSeconds;
        if (this.intervalInSeconds == 0L) {
            return false;
        }
        long lastCompleteTimeSeconds = this.isInGame ? AdditionalTeamData.getLastCompleteServerTick(this.getQuest().id, teamData.getTeamId()) / 20L : AdditionalTeamData.getLastCompleteMillis(this.getQuest().id, teamData.getTeamId()) / 1000L;
        long l = currentTimeSeconds = this.isInGame ? (long)(ServerUtils.getServer().m_129921_() / 20) : System.currentTimeMillis() / 1000L;
        if (this.refreshInFixedTime) {
            return currentTimeSeconds / this.intervalInSeconds > lastCompleteTimeSeconds / this.intervalInSeconds;
        }
        return currentTimeSeconds - lastCompleteTimeSeconds >= this.intervalInSeconds;
    }

    public TaskType getType() {
        return SCHEDULED;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128379_("isInGame", this.isInGame);
        nbt.m_128379_("refreshInFixedTime", this.refreshInFixedTime);
        nbt.m_128356_("intervalInSeconds", this.intervalInSeconds);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.isInGame = nbt.m_128471_("isInGame");
        this.refreshInFixedTime = nbt.m_128471_("refreshInFixedTime");
        this.intervalInSeconds = nbt.m_128454_("intervalInSeconds");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.isInGame);
        buffer.writeBoolean(this.refreshInFixedTime);
        buffer.writeLong(this.intervalInSeconds);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.isInGame = buffer.readBoolean();
        this.refreshInFixedTime = buffer.readBoolean();
        this.intervalInSeconds = buffer.readLong();
    }

    private long getRemainingSeconds(TeamData teamData) {
        long currentTimeSeconds;
        long lastCompleteTimeSeconds = this.isInGame ? AdditionalTeamData.getLastCompleteServerTick(this.getQuest().id, teamData.getTeamId()) / 20L : AdditionalTeamData.getLastCompleteMillis(this.getQuest().id, teamData.getTeamId()) / 1000L;
        long l = currentTimeSeconds = this.isInGame ? (long)(ServerUtils.getServer().m_129921_() / 20) : System.currentTimeMillis() / 1000L;
        if (this.refreshInFixedTime) {
            long nextTime = (currentTimeSeconds / this.intervalInSeconds + 1L) * this.intervalInSeconds;
            return nextTime - currentTimeSeconds;
        }
        long elapsed = currentTimeSeconds - lastCompleteTimeSeconds;
        return Math.max(0L, this.intervalInSeconds - elapsed);
    }

    public String formatProgress(TeamData teamData, long progress) {
        return I18n.m_118938_((String)"tooltip.ad_astra.eta", (Object[])new Object[]{this.getRemainingSeconds(teamData)});
    }

    public String formatMaxProgress() {
        return I18n.m_118938_((String)"emi.cooking.time", (Object[])new Object[]{this.intervalInSeconds});
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addBool("isInGame", this.isInGame, v -> {
            this.isInGame = v;
        }, false);
        config.addBool("refreshInFixedTime", this.refreshInFixedTime, v -> {
            this.refreshInFixedTime = v;
        }, false);
        config.addLong("intervalInSeconds", this.intervalInSeconds, v -> {
            this.intervalInSeconds = v;
        }, 0L, 0L, Long.MAX_VALUE);
    }
}

