/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi.oreprocessing;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemStackList;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.machines.MultiBlockC;
import com.gtocore.data.recipe.generated.GTOOreRecipeHandler;
import com.gtolib.api.recipe.ContentBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;

final class OreByProductWrapper {
    private static final ImmutableList<TagPrefix> IN_PROCESSING_STEPS = ImmutableList.of((Object)TagPrefix.crushed, (Object)TagPrefix.crushedPurified, (Object)TagPrefix.dustImpure, (Object)TagPrefix.dustPure, (Object)TagPrefix.crushedRefined);
    private static final ImmutableList<ItemStack> ALWAYS_MACHINES = ImmutableList.of((Object)MultiBlockC.STEAM_CRUSHER.asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack(), (Object)GTMachines.ORE_WASHER[1].asStack(), (Object)GTMachines.THERMAL_CENTRIFUGE[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack());
    private final Int2ObjectMap<Content> chances = new Int2ObjectOpenHashMap();
    private final List<ItemEntryList> itemInputs = new ArrayList<ItemEntryList>();
    private final NonNullList<ItemStack> itemOutputs = NonNullList.m_122779_();
    private final List<FluidEntryList> fluidInputs = new ArrayList<FluidEntryList>();
    private boolean hasDirectSmelt = false;
    private boolean hasChemBath = false;
    private boolean hasSeparator = false;
    private boolean hasSifter = false;
    private int currentSlot;

    private static ItemStack patchedAddPrefix(Material mat) {
        Material transformed = GTOOreRecipeHandler.getOutputMaterial(mat);
        return ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)transformed, (int)1);
    }

    OreByProductWrapper(Material material) {
        OreProperty property = (OreProperty)material.getProperty(PropertyKey.ORE);
        int oreMultiplier = property.getOreMultiplier();
        int byproductMultiplier = property.getByProductMultiplier();
        this.currentSlot = 0;
        Material[] byproducts = new Material[]{property.getOreByProduct(0, material), property.getOreByProduct(1, material), property.getOreByProduct(2, material), property.getOreByProduct(3, material)};
        ObjectIntPair washedIn = property.getWashedIn();
        List separatedInto = property.getSeparatedInto();
        ItemStackList oreStacks = new ItemStackList();
        ItemStack rawOre = ChemicalHelper.get((TagPrefix)TagPrefix.rawOre, (Material)material);
        oreStacks.add(rawOre);
        this.itemInputs.add((ItemEntryList)oreStacks);
        ArrayList<ItemStack> simpleWashers = new ArrayList<ItemStack>();
        simpleWashers.add(new ItemStack((ItemLike)Items.f_42544_));
        simpleWashers.add(GTMachines.ORE_WASHER[1].asStack());
        if (!material.hasProperty(PropertyKey.BLAST) && Minecraft.m_91087_().f_91073_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{rawOre}), (Level)Minecraft.m_91087_().f_91073_).isPresent()) {
            this.addToInputs(new ItemStack((ItemLike)Blocks.f_50094_));
            this.hasDirectSmelt = true;
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        for (ItemStack stack : ALWAYS_MACHINES) {
            this.addToInputs(stack);
        }
        this.itemInputs.add((ItemEntryList)ItemStackList.of(simpleWashers));
        this.itemInputs.add((ItemEntryList)ItemStackList.of(simpleWashers));
        this.itemInputs.add((ItemEntryList)ItemStackList.of(simpleWashers));
        if (!((Material)washedIn.first()).isNull()) {
            this.hasChemBath = true;
            this.addToInputs(GTMachines.CHEMICAL_BATH[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        if (separatedInto != null && !separatedInto.isEmpty()) {
            this.hasSeparator = true;
            this.addToInputs(GTMachines.ELECTROMAGNETIC_SEPARATOR[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.hasSifter = true;
            this.addToInputs(GTMachines.SIFTER[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        for (TagPrefix prefix : IN_PROCESSING_STEPS) {
            this.itemInputs.add((ItemEntryList)ItemStackList.of((ItemStack)ChemicalHelper.get((TagPrefix)prefix, (Material)material)));
        }
        this.currentSlot += 21;
        if (this.hasDirectSmelt) {
            Material smeltingMaterial;
            Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
            ItemStack smeltingResult = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)smeltingMaterial) : ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)smeltingMaterial));
            smeltingResult.m_41764_(smeltingResult.m_41613_() * oreMultiplier);
            this.addToOutputs(smeltingResult);
        } else {
            this.addEmptyOutputs(1);
        }
        this.addToOutputs(material, TagPrefix.crushed, 2 * oreMultiplier);
        if (!ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)byproducts[0]).m_41619_()) {
            this.addToOutputs(byproducts[0], TagPrefix.gem, 1);
        } else {
            this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        }
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, byproductMultiplier);
        this.addChance(1400, 850);
        this.addToOutputsPatched(material);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(3333, 0);
        FluidStackList tagList = new FluidStackList();
        tagList.add(GTMaterials.Water.getFluid(1000));
        tagList.add(GTMaterials.DistilledWater.getFluid(100));
        this.fluidInputs.add((FluidEntryList)tagList);
        this.addToOutputs(material, TagPrefix.crushedRefined, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, byproductMultiplier);
        this.addChance(3333, 0);
        this.addToOutputsPatched(material);
        this.addToOutputs(byproducts[2], TagPrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputsPatched(material);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushed, 1);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputsPatched(material);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputsPatched(material);
        if (this.hasChemBath) {
            this.addToOutputs(material, TagPrefix.crushedPurified, 1);
            this.addToOutputs(byproducts[3], TagPrefix.dust, byproductMultiplier);
            this.addChance(7000, 580);
            this.fluidInputs.add((FluidEntryList)FluidStackList.of((FluidStack)((Material)washedIn.first()).getFluid(washedIn.rightInt())));
        } else {
            this.addEmptyOutputs(2);
            this.fluidInputs.add((FluidEntryList)new FluidStackList());
        }
        if (this.hasSeparator) {
            TagPrefix prefix;
            prefix = ((Material)separatedInto.get(separatedInto.size() - 1)).getBlastTemperature() == 0 && ((Material)separatedInto.get(separatedInto.size() - 1)).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get((TagPrefix)prefix, (Material)((Material)separatedInto.get(separatedInto.size() - 1)), (int)(prefix == TagPrefix.nugget ? 2 : 1));
            this.addToOutputsPatched(material);
            this.addToOutputs((Material)separatedInto.get(0), TagPrefix.dust, 1);
            this.addChance(1000, 250);
            this.addToOutputs(separatedStack2);
            this.addChance(prefix == TagPrefix.dust ? 500 : 2000, prefix == TagPrefix.dust ? 150 : 600);
        } else {
            this.addEmptyOutputs(3);
        }
        if (this.hasSifter) {
            boolean highOutput = material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT);
            ItemStack flawedStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawed, (Material)material);
            ItemStack chippedStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemChipped, (Material)material);
            this.addToOutputs(material, TagPrefix.gemExquisite, 1);
            this.addGemChance(300, 100, 500, 150, highOutput);
            this.addToOutputs(material, TagPrefix.gemFlawless, 1);
            this.addGemChance(1000, 150, 1500, 200, highOutput);
            this.addToOutputs(material, TagPrefix.gem, 1);
            this.addGemChance(3500, 500, 5000, 1000, highOutput);
            this.addToOutputs(material, TagPrefix.dustPure, 1);
            this.addGemChance(5000, 750, 2500, 500, highOutput);
            if (!flawedStack.m_41619_()) {
                this.addToOutputs(flawedStack);
                this.addGemChance(2500, 300, 2000, 500, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
            if (!chippedStack.m_41619_()) {
                this.addToOutputs(chippedStack);
                this.addGemChance(3500, 400, 3000, 350, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
        } else {
            this.addEmptyOutputs(6);
        }
    }

    public void getTooltip(int slotIndex, List<Component> tooltips) {
        if (this.chances.containsKey(slotIndex)) {
            Content entry = (Content)this.chances.get(slotIndex);
            float chance = 100.0f * (float)entry.chance / (float)ContentBuilder.maxChance;
            float boost = (float)entry.tierChanceBoost / 100.0f;
            tooltips.add(FormattingUtil.formatPercentage2Places((String)"gtceu.gui.content.chance_base", (float)chance));
            tooltips.add(FormattingUtil.formatPercentage2Places((String)"gtceu.gui.content.chance_tier_boost_plus", (float)boost));
        }
    }

    public Content getChance(int slot) {
        return (Content)this.chances.get(slot);
    }

    public boolean hasSifter() {
        return this.hasSifter;
    }

    public boolean hasSeparator() {
        return this.hasSeparator;
    }

    public boolean hasChemBath() {
        return this.hasChemBath;
    }

    public boolean hasDirectSmelt() {
        return this.hasDirectSmelt;
    }

    private void addToOutputs(Material material, TagPrefix prefix, int size) {
        this.addToOutputs(ChemicalHelper.get((TagPrefix)prefix, (Material)material, (int)size));
    }

    private void addToOutputsPatched(Material material) {
        this.addToOutputs(OreByProductWrapper.patchedAddPrefix(material));
    }

    private void addToOutputs(ItemStack stack) {
        this.itemOutputs.add((Object)stack);
        ++this.currentSlot;
    }

    private void addEmptyOutputs(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addToOutputs(ItemStack.f_41583_);
        }
    }

    private void addToInputs(ItemStack stack) {
        this.itemInputs.add((ItemEntryList)ItemStackList.of((ItemStack)stack));
    }

    private void addChance(int base, int tier) {
        this.chances.put(this.currentSlot - 1, (Object)new Content((Object)ItemStack.f_41583_, base, tier));
    }

    private void addGemChance(int baseLow, int tierLow, int baseHigh, int tierHigh, boolean high) {
        if (high) {
            this.addChance(baseHigh, tierHigh);
        } else {
            this.addChance(baseLow, tierLow);
        }
    }

    @Generated
    public List<ItemEntryList> getItemInputs() {
        return this.itemInputs;
    }

    @Generated
    public NonNullList<ItemStack> getItemOutputs() {
        return this.itemOutputs;
    }

    @Generated
    public List<FluidEntryList> getFluidInputs() {
        return this.fluidInputs;
    }
}

