/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.apotheosis;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public abstract class NumeralStatsAffix
extends Affix {
    protected final Map<LootRarity, StepFunction> values;

    protected NumeralStatsAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.STAT);
        this.values = values;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    public float getBuff(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        MutableComponent comp = this.getDescription(stack, rarity, level);
        MutableComponent minComp = Component.m_237113_((String)NumeralStatsAffix.fmt((float)this.getBuff(rarity, 0.0f)));
        MutableComponent maxComp = Component.m_237113_((String)NumeralStatsAffix.fmt((float)this.getBuff(rarity, 1.0f)));
        return comp.m_7220_((Component)NumeralStatsAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public static <T extends NumeralStatsAffix> Codec<T> createCodec(Function<Map<LootRarity, StepFunction>, T> constructor) {
        return RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(NumeralStatsAffix::getValues)).apply((Applicative)inst, constructor));
    }

    public abstract Codec<? extends Affix> getCodec();

    @Generated
    public Map<LootRarity, StepFunction> getValues() {
        return this.values;
    }
}

