/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.ae.wireless;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import com.gtocore.api.misc.NetworkStats;
import com.gtocore.api.misc.WirelessNetworkTopologyManager;
import com.gtocore.api.misc.codec.CodecAbleTyped;
import com.gtocore.api.misc.codec.CodecAbleTypedCompanion;
import com.gtocore.common.saved.WirelessSavedData;
import com.gtocore.config.GTOConfig;
import com.gtocore.integration.ae.wireless.WirelessMachine;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 -2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010%\u001a\u00020&H\u0007J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020&2\u0006\u0010*\u001a\u00020\u001eJ\b\u0010,\u001a\u00020&H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/gtocore/integration/ae/wireless/WirelessGrid;", "Lcom/gtocore/api/misc/codec/CodecAbleTyped;", "Lcom/gtocore/integration/ae/wireless/WirelessGrid$Companion;", "name", "", "owner", "Ljava/util/UUID;", "isDefault", "", "connectionPoolTable", "", "Lcom/gtocore/integration/ae/wireless/WirelessGrid$MachineInfo;", "nickname", "<init>", "(Ljava/lang/String;Ljava/util/UUID;ZLjava/util/List;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getOwner", "()Ljava/util/UUID;", "()Z", "setDefault", "(Z)V", "getConnectionPoolTable", "()Ljava/util/List;", "setConnectionPoolTable", "(Ljava/util/List;)V", "getNickname", "setNickname", "(Ljava/lang/String;)V", "connectionPool", "Lcom/gtocore/integration/ae/wireless/WirelessMachine;", "getConnectionPool", "connectionHolderPool", "Lappeng/api/networking/IGridConnection;", "getConnectionHolderPool", "topologyManager", "Lcom/gtocore/api/misc/WirelessNetworkTopologyManager;", "refreshConnectionPool", "", "getTotalUsedChannel", "", "addNodeToNetwork", "machine", "removeNodeFromNetwork", "fallbackToSimpleConnections", "Companion", "MachineInfo", "gtocore"})
@SourceDebugExtension(value={"SMAP\nWirelessGrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WirelessGrid.kt\ncom/gtocore/integration/ae/wireless/WirelessGrid\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n1869#2,2:149\n*S KotlinDebug\n*F\n+ 1 WirelessGrid.kt\ncom/gtocore/integration/ae/wireless/WirelessGrid\n*L\n75#1:147,2\n131#1:149,2\n*E\n"})
public final class WirelessGrid
implements CodecAbleTyped<WirelessGrid, Companion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final UUID owner;
    private boolean isDefault;
    @NotNull
    private List<MachineInfo> connectionPoolTable;
    @NotNull
    private String nickname;
    @NotNull
    private final List<WirelessMachine> connectionPool;
    @NotNull
    private final List<IGridConnection> connectionHolderPool;
    @NotNull
    private final WirelessNetworkTopologyManager topologyManager;

    public WirelessGrid(@NotNull String name, @NotNull UUID owner, boolean isDefault, @NotNull List<MachineInfo> connectionPoolTable, @NotNull String nickname) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(connectionPoolTable, (String)"connectionPoolTable");
        Intrinsics.checkNotNullParameter((Object)nickname, (String)"nickname");
        this.name = name;
        this.owner = owner;
        this.isDefault = isDefault;
        this.connectionPoolTable = connectionPoolTable;
        this.nickname = nickname;
        this.connectionPool = new ArrayList();
        this.connectionHolderPool = new ArrayList();
        this.topologyManager = new WirelessNetworkTopologyManager();
    }

    public /* synthetic */ WirelessGrid(String string, UUID uUID, boolean bl, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            string2 = string;
        }
        this(string, uUID, bl, list, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getOwner() {
        return this.owner;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public final void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    @NotNull
    public final List<MachineInfo> getConnectionPoolTable() {
        return this.connectionPoolTable;
    }

    public final void setConnectionPoolTable(@NotNull List<MachineInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.connectionPoolTable = list;
    }

    @NotNull
    public final String getNickname() {
        return this.nickname;
    }

    public final void setNickname(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.nickname = string;
    }

    @NotNull
    public final List<WirelessMachine> getConnectionPool() {
        return this.connectionPool;
    }

    @NotNull
    public final List<IGridConnection> getConnectionHolderPool() {
        return this.connectionHolderPool;
    }

    @ApiStatus.Internal
    public final void refreshConnectionPool() {
        Iterable $this$forEach$iv = this.connectionHolderPool;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.connectionHolderPool.clear();
        if (this.connectionPool.isEmpty()) {
            return;
        }
        try {
            List<IGridConnection> newConnections = this.topologyManager.rebuildTopology(this.connectionPool);
            this.connectionHolderPool.addAll((Collection<IGridConnection>)newConnections);
            NetworkStats stats = this.topologyManager.getNetworkStats();
            if (GTOConfig.INSTANCE.aeLog) {
                int n = stats.getTotalNodes();
                int n2 = stats.getTotalClusters();
                int n3 = stats.getTotalConnections();
                String string = "%.2f";
                Object[] objectArray = new Object[]{stats.getConnectionEfficiency() * (double)100};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String string3 = "Grid '" + this.name + "' topology rebuilt: " + n + " nodes, " + n2 + " clusters, " + n3 + " connections, efficiency: " + string2 + "%";
                System.out.println((Object)string3);
            }
        }
        catch (Exception e) {
            this.fallbackToSimpleConnections();
        }
    }

    public final int getTotalUsedChannel() {
        return this.topologyManager.getTotalUsedChannels();
    }

    public final void addNodeToNetwork(@NotNull WirelessMachine machine) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        if (!this.connectionPool.contains(machine)) {
            this.connectionPool.add(machine);
        }
        try {
            List<IGridConnection> newConnections = this.topologyManager.addNode(machine);
            this.connectionHolderPool.addAll((Collection<IGridConnection>)newConnections);
            if (GTOConfig.INSTANCE.aeLog) {
                System.out.println((Object)("Added node " + machine.self().getPos() + " to grid '" + this.name + "', " + newConnections.size() + " new connections"));
            }
        }
        catch (Exception e) {
            if (GTOConfig.INSTANCE.aeLog) {
                System.out.println((Object)("Failed to add node to topology: " + e.getMessage()));
            }
            this.refreshConnectionPool();
        }
    }

    public final void removeNodeFromNetwork(@NotNull WirelessMachine machine) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        if (this.connectionPool.remove(machine)) {
            try {
                List<IGridConnection> affectedConnections = this.topologyManager.removeNode(machine);
                CollectionsKt.removeAll(this.connectionHolderPool, arg_0 -> WirelessGrid.removeNodeFromNetwork$lambda$1(affectedConnections, arg_0));
                if (GTOConfig.INSTANCE.aeLog) {
                    System.out.println((Object)("Removed node " + machine.self().getPos() + " from grid '" + this.name + "'"));
                }
            }
            catch (Exception e) {
                if (GTOConfig.INSTANCE.aeLog) {
                    System.out.println((Object)("Failed to remove node from topology: " + e.getMessage()));
                }
                this.refreshConnectionPool();
            }
        }
    }

    private final void fallbackToSimpleConnections() {
        if (GTOConfig.INSTANCE.aeLog) {
            System.out.println((Object)("Grid '" + this.name + "' topology rebuild failed, falling back to simple connections"));
        }
        Iterable $this$forEach$iv = CollectionsKt.windowed$default((Iterable)this.connectionPool, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List windowedNodes = (List)element$iv;
            boolean bl = false;
            try {
                IGridNode iGridNode;
                WirelessMachine first = (WirelessMachine)windowedNodes.get(0);
                WirelessMachine second = (WirelessMachine)windowedNodes.get(1);
                IGridNode iGridNode2 = first.getMainNode().getNode();
                if (!(iGridNode2 != null && (iGridNode2 = iGridNode2.getLevel()) != null ? iGridNode2.m_46805_(first.self().getPos()) : false) || !((iGridNode = second.getMainNode().getNode()) != null && (iGridNode = iGridNode.getLevel()) != null ? iGridNode.m_46805_(second.self().getPos()) : false)) continue;
                IGridConnection gridConnection = GridHelper.createConnection((IGridNode)first.getMainNode().getNode(), (IGridNode)second.getMainNode().getNode());
                Intrinsics.checkNotNull((Object)gridConnection);
                this.connectionHolderPool.add(gridConnection);
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    @NotNull
    public Companion getCompanion() {
        return CodecAbleTyped.DefaultImpls.getCompanion(this);
    }

    @Override
    @NotNull
    public CompoundTag encodeToNbt() {
        return CodecAbleTyped.DefaultImpls.encodeToNbt(this);
    }

    @Override
    public void encodeToBuffer(@NotNull FriendlyByteBuf buf) {
        CodecAbleTyped.DefaultImpls.encodeToBuffer(this, buf);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        return CodecAbleTyped.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag p0) {
        CodecAbleTyped.DefaultImpls.deserializeNBT(this, p0);
    }

    @Override
    public void copyFrom(@NotNull WirelessGrid other) {
        CodecAbleTyped.DefaultImpls.copyFrom(this, (CodecAbleTyped)other);
    }

    private static final boolean removeNodeFromNetwork$lambda$1(List $affectedConnections, IGridConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return $affectedConnections.contains(connection);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/gtocore/integration/ae/wireless/WirelessGrid$Companion;", "Lcom/gtocore/api/misc/codec/CodecAbleTypedCompanion;", "Lcom/gtocore/integration/ae/wireless/WirelessGrid;", "<init>", "()V", "getCodec", "Lcom/mojang/serialization/Codec;", "gtocore"})
    public static final class Companion
    implements CodecAbleTypedCompanion<WirelessGrid> {
        private Companion() {
        }

        @Override
        @NotNull
        public Codec<WirelessGrid> getCodec() {
            Codec codec = RecordCodecBuilder.create(Companion::getCodec$lambda$6);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            return codec;
        }

        @Override
        @NotNull
        public WirelessGrid decodeFromNbt(@NotNull CompoundTag nbt) {
            return CodecAbleTypedCompanion.DefaultImpls.decodeFromNbt(this, nbt);
        }

        @Override
        @NotNull
        public WirelessGrid decodeFromBuffer(@NotNull FriendlyByteBuf buf) {
            return CodecAbleTypedCompanion.DefaultImpls.decodeFromBuffer(this, buf);
        }

        private static final String getCodec$lambda$6$lambda$0(WirelessGrid it) {
            return it.getName();
        }

        private static final UUID getCodec$lambda$6$lambda$1(WirelessGrid it) {
            return it.getOwner();
        }

        private static final Boolean getCodec$lambda$6$lambda$2(WirelessGrid it) {
            return it.isDefault();
        }

        private static final List getCodec$lambda$6$lambda$3(WirelessGrid it) {
            return CollectionsKt.toList((Iterable)it.getConnectionPoolTable());
        }

        private static final Optional getCodec$lambda$6$lambda$4(WirelessGrid it) {
            return Optional.ofNullable(it.getNickname());
        }

        private static final WirelessGrid getCodec$lambda$6$lambda$5(String name, UUID owner, Boolean isDefault, List connectionPoolTable, Optional nicknameOpt) {
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)owner);
            Intrinsics.checkNotNull((Object)isDefault);
            boolean bl = isDefault;
            Intrinsics.checkNotNull((Object)connectionPoolTable);
            List list = CollectionsKt.toMutableList((Collection)connectionPoolTable);
            String string = nicknameOpt.orElse(name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElse(...)");
            return new WirelessGrid(name, owner, bl, list, string);
        }

        private static final App getCodec$lambda$6(RecordCodecBuilder.Instance b2) {
            return b2.group((App)Codec.STRING.fieldOf("name").forGetter(Companion::getCodec$lambda$6$lambda$0), (App)UUIDUtil.f_235867_.fieldOf("owner").forGetter(Companion::getCodec$lambda$6$lambda$1), (App)Codec.BOOL.fieldOf("isDefault").forGetter(Companion::getCodec$lambda$6$lambda$2), (App)MachineInfo.Companion.getCodec().listOf().fieldOf("connectionPoolTable").forGetter(Companion::getCodec$lambda$6$lambda$3), (App)Codec.STRING.optionalFieldOf("nickname").forGetter(Companion::getCodec$lambda$6$lambda$4)).apply((Applicative)b2, Companion::getCodec$lambda$6$lambda$5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB5\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/gtocore/integration/ae/wireless/WirelessGrid$MachineInfo;", "Lcom/gtocore/api/misc/codec/CodecAbleTyped;", "Lcom/gtocore/integration/ae/wireless/WirelessGrid$MachineInfo$Companion;", "pos", "Lnet/minecraft/core/BlockPos;", "owner", "", "descriptionId", "level", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/core/BlockPos;Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/resources/ResourceKey;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "setPos", "(Lnet/minecraft/core/BlockPos;)V", "getOwner", "()Ljava/lang/String;", "setOwner", "(Ljava/lang/String;)V", "getDescriptionId", "setDescriptionId", "getLevel", "()Lnet/minecraft/resources/ResourceKey;", "setLevel", "(Lnet/minecraft/resources/ResourceKey;)V", "Companion", "gtocore"})
    public static final class MachineInfo
    implements CodecAbleTyped<MachineInfo, Companion> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private BlockPos pos;
        @NotNull
        private String owner;
        @NotNull
        private String descriptionId;
        @NotNull
        private ResourceKey<Level> level;

        public MachineInfo(@NotNull BlockPos pos, @NotNull String owner, @NotNull String descriptionId, @NotNull ResourceKey<Level> level) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)descriptionId, (String)"descriptionId");
            Intrinsics.checkNotNullParameter(level, (String)"level");
            this.pos = pos;
            this.owner = owner;
            this.descriptionId = descriptionId;
            this.level = level;
        }

        public /* synthetic */ MachineInfo(BlockPos blockPos, String string, String string2, ResourceKey resourceKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                blockPos = BlockPos.f_121853_;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                resourceKey = WirelessSavedData.Companion.getUNKNOWN();
            }
            this(blockPos, string, string2, resourceKey);
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        public final void setPos(@NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
            this.pos = blockPos;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.owner = string;
        }

        @NotNull
        public final String getDescriptionId() {
            return this.descriptionId;
        }

        public final void setDescriptionId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.descriptionId = string;
        }

        @NotNull
        public final ResourceKey<Level> getLevel() {
            return this.level;
        }

        public final void setLevel(@NotNull ResourceKey<Level> resourceKey) {
            Intrinsics.checkNotNullParameter(resourceKey, (String)"<set-?>");
            this.level = resourceKey;
        }

        @Override
        @NotNull
        public Companion getCompanion() {
            return CodecAbleTyped.DefaultImpls.getCompanion(this);
        }

        @Override
        @NotNull
        public CompoundTag encodeToNbt() {
            return CodecAbleTyped.DefaultImpls.encodeToNbt(this);
        }

        @Override
        public void encodeToBuffer(@NotNull FriendlyByteBuf buf) {
            CodecAbleTyped.DefaultImpls.encodeToBuffer(this, buf);
        }

        @Override
        @NotNull
        public CompoundTag serializeNBT() {
            return CodecAbleTyped.DefaultImpls.serializeNBT(this);
        }

        @Override
        public void deserializeNBT(@NotNull CompoundTag p0) {
            CodecAbleTyped.DefaultImpls.deserializeNBT(this, p0);
        }

        @Override
        public void copyFrom(@NotNull MachineInfo other) {
            CodecAbleTyped.DefaultImpls.copyFrom(this, (CodecAbleTyped)other);
        }

        public MachineInfo() {
            this(null, null, null, null, 15, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/gtocore/integration/ae/wireless/WirelessGrid$MachineInfo$Companion;", "Lcom/gtocore/api/misc/codec/CodecAbleTypedCompanion;", "Lcom/gtocore/integration/ae/wireless/WirelessGrid$MachineInfo;", "<init>", "()V", "getCodec", "Lcom/mojang/serialization/Codec;", "gtocore"})
        public static final class Companion
        implements CodecAbleTypedCompanion<MachineInfo> {
            private Companion() {
            }

            @Override
            @NotNull
            public Codec<MachineInfo> getCodec() {
                Codec codec = RecordCodecBuilder.create(Companion::getCodec$lambda$4);
                Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
                return codec;
            }

            @Override
            @NotNull
            public MachineInfo decodeFromNbt(@NotNull CompoundTag nbt) {
                return CodecAbleTypedCompanion.DefaultImpls.decodeFromNbt(this, nbt);
            }

            @Override
            @NotNull
            public MachineInfo decodeFromBuffer(@NotNull FriendlyByteBuf buf) {
                return CodecAbleTypedCompanion.DefaultImpls.decodeFromBuffer(this, buf);
            }

            private static final BlockPos getCodec$lambda$4$lambda$0(MachineInfo it) {
                return it.getPos();
            }

            private static final String getCodec$lambda$4$lambda$1(MachineInfo it) {
                return it.getOwner();
            }

            private static final String getCodec$lambda$4$lambda$2(MachineInfo it) {
                return it.getDescriptionId();
            }

            private static final ResourceKey getCodec$lambda$4$lambda$3(MachineInfo it) {
                return it.getLevel();
            }

            private static final App getCodec$lambda$4(RecordCodecBuilder.Instance b2) {
                return b2.group((App)BlockPos.f_121852_.optionalFieldOf("pos", (Object)BlockPos.f_121853_).forGetter(Companion::getCodec$lambda$4$lambda$0), (App)Codec.STRING.optionalFieldOf("owner", (Object)"").forGetter(Companion::getCodec$lambda$4$lambda$1), (App)Codec.STRING.optionalFieldOf("descriptionId", (Object)"").forGetter(Companion::getCodec$lambda$4$lambda$2), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).optionalFieldOf("level", WirelessSavedData.Companion.getUNKNOWN()).forGetter(Companion::getCodec$lambda$4$lambda$3)).apply((Applicative)b2, MachineInfo::new);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

