/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.manager;

import com.fast.fastcollection.O2LOpenCacheHashMap;
import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gtocore.data.transaction.TradingStationTool;
import com.gtocore.data.transaction.manager.TradeData;
import com.gtolib.api.wireless.WirelessManaContainer;
import com.gtolib.utils.WalletUtils;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public record TradeEntry(IGuiTexture texture, List<Component> description, String unlockCondition, PreTradeCheck preCheck, TradeRunnable onExecute, TradeGroup inputGroup, TradeGroup outputGroup) {
    public TradeEntry {
        texture = texture != null ? texture : GuiTextures.GREGTECH_LOGO;
        unlockCondition = unlockCondition != null ? unlockCondition : "Base";
        description = ImmutableList.copyOf(description != null ? description : List.of());
        inputGroup = inputGroup != null ? inputGroup : new TradeGroup(List.of(), List.of(), (O2LOpenCacheHashMap<String>)new O2LOpenCacheHashMap(), BigInteger.ZERO, BigInteger.ZERO);
        outputGroup = outputGroup != null ? outputGroup : new TradeGroup(List.of(), List.of(), (O2LOpenCacheHashMap<String>)new O2LOpenCacheHashMap(), BigInteger.ZERO, BigInteger.ZERO);
    }

    public int canExecuteCount(TradeData data) {
        if (this.preCheck == null) {
            return -1;
        }
        return this.preCheck.test(data, this);
    }

    private int checkInputEnough(TradeData data) {
        int inputMana;
        int inputEnergy;
        int inputCurrencies;
        int outputFluid;
        int inputFluid;
        int inputItem;
        Level level = data.level();
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int n = inputItem = this.inputGroup().items().isEmpty() ? Integer.MAX_VALUE : TradingStationTool.checkMaxMultiplier(data.inputItem(), this.inputGroup().items());
        if (inputItem == 0) {
            return 0;
        }
        int n2 = inputFluid = this.inputGroup().fluids().isEmpty() ? Integer.MAX_VALUE : TradingStationTool.checkMaxConsumeMultiplier(data.inputFluid(), this.inputGroup().fluids());
        if (inputFluid == 0) {
            return 0;
        }
        int n3 = outputFluid = this.outputGroup().fluids().isEmpty() ? Integer.MAX_VALUE : TradingStationTool.checkMaxCapacityMultiplier(data.outputFluid(), this.outputGroup().fluids());
        if (outputFluid == 0) {
            return 0;
        }
        int n4 = inputCurrencies = this.inputGroup().currencies().isEmpty() ? Integer.MAX_VALUE : (int)Math.min(this.inputGroup().currencies().object2LongEntrySet().stream().filter(entry -> entry.getLongValue() != 0L).mapToLong(entry -> WalletUtils.getCurrencyAmount((UUID)data.uuid(), (Level)serverLevel, (String)((String)entry.getKey())) / entry.getLongValue()).min().orElse(0L), Integer.MAX_VALUE);
        if (inputCurrencies == 0) {
            return 0;
        }
        int n5 = inputEnergy = this.inputGroup().energy().equals(BigInteger.ZERO) ? Integer.MAX_VALUE : WirelessEnergyContainer.getOrCreateContainer((UUID)data.teamUUID()).getStorage().divide(this.inputGroup().energy()).min(BigInteger.valueOf(Integer.MAX_VALUE)).intValueExact();
        if (inputEnergy == 0) {
            return 0;
        }
        int n6 = inputMana = this.inputGroup().mana().equals(BigInteger.ZERO) ? Integer.MAX_VALUE : WirelessManaContainer.getOrCreateContainer((UUID)data.teamUUID()).getStorage().divide(this.inputGroup().mana()).min(BigInteger.valueOf(Integer.MAX_VALUE)).intValueExact();
        if (inputMana == 0) {
            return 0;
        }
        return IntStream.of(inputItem, inputFluid, outputFluid, inputCurrencies, inputEnergy, inputMana).min().orElse(0);
    }

    private void executeInputOutput(TradeData data, int multiplier) {
        WirelessManaContainer manaContainer;
        WirelessEnergyContainer energyContainer;
        Level level = data.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.inputGroup().items().isEmpty()) {
            TradingStationTool.deductMultipliedItems(data.inputItem(), this.inputGroup().items(), multiplier);
        }
        if (!this.outputGroup().items().isEmpty()) {
            TradingStationTool.addMultipliedItems(data.outputItem(), this.outputGroup().items(), multiplier, (Level)serverLevel, data.pos());
        }
        if (!this.inputGroup().fluids().isEmpty()) {
            TradingStationTool.deductMultipliedFluids(data.inputFluid(), this.inputGroup().fluids(), multiplier);
        }
        if (!this.outputGroup().fluids().isEmpty()) {
            TradingStationTool.addMultipliedFluids(data.outputFluid(), this.outputGroup().fluids(), multiplier);
        }
        if (!this.inputGroup().currencies().isEmpty()) {
            this.inputGroup().currencies().forEach((currencyId, singleAmount) -> WalletUtils.subtractCurrency((UUID)data.uuid(), (Level)serverLevel, (String)currencyId, (long)(singleAmount * (long)multiplier)));
        }
        if (!this.outputGroup().currencies().isEmpty()) {
            this.outputGroup().currencies().forEach((currencyId, singleAmount) -> WalletUtils.addCurrency((UUID)data.uuid(), (Level)serverLevel, (String)currencyId, (long)(singleAmount * (long)multiplier)));
        }
        if (!this.inputGroup().energy().equals(BigInteger.ZERO)) {
            energyContainer = WirelessEnergyContainer.getOrCreateContainer((UUID)data.teamUUID());
            energyContainer.setStorage(energyContainer.getStorage().subtract(this.inputGroup().energy().multiply(BigInteger.valueOf(multiplier))));
        }
        if (!this.outputGroup().energy().equals(BigInteger.ZERO)) {
            energyContainer = WirelessEnergyContainer.getOrCreateContainer((UUID)data.teamUUID());
            energyContainer.setStorage(energyContainer.getStorage().add(this.outputGroup().energy().multiply(BigInteger.valueOf(multiplier))));
        }
        if (!this.inputGroup().mana().equals(BigInteger.ZERO)) {
            manaContainer = WirelessManaContainer.getOrCreateContainer((UUID)data.teamUUID());
            manaContainer.setStorage(manaContainer.getStorage().subtract(this.inputGroup().mana().multiply(BigInteger.valueOf(multiplier))));
        }
        if (!this.outputGroup().mana().equals(BigInteger.ZERO)) {
            manaContainer = WirelessManaContainer.getOrCreateContainer((UUID)data.teamUUID());
            manaContainer.setStorage(manaContainer.getStorage().add(this.outputGroup().mana().multiply(BigInteger.valueOf(multiplier))));
        }
    }

    public int check(TradeData data) {
        int resourceMaxCount;
        if (!(data.level() instanceof ServerLevel)) {
            return 0;
        }
        int multiplier = Integer.MAX_VALUE;
        int preCheckMaxCount = this.canExecuteCount(data);
        if (preCheckMaxCount == 0) {
            return 0;
        }
        if (preCheckMaxCount > 0) {
            multiplier = preCheckMaxCount;
        }
        if ((resourceMaxCount = this.checkInputEnough(data)) <= 0) {
            return 0;
        }
        return Math.min(multiplier, resourceMaxCount);
    }

    public void executeTrade(TradeData data, int requestedMultiplier) {
        if (!(data.level() instanceof ServerLevel)) {
            return;
        }
        int finalMultiplier = Math.min(this.check(data), requestedMultiplier);
        if (finalMultiplier <= 0) {
            data.level().m_5594_(null, data.pos(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.8f, 1.4f);
            return;
        }
        this.executeInputOutput(data, finalMultiplier);
        if (this.onExecute != null) {
            this.onExecute.run(data, this, finalMultiplier);
        }
        data.level().m_5594_(null, data.pos(), SoundEvents.f_215676_, SoundSource.BLOCKS, 1.8f, 1.4f);
    }

    public List<Component> getDescription() {
        ArrayList<Component> componentList = new ArrayList<Component>(this.description());
        if (!this.inputGroup().isEmpty()) {
            componentList.addAll(this.inputGroup().getComponentList(true));
        }
        if (!this.outputGroup().isEmpty()) {
            componentList.addAll(this.outputGroup().getComponentList(false));
        }
        return componentList;
    }

    public record TradeGroup(List<ItemStack> items, List<FluidStack> fluids, O2LOpenCacheHashMap<String> currencies, BigInteger energy, BigInteger mana) {
        public TradeGroup {
            items = ImmutableList.copyOf(items);
            fluids = ImmutableList.copyOf(fluids);
            currencies = new O2LOpenCacheHashMap(currencies);
        }

        public boolean isEmpty() {
            boolean isItemsEmpty = this.items.stream().allMatch(ItemStack::m_41619_);
            boolean isFluidsEmpty = this.fluids.stream().allMatch(FluidStack::isEmpty);
            boolean isCurrenciesEmpty = this.currencies.isEmpty() || this.currencies.values().longStream().allMatch(amount -> amount <= 0L);
            boolean isEnergyEmpty = this.energy.equals(BigInteger.ZERO);
            boolean isManaEmpty = this.mana.equals(BigInteger.ZERO);
            return isItemsEmpty && isFluidsEmpty && isCurrenciesEmpty && isEnergyEmpty && isManaEmpty;
        }

        public List<Component> getComponentList(boolean input_output) {
            ArrayList<Component> list = new ArrayList<Component>();
            ChatFormatting color = input_output ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN;
            list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)(input_output ? Component.m_237115_((String)"gtocore.trade_group.true").m_130940_(ChatFormatting.DARK_RED) : Component.m_237115_((String)"gtocore.trade_group.false").m_130940_(ChatFormatting.DARK_GREEN))));
            for (ItemStack itemStack : this.items) {
                list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)Component.m_237113_((String)String.valueOf(itemStack.m_41613_())).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)itemStack.m_41611_().m_6881_().m_130940_(ChatFormatting.GOLD)));
            }
            for (FluidStack fluidStack : this.fluids) {
                list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)Component.m_237113_((String)String.valueOf(fluidStack.getAmount())).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)fluidStack.getDisplayName().m_6881_().m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            this.currencies.object2LongEntrySet().forEach(entry -> list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)Component.m_237113_((String)String.valueOf(entry.getLongValue())).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)("gtocore.currency." + (String)entry.getKey())).m_130940_(ChatFormatting.YELLOW))));
            if (!this.energy.equals(BigInteger.ZERO)) {
                list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)Component.m_237113_((String)this.energy.toString()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237113_((String)"EU").m_130940_(ChatFormatting.DARK_AQUA)));
            }
            if (!this.mana.equals(BigInteger.ZERO)) {
                list.add((Component)Component.m_237113_((String)"- ").m_130940_(color).m_7220_((Component)Component.m_237113_((String)this.mana.toString()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237113_((String)"Mana").m_130940_(ChatFormatting.DARK_PURPLE)));
            }
            return list;
        }

        public static class Builder {
            private final List<ItemStack> items = new ArrayList<ItemStack>();
            private final List<FluidStack> fluids = new ArrayList<FluidStack>();
            private final O2LOpenCacheHashMap<String> currencies = new O2LOpenCacheHashMap();
            private BigInteger energy = BigInteger.ZERO;
            private BigInteger mana = BigInteger.ZERO;

            public void addItem(ItemStack stack) {
                if (!stack.m_41619_()) {
                    this.items.add(stack);
                }
            }

            public void addFluid(FluidStack stack) {
                if (!stack.isEmpty()) {
                    this.fluids.add(stack);
                }
            }

            public void addCurrency(String currencyId, long amount) {
                if (amount > 0L) {
                    this.currencies.put((Object)currencyId, amount);
                }
            }

            public void withEnergy(BigInteger energy) {
                this.energy = energy;
            }

            public void withMana(BigInteger mana) {
                this.mana = mana;
            }

            public void withEnergy(long energy) {
                this.withEnergy(BigInteger.valueOf(energy));
            }

            public void withMana(long mana) {
                this.withMana(BigInteger.valueOf(mana));
            }

            public TradeGroup build() {
                return new TradeGroup(this.items, this.fluids, this.currencies, this.energy, this.mana);
            }
        }
    }

    @FunctionalInterface
    public static interface PreTradeCheck {
        public int test(TradeData var1, TradeEntry var2);
    }

    @FunctionalInterface
    public static interface TradeRunnable {
        public void run(TradeData var1, TradeEntry var2, int var3);
    }

    public static class Builder {
        private IGuiTexture texture;
        private final List<Component> description = new ArrayList<Component>();
        private String unlockCondition;
        private PreTradeCheck preCheck;
        private TradeRunnable onExecute;
        private TradeGroup.Builder inputGroupBuilder = new TradeGroup.Builder();
        private TradeGroup.Builder outputGroupBuilder = new TradeGroup.Builder();

        public Builder texture(IGuiTexture texture) {
            this.texture = texture;
            return this;
        }

        public Builder description(List<Component> components) {
            this.description.clear();
            if (components != null) {
                this.description.addAll(components);
            }
            return this;
        }

        public Builder addDescription(Component component) {
            this.description.add(component);
            return this;
        }

        public Builder unlockCondition(String condition) {
            this.unlockCondition = condition;
            return this;
        }

        public Builder preCheck(PreTradeCheck check) {
            this.preCheck = check;
            return this;
        }

        public Builder onExecute(TradeRunnable runnable) {
            this.onExecute = runnable;
            return this;
        }

        public Builder input(TradeGroup.Builder builder) {
            this.inputGroupBuilder = builder;
            return this;
        }

        public Builder inputItem(ItemStack stack) {
            this.inputGroupBuilder.addItem(stack);
            return this;
        }

        public Builder inputFluid(FluidStack stack) {
            this.inputGroupBuilder.addFluid(stack);
            return this;
        }

        public Builder inputCurrency(String currencyId, long amount) {
            this.inputGroupBuilder.addCurrency(currencyId, amount);
            return this;
        }

        public Builder inputEnergy(long energy) {
            this.inputGroupBuilder.withEnergy(energy);
            return this;
        }

        public Builder inputEnergy(BigInteger energy) {
            this.inputGroupBuilder.withEnergy(energy);
            return this;
        }

        public Builder inputMana(long mana) {
            this.inputGroupBuilder.withMana(mana);
            return this;
        }

        public Builder inputMana(BigInteger mana) {
            this.inputGroupBuilder.withMana(mana);
            return this;
        }

        public Builder output(TradeGroup.Builder builder) {
            this.outputGroupBuilder = builder;
            return this;
        }

        public Builder outputItem(ItemStack stack) {
            this.outputGroupBuilder.addItem(stack);
            return this;
        }

        public Builder outputFluid(FluidStack stack) {
            this.outputGroupBuilder.addFluid(stack);
            return this;
        }

        public Builder outputCurrency(String currencyId, long amount) {
            this.outputGroupBuilder.addCurrency(currencyId, amount);
            return this;
        }

        public Builder outputEnergy(long energy) {
            this.outputGroupBuilder.withEnergy(energy);
            return this;
        }

        public Builder outputEnergy(BigInteger energy) {
            this.outputGroupBuilder.withEnergy(energy);
            return this;
        }

        public Builder outputMana(long mana) {
            this.outputGroupBuilder.withMana(mana);
            return this;
        }

        public Builder outputMana(BigInteger mana) {
            this.outputGroupBuilder.withMana(mana);
            return this;
        }

        public TradeEntry build() {
            return new TradeEntry(this.texture, (List<Component>)ImmutableList.copyOf(this.description), this.unlockCondition, this.preCheck, this.onExecute, this.inputGroupBuilder.build(), this.outputGroupBuilder.build());
        }
    }
}

