/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.data.trade;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gtocore.data.transaction.data.TradeLang;
import com.gtocore.data.transaction.manager.TradeData;
import com.gtocore.data.transaction.manager.TradeEntry;
import com.gtocore.data.transaction.manager.UnlockManager;
import com.gtolib.api.GTOValues;
import com.gtolib.utils.WalletUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class UnlockTrade {
    public static final String SINGLE_TRANSACTION = "Single Transaction";
    public static final String UNLOCK_SHOP = "Unlock Shop";
    public static final String UNLOCK_TRADE = "Unlock Trade";
    public static final String UNLOCK_BASE = "Base";
    public static final String GT_Values = "GT Values";

    public static void init() {
        for (int i = 0; i < 14; ++i) {
            TradeEntry.TradeGroup.Builder tradeGroup = new TradeEntry.TradeGroup.Builder();
            tradeGroup.addItem(GTMachines.HULL[i].asStack());
            UnlockManager.INSTANCE.addTradeToEntry(TradeLang.addTradeLang("\u683c\u96f7\u7535\u538b", GT_Values), UnlockTrade.tradeEntry((IGuiTexture)new ResourceTexture("gtocore:textures/item/circuit/" + GTValues.VN[i].toLowerCase() + ".png"), UNLOCK_TRADE, GTOValues.VNFR[i], tradeGroup));
        }
    }

    private static TradeEntry tradeEntry(String tagKey, String tagValue, TradeEntry.TradeGroup.Builder tradeGroup) {
        return UnlockTrade.tradeEntry((IGuiTexture)GuiTextures.LOCK, tagKey, tagValue, tradeGroup);
    }

    private static TradeEntry tradeEntry(IGuiTexture texture, String tagKey, String tagValue, TradeEntry.TradeGroup.Builder tradeGroup) {
        return new TradeEntry.Builder().texture(texture).addDescription((Component)Component.m_237110_((String)TradeLang.addTradeLang("\u89e3\u9501\u4ea4\u6613\u6761\u4ef6 %s - %s", "Unlock transaction conditions %s - %s"), (Object[])new Object[]{tagKey, tagValue})).input(tradeGroup).preCheck((a2, b2) -> UnlockTrade.checkUnlock(a2, b2, tagKey, tagValue)).onExecute((a2, b2, c) -> UnlockTrade.performUnlock(a2, b2, c, tagKey, tagValue)).build();
    }

    private static int checkUnlock(TradeData data, TradeEntry entry, String tagKey, String tagValue) {
        ServerLevel serverLevel;
        Level level = data.level();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (!WalletUtils.containsTagValueInWallet((UUID)data.uuid(), (Level)serverLevel, (String)tagKey, (String)tagValue)) {
            return 1;
        }
        return 0;
    }

    private static void performUnlock(TradeData data, TradeEntry entry, int multiplier, String tagKey, String tagValue) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        WalletUtils.addTagToWallet((UUID)data.uuid(), (Level)serverLevel, (String)tagKey, (String)tagValue);
    }
}

