/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.chemistry;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;

final class PetrochemRecipes {
    PetrochemRecipes() {
    }

    public static void init() {
        PetrochemRecipes.moderatelyCrack(GTMaterials.Ethane, GTMaterials.HydroCrackedEthane, GTMaterials.SteamCrackedEthane);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Ethylene, GTMaterials.HydroCrackedEthylene, GTMaterials.SteamCrackedEthylene);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Propene, GTMaterials.HydroCrackedPropene, GTMaterials.SteamCrackedPropene);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Propane, GTMaterials.HydroCrackedPropane, GTMaterials.SteamCrackedPropane);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Butane, GTMaterials.HydroCrackedButane, GTMaterials.SteamCrackedButane);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Butene, GTMaterials.HydroCrackedButene, GTMaterials.SteamCrackedButene);
        PetrochemRecipes.moderatelyCrack(GTMaterials.Butadiene, GTMaterials.HydroCrackedButadiene, GTMaterials.SteamCrackedButadiene);
        PetrochemRecipes.lightlyCrack(GTMaterials.HeavyFuel, GTMaterials.LightlyHydroCrackedHeavyFuel, GTMaterials.LightlySteamCrackedHeavyFuel);
        PetrochemRecipes.severelyCrack(GTMaterials.HeavyFuel, GTMaterials.SeverelyHydroCrackedHeavyFuel, GTMaterials.SeverelySteamCrackedHeavyFuel);
        PetrochemRecipes.lightlyCrack(GTMaterials.LightFuel, GTMaterials.LightlyHydroCrackedLightFuel, GTMaterials.LightlySteamCrackedLightFuel);
        PetrochemRecipes.severelyCrack(GTMaterials.LightFuel, GTMaterials.SeverelyHydroCrackedLightFuel, GTMaterials.SeverelySteamCrackedLightFuel);
        PetrochemRecipes.lightlyCrack(GTMaterials.Naphtha, GTMaterials.LightlyHydroCrackedNaphtha, GTMaterials.LightlySteamCrackedNaphtha);
        PetrochemRecipes.severelyCrack(GTMaterials.Naphtha, GTMaterials.SeverelyHydroCrackedNaphtha, GTMaterials.SeverelySteamCrackedNaphtha);
        PetrochemRecipes.lightlyCrack(GTMaterials.RefineryGas, GTMaterials.LightlyHydroCrackedGas, GTMaterials.LightlySteamCrackedGas);
        PetrochemRecipes.severelyCrack(GTMaterials.RefineryGas, GTMaterials.SeverelyHydroCrackedGas, GTMaterials.SeverelySteamCrackedGas);
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_oil").inputFluids(GTMaterials.Oil, 50).outputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(15)).outputFluids(GTMaterials.SulfuricLightFuel.getFluid(50)).outputFluids(GTMaterials.SulfuricNaphtha.getFluid(20)).outputFluids(GTMaterials.SulfuricGas.getFluid(60)).duration(20).EUt(96L).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_light_oil").inputFluids(GTMaterials.OilLight, 150).outputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(10)).outputFluids(GTMaterials.SulfuricLightFuel.getFluid(20)).outputFluids(GTMaterials.SulfuricNaphtha.getFluid(30)).outputFluids(GTMaterials.SulfuricGas.getFluid(240)).duration(20).EUt(96L).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_heavy_oil").inputFluids(GTMaterials.OilHeavy, 100).outputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(250)).outputFluids(GTMaterials.SulfuricLightFuel.getFluid(45)).outputFluids(GTMaterials.SulfuricNaphtha.getFluid(15)).outputFluids(GTMaterials.SulfuricGas.getFluid(60)).duration(20).EUt(288L).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_raw_oil").inputFluids(GTMaterials.RawOil, 100).outputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(10)).outputFluids(GTMaterials.SulfuricLightFuel.getFluid(50)).outputFluids(GTMaterials.SulfuricNaphtha.getFluid(150)).outputFluids(GTMaterials.SulfuricGas.getFluid(60)).duration(20).EUt(96L).save();
        PetrochemRecipes.desulfurizationRecipes();
        PetrochemRecipes.distillationRecipes();
        PetrochemRecipes.distilleryRecipes();
    }

    private static void desulfurizationRecipes() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("desulfurize_natural_gas").inputFluids(GTMaterials.NaturalGas, 16000).inputFluids(GTMaterials.Hydrogen, 2000).outputFluids(GTMaterials.HydrogenSulfide.getFluid(1000)).outputFluids(GTMaterials.RefineryGas.getFluid(16000)).duration(160).EUt((long)GTValues.VA[1]).save();
    }

    private static void distillationRecipes() {
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_refinery_gas").inputFluids(GTMaterials.RefineryGas, 1000).outputFluids(GTMaterials.Butane.getFluid(60)).outputFluids(GTMaterials.Propane.getFluid(70)).outputFluids(GTMaterials.Ethane.getFluid(100)).outputFluids(GTMaterials.Methane.getFluid(750)).outputFluids(GTMaterials.Helium.getFluid(20)).duration(240).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_ethane").inputFluids(GTMaterials.HydroCrackedEthane, 1000).outputFluids(GTMaterials.Methane.getFluid(2000)).outputFluids(GTMaterials.Hydrogen.getFluid(2000)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_ethane").inputFluids(GTMaterials.SteamCrackedEthane, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 2500, 0).outputFluids(GTMaterials.Ethylene.getFluid(250)).outputFluids(GTMaterials.Methane.getFluid(1250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_ethylene").inputFluids(GTMaterials.HydroCrackedEthylene, 1000).outputFluids(GTMaterials.Ethane.getFluid(1000)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_ethylene").inputFluids(GTMaterials.SteamCrackedEthylene, 1000).outputItems(TagPrefix.dust, GTMaterials.Carbon).outputFluids(GTMaterials.Methane.getFluid(1000)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_propene").inputFluids(GTMaterials.HydroCrackedPropene, 1000).outputFluids(GTMaterials.Propane.getFluid(500)).outputFluids(GTMaterials.Ethylene.getFluid(500)).outputFluids(GTMaterials.Methane.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_propene").inputFluids(GTMaterials.SteamCrackedPropene, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 5000, 0).outputFluids(GTMaterials.Ethylene.getFluid(1000)).outputFluids(GTMaterials.Methane.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_propane").inputFluids(GTMaterials.HydroCrackedPropane, 1000).outputFluids(GTMaterials.Ethane.getFluid(1000)).outputFluids(GTMaterials.Methane.getFluid(1000)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_propane").inputFluids(GTMaterials.SteamCrackedPropane, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 2500, 0).outputFluids(GTMaterials.Ethylene.getFluid(750)).outputFluids(GTMaterials.Methane.getFluid(1250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_butane").inputFluids(GTMaterials.HydroCrackedButane, 1000).outputFluids(GTMaterials.Propane.getFluid(750)).outputFluids(GTMaterials.Ethane.getFluid(750)).outputFluids(GTMaterials.Methane.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_butane").inputFluids(GTMaterials.SteamCrackedButane, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 2500, 0).outputFluids(GTMaterials.Propane.getFluid(125)).outputFluids(GTMaterials.Ethane.getFluid(750)).outputFluids(GTMaterials.Ethylene.getFluid(750)).outputFluids(GTMaterials.Methane.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_butene").inputFluids(GTMaterials.HydroCrackedButene, 750).outputFluids(GTMaterials.Butane.getFluid(500)).outputFluids(GTMaterials.Propene.getFluid(250)).outputFluids(GTMaterials.Ethane.getFluid(250)).outputFluids(GTMaterials.Ethylene.getFluid(250)).outputFluids(GTMaterials.Methane.getFluid(250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_butene").inputFluids(GTMaterials.SteamCrackedButene, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 2500, 0).outputFluids(GTMaterials.Propene.getFluid(250)).outputFluids(GTMaterials.Ethylene.getFluid(1500)).outputFluids(GTMaterials.Methane.getFluid(250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_hydro_cracked_butadiene").inputFluids(GTMaterials.HydroCrackedButadiene, 1000).outputFluids(GTMaterials.Butene.getFluid(750)).outputFluids(GTMaterials.Ethylene.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_steam_cracked_butadiene").inputFluids(GTMaterials.SteamCrackedButadiene, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 5000, 0).outputFluids(GTMaterials.Propene.getFluid(125)).outputFluids(GTMaterials.Ethylene.getFluid(250)).outputFluids(GTMaterials.Methane.getFluid(1125)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_hydro_cracked_heavy_fuel").inputFluids(GTMaterials.LightlyHydroCrackedHeavyFuel, 1000).outputFluids(GTMaterials.LightFuel.getFluid(600)).outputFluids(GTMaterials.Naphtha.getFluid(100)).outputFluids(GTOMaterials.Cetane.getFluid(50)).outputFluids(GTMaterials.Butane.getFluid(100)).outputFluids(GTMaterials.Propane.getFluid(100)).outputFluids(GTMaterials.Ethane.getFluid(75)).outputFluids(GTMaterials.Methane.getFluid(75)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_hydro_cracked_heavy_fuel").inputFluids(GTMaterials.SeverelyHydroCrackedHeavyFuel, 1000).outputFluids(GTOMaterials.Cetane.getFluid(50)).outputFluids(GTMaterials.LightFuel.getFluid(200)).outputFluids(GTMaterials.Naphtha.getFluid(250)).outputFluids(GTMaterials.Butane.getFluid(300)).outputFluids(GTMaterials.Propane.getFluid(300)).outputFluids(GTMaterials.Ethane.getFluid(175)).outputFluids(GTMaterials.Methane.getFluid(175)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_steam_cracked_heavy_fuel").inputFluids(GTMaterials.LightlySteamCrackedHeavyFuel, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 1111, 0).outputFluids(GTMaterials.LightFuel.getFluid(300)).outputFluids(GTMaterials.Naphtha.getFluid(50)).outputFluids(GTMaterials.Toluene.getFluid(25)).outputFluids(GTMaterials.Benzene.getFluid(125)).outputFluids(GTMaterials.Butene.getFluid(25)).outputFluids(GTMaterials.Butadiene.getFluid(15)).outputFluids(GTMaterials.Propane.getFluid(3)).outputFluids(GTMaterials.Propene.getFluid(30)).outputFluids(GTMaterials.Ethane.getFluid(5)).outputFluids(GTMaterials.Ethylene.getFluid(50)).outputFluids(GTMaterials.Methane.getFluid(50)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_steam_cracked_heavy_fuel").inputFluids(GTMaterials.SeverelySteamCrackedHeavyFuel, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 3333, 0).outputFluids(GTMaterials.LightFuel.getFluid(100)).outputFluids(GTMaterials.Naphtha.getFluid(125)).outputFluids(GTMaterials.Toluene.getFluid(80)).outputFluids(GTMaterials.Benzene.getFluid(400)).outputFluids(GTMaterials.Butene.getFluid(80)).outputFluids(GTMaterials.Butadiene.getFluid(50)).outputFluids(GTMaterials.Propane.getFluid(10)).outputFluids(GTMaterials.Propene.getFluid(100)).outputFluids(GTMaterials.Ethane.getFluid(15)).outputFluids(GTMaterials.Ethylene.getFluid(150)).outputFluids(GTMaterials.Methane.getFluid(150)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_hydro_cracked_light_fuel").inputFluids(GTMaterials.LightlyHydroCrackedLightFuel, 1000).outputFluids(GTMaterials.Naphtha.getFluid(800)).outputFluids(GTOMaterials.Cetane.getFluid(50)).outputFluids(GTMaterials.Octane.getFluid(100)).outputFluids(GTMaterials.Butane.getFluid(150)).outputFluids(GTMaterials.Propane.getFluid(200)).outputFluids(GTMaterials.Ethane.getFluid(125)).outputFluids(GTMaterials.Methane.getFluid(125)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_hydro_cracked_light_fuel").inputFluids(GTMaterials.SeverelyHydroCrackedLightFuel, 1000).outputFluids(GTMaterials.Naphtha.getFluid(200)).outputFluids(GTOMaterials.Cetane.getFluid(10)).outputFluids(GTMaterials.Octane.getFluid(20)).outputFluids(GTMaterials.Butane.getFluid(125)).outputFluids(GTMaterials.Propane.getFluid(125)).outputFluids(GTMaterials.Ethane.getFluid(1500)).outputFluids(GTMaterials.Methane.getFluid(1500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_steam_cracked_light_fuel").inputFluids(GTMaterials.LightlySteamCrackedLightFuel, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 1111, 0).outputFluids(GTMaterials.HeavyFuel.getFluid(150)).outputFluids(GTMaterials.Naphtha.getFluid(400)).outputFluids(GTMaterials.Toluene.getFluid(40)).outputFluids(GTMaterials.Benzene.getFluid(200)).outputFluids(GTMaterials.Butene.getFluid(75)).outputFluids(GTMaterials.Butadiene.getFluid(60)).outputFluids(GTMaterials.Propane.getFluid(20)).outputFluids(GTMaterials.Propene.getFluid(150)).outputFluids(GTMaterials.Ethane.getFluid(10)).outputFluids(GTMaterials.Ethylene.getFluid(50)).outputFluids(GTMaterials.Methane.getFluid(50)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_steam_cracked_light_fuel").inputFluids(GTMaterials.SeverelySteamCrackedLightFuel, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 3333, 0).outputFluids(GTMaterials.HeavyFuel.getFluid(50)).outputFluids(GTMaterials.Naphtha.getFluid(100)).outputFluids(GTMaterials.Toluene.getFluid(30)).outputFluids(GTMaterials.Benzene.getFluid(150)).outputFluids(GTMaterials.Butene.getFluid(65)).outputFluids(GTMaterials.Butadiene.getFluid(50)).outputFluids(GTMaterials.Propane.getFluid(50)).outputFluids(GTMaterials.Propene.getFluid(250)).outputFluids(GTMaterials.Ethane.getFluid(50)).outputFluids(GTMaterials.Ethylene.getFluid(250)).outputFluids(GTMaterials.Methane.getFluid(250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_hydro_cracked_naphtha").inputFluids(GTMaterials.LightlyHydroCrackedNaphtha, 1000).outputFluids(GTMaterials.Butane.getFluid(800)).outputFluids(GTMaterials.Propane.getFluid(300)).outputFluids(GTMaterials.Ethane.getFluid(250)).outputFluids(GTMaterials.Methane.getFluid(250)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_hydro_cracked_naphtha").inputFluids(GTMaterials.SeverelyHydroCrackedNaphtha, 1000).outputFluids(GTMaterials.Butane.getFluid(125)).outputFluids(GTMaterials.Propane.getFluid(125)).outputFluids(GTMaterials.Ethane.getFluid(1500)).outputFluids(GTMaterials.Methane.getFluid(1500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_steam_cracked_naphtha").inputFluids(GTMaterials.LightlySteamCrackedNaphtha, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 1111, 0).outputFluids(GTMaterials.HeavyFuel.getFluid(75)).outputFluids(GTMaterials.LightFuel.getFluid(150)).outputFluids(GTMaterials.Toluene.getFluid(40)).outputFluids(GTMaterials.Benzene.getFluid(150)).outputFluids(GTMaterials.Butene.getFluid(80)).outputFluids(GTMaterials.Butadiene.getFluid(150)).outputFluids(GTMaterials.Propane.getFluid(15)).outputFluids(GTMaterials.Propene.getFluid(200)).outputFluids(GTMaterials.Ethane.getFluid(35)).outputFluids(GTMaterials.Ethylene.getFluid(200)).outputFluids(GTMaterials.Methane.getFluid(200)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_steam_cracked_naphtha").inputFluids(GTMaterials.SeverelySteamCrackedNaphtha, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 3333, 0).outputFluids(GTMaterials.HeavyFuel.getFluid(25)).outputFluids(GTMaterials.LightFuel.getFluid(50)).outputFluids(GTMaterials.Toluene.getFluid(20)).outputFluids(GTMaterials.Benzene.getFluid(100)).outputFluids(GTMaterials.Butene.getFluid(50)).outputFluids(GTMaterials.Butadiene.getFluid(50)).outputFluids(GTMaterials.Propane.getFluid(15)).outputFluids(GTMaterials.Propene.getFluid(300)).outputFluids(GTMaterials.Ethane.getFluid(65)).outputFluids(GTMaterials.Ethylene.getFluid(500)).outputFluids(GTMaterials.Methane.getFluid(500)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_hydro_cracked_gas").inputFluids(GTMaterials.LightlyHydroCrackedGas, 1000).outputFluids(GTMaterials.Methane.getFluid(1400)).outputFluids(GTMaterials.Hydrogen.getFluid(1340)).outputFluids(GTMaterials.Helium.getFluid(20)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_hydro_cracked_gas").inputFluids(GTMaterials.SeverelyHydroCrackedGas, 1000).outputFluids(GTMaterials.Methane.getFluid(1400)).outputFluids(GTMaterials.Hydrogen.getFluid(4340)).outputFluids(GTMaterials.Helium.getFluid(20)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_lightly_steam_cracked_gas").inputFluids(GTMaterials.LightlySteamCrackedGas, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 1111, 0).outputFluids(GTMaterials.Propene.getFluid(45)).outputFluids(GTMaterials.Ethane.getFluid(8)).outputFluids(GTMaterials.Ethylene.getFluid(85)).outputFluids(GTMaterials.Methane.getFluid(1026)).outputFluids(GTMaterials.Helium.getFluid(20)).duration(120).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLATION_RECIPES.recipeBuilder("distill_severely_steam_cracked_gas").inputFluids(GTMaterials.SeverelySteamCrackedGas, 1000).chancedOutput(TagPrefix.dust, GTMaterials.Carbon, 1111, 0).outputFluids(GTMaterials.Propene.getFluid(8)).outputFluids(GTMaterials.Ethane.getFluid(45)).outputFluids(GTMaterials.Ethylene.getFluid(92)).outputFluids(GTMaterials.Methane.getFluid(1018)).outputFluids(GTMaterials.Helium.getFluid(20)).duration(120).EUt((long)GTValues.VA[2]).save();
    }

    private static void distilleryRecipes() {
        GTORecipeTypes.DISTILLERY_RECIPES.recipeBuilder("distill_toluene_to_light_fuel").circuitMeta(1).inputFluids(GTMaterials.Toluene, 30).outputFluids(GTMaterials.LightFuel.getFluid(30)).duration(160).EUt(24L).save();
        GTORecipeTypes.DISTILLERY_RECIPES.recipeBuilder("distill_heavy_fuel_to_toluene").circuitMeta(1).inputFluids(GTMaterials.HeavyFuel, 10).outputFluids(GTMaterials.Toluene.getFluid(4)).duration(16).EUt(24L).save();
        GTORecipeTypes.DISTILLERY_RECIPES.recipeBuilder("distill_heavy_fuel_to_benzene").circuitMeta(2).inputFluids(GTMaterials.HeavyFuel, 10).outputFluids(GTMaterials.Benzene.getFluid(4)).duration(16).EUt(24L).save();
        GTORecipeTypes.DISTILLERY_RECIPES.recipeBuilder("distill_heavy_fuel_to_phenol").circuitMeta(3).inputFluids(GTMaterials.HeavyFuel, 20).outputFluids(GTMaterials.Phenol.getFluid(5)).duration(32).EUt(24L).save();
    }

    private static void lightlyCrack(Material raw, Material hydroCracked, Material steamCracked) {
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("lightly_hydro_crack_" + raw.getName()).circuitMeta(1).inputFluids(raw, 1000).inputFluids(GTMaterials.Hydrogen, 2000).outputFluids(hydroCracked.getFluid(1000)).duration(80).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("lightly_hydro_crack_" + raw.getName()).circuitMeta(1).inputFluids(raw, 500).inputFluids(GTMaterials.Hydrogen, 1000).outputFluids(hydroCracked.getFluid(250)).duration(80).EUt(30L).save();
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("lightly_steam_crack_" + raw.getName()).circuitMeta(1).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(1000)).duration(80).EUt(240L).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("lightly_steam_crack_" + raw.getName()).circuitMeta(1).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(500)).duration(160).duration(GTValues.VA[1]).save();
    }

    private static void moderatelyCrack(Material raw, Material hydroCracked, Material steamCracked) {
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("hydro_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 1000).inputFluids(GTMaterials.Hydrogen, 4000).outputFluids(hydroCracked.getFluid(1000)).duration(120).EUt(180L).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("hydro_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 500).inputFluids(GTMaterials.Hydrogen, 2000).outputFluids(hydroCracked.getFluid(250)).duration(60).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("steam_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(1000)).duration(120).EUt(360L).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("steam_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(500)).duration(240).EUt((long)GTValues.VA[1]).save();
    }

    private static void severelyCrack(Material raw, Material hydroCracked, Material steamCracked) {
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("severely_hydro_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 1000).inputFluids(GTMaterials.Hydrogen, 6000).outputFluids(hydroCracked.getFluid(1000)).duration(160).EUt(240L).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("severely_hydro_crack_" + raw.getName()).circuitMeta(2).inputFluids(raw, 500).inputFluids(GTMaterials.Hydrogen, 3000).outputFluids(hydroCracked.getFluid(250)).duration(160).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("severely_steam_crack_" + raw.getName()).circuitMeta(3).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(1000)).duration(160).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("severely_steam_crack_" + raw.getName()).circuitMeta(3).inputFluids(raw, 1000).inputFluids(GTMaterials.Steam, 1000).outputFluids(steamCracked.getFluid(500)).duration(240).EUt((long)GTValues.VA[1]).save();
    }
}

