/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.GTOUtils;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

final class GTOWireRecipeHandler {
    private static final Map<TagPrefix, Integer> INSULATION_AMOUNT = ImmutableMap.of((Object)TagPrefix.cableGtSingle, (Object)1, (Object)TagPrefix.cableGtDouble, (Object)1, (Object)TagPrefix.cableGtQuadruple, (Object)2, (Object)TagPrefix.cableGtOctal, (Object)3, (Object)TagPrefix.cableGtHex, (Object)5);

    GTOWireRecipeHandler() {
    }

    static void run(@NotNull Material material) {
        WireProperties property = (WireProperties)material.getProperty(PropertyKey.WIRE);
        if (property == null) {
            return;
        }
        GTOWireRecipeHandler.processWires(material, property);
        if (property.isSuperconductor()) {
            return;
        }
        GTOWireRecipeHandler.generateCableCovering(TagPrefix.wireGtSingle, material, property);
        GTOWireRecipeHandler.generateCableCovering(TagPrefix.wireGtDouble, material, property);
        GTOWireRecipeHandler.generateCableCovering(TagPrefix.wireGtQuadruple, material, property);
        GTOWireRecipeHandler.generateCableCovering(TagPrefix.wireGtOctal, material, property);
        GTOWireRecipeHandler.generateCableCovering(TagPrefix.wireGtHex, material, property);
    }

    private static void processWires(Material material, WireProperties property) {
        ItemStack wireSingle = ChemicalHelper.get((TagPrefix)(property.isSuperconductor() && property.getVoltage() < (long)GTValues.VA[14] ? GTOTagPrefix.SUPERCONDUCTOR_BASE : TagPrefix.wireGtSingle), (Material)material, (int)2);
        if (wireSingle.m_41619_()) {
            return;
        }
        TagPrefix prefix = material.hasProperty(PropertyKey.INGOT) ? TagPrefix.ingot : (material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.dust);
        int mass = (int)material.getMass();
        long voltageMultiplier = GTOUtils.getVoltageMultiplier((Material)material);
        Integer voltage = GTOMaterials.MATERIAL_VOLTAGE.get(material);
        if (voltage != null) {
            voltageMultiplier = voltage.intValue();
        }
        GTORecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire").inputItems(prefix, material).outputItems(wireSingle).duration(mass).EUt(voltageMultiplier).save();
        if (!material.hasFlag(MaterialFlags.NO_WORKING) && material.hasFlag(MaterialFlags.GENERATE_PLATE) && mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("%s_wire_single", material.getName()), (ItemStack)wireSingle.m_255036_(1), (Object[])new Object[]{"Xx", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material)});
        }
    }

    private static void generateCableCovering(TagPrefix wirePrefix, Material material, WireProperties property) {
        RecipeBuilder builder;
        ItemStack wire = ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material);
        if (wire.m_41619_()) {
            return;
        }
        TagPrefix cablePrefix = TagPrefix.get((String)("cable" + wirePrefix.name().substring(4)));
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        if (voltageTier <= 1) {
            GTOWireRecipeHandler.generateManualRecipe(wirePrefix, material, cablePrefix, voltageTier == 0);
        }
        if (voltageTier < 5) {
            builder = GTORecipeTypes.LAMINATOR_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + wirePrefix.name().toLowerCase() + "_rubber").EUt((long)GTValues.VA[0]).duration(100).inputItems(wire).outputItems(cablePrefix, material).inputFluids(GTMaterials.Rubber.getFluid(144 * insulationAmount));
            if (voltageTier == 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            builder.save();
        }
        if (voltageTier < 9) {
            builder = GTORecipeTypes.LAMINATOR_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + wirePrefix.name().toLowerCase() + "_silicone").EUt((long)GTValues.VA[0]).duration(100).inputItems(wire).outputItems(cablePrefix, material);
            if (voltageTier >= 6) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
            }
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            builder.inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / (voltageTier >= 6 ? 1 : 2))).save();
        }
        builder = GTORecipeTypes.LAMINATOR_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + wirePrefix.name().toLowerCase() + "_styrene_butadiene").EUt((long)GTValues.VA[0]).duration(100).inputItems(wire).outputItems(cablePrefix, material);
        if (voltageTier > 10) {
            builder.inputItems(GTOItems.HIGHLY_INSULATING_FOIL.asStack(insulationAmount));
        }
        builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        builder.inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / (voltageTier > 10 ? 1 : (voltageTier >= 6 ? 2 : 4)))).save();
    }

    private static void generateManualRecipe(TagPrefix wirePrefix, Material material, TagPrefix cablePrefix, boolean manual) {
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        if (manual) {
            Object[] ingredients = new Object[insulationAmount + 1];
            ingredients[0] = new MaterialEntry(wirePrefix, material);
            for (int i = 1; i <= insulationAmount; ++i) {
                ingredients[i] = ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)GTMaterials.Rubber);
            }
            VanillaRecipeHelper.addShapelessRecipe((String)String.format("%s_cable_%d", material.getName(), (int)((wirePrefix.getMaterialAmount(material) << 1) / 3628800L)), (ItemStack)ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material), (Object[])ingredients);
        }
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + wirePrefix.name().toLowerCase()).inputItems(wirePrefix, material).inputItems(TagPrefix.plate, GTMaterials.Rubber, insulationAmount).outputItems(cablePrefix, material).duration(100).EUt((long)GTValues.VA[0]).save();
    }
}

