/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.utils.GTOUtils;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

final class GTOPipeRecipeHandler {
    GTOPipeRecipeHandler() {
    }

    static void run(@NotNull Material material) {
        if (material.hasProperty(PropertyKey.FLUID_PIPE)) {
            GTOPipeRecipeHandler.processPipeTiny(material);
            GTOPipeRecipeHandler.processPipeSmall(TagPrefix.pipeSmallFluid, material);
            GTOPipeRecipeHandler.processPipeNormal(TagPrefix.pipeNormalFluid, material);
            GTOPipeRecipeHandler.processPipeLarge(TagPrefix.pipeLargeFluid, material);
            GTOPipeRecipeHandler.processPipeHuge(TagPrefix.pipeHugeFluid, material);
            GTOPipeRecipeHandler.processPipeQuadruple(material);
            GTOPipeRecipeHandler.processPipeNonuple(material);
        } else if (material.hasProperty(PropertyKey.ITEM_PIPE)) {
            GTOPipeRecipeHandler.processPipeSmall(TagPrefix.pipeSmallItem, material);
            GTOPipeRecipeHandler.processPipeNormal(TagPrefix.pipeNormalItem, material);
            GTOPipeRecipeHandler.processPipeLarge(TagPrefix.pipeLargeItem, material);
            GTOPipeRecipeHandler.processPipeHuge(TagPrefix.pipeHugeItem, material);
            GTOPipeRecipeHandler.processRestrictivePipe(TagPrefix.pipeSmallRestrictive, TagPrefix.pipeSmallItem, material);
            GTOPipeRecipeHandler.processRestrictivePipe(TagPrefix.pipeNormalRestrictive, TagPrefix.pipeNormalItem, material);
            GTOPipeRecipeHandler.processRestrictivePipe(TagPrefix.pipeLargeRestrictive, TagPrefix.pipeLargeItem, material);
            GTOPipeRecipeHandler.processRestrictivePipe(TagPrefix.pipeHugeRestrictive, TagPrefix.pipeHugeItem, material);
        }
    }

    private static void processRestrictivePipe(@NotNull TagPrefix prefix, @NotNull TagPrefix unrestrictive, @NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        ItemStack unrestrictiveStack = ChemicalHelper.get((TagPrefix)unrestrictive, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_" + prefix.name).inputItems(unrestrictiveStack).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems(pipeStack).duration(20).EUt((long)GTValues.VA[1]).save();
        VanillaRecipeHelper.addShapedRecipe((String)FormattingUtil.toLowerCaseUnderscore((String)(String.valueOf(prefix) + "_" + material.getName())), (ItemStack)pipeStack, (Object[])new Object[]{"PR", "Rh", Character.valueOf('P'), unrestrictiveStack, Character.valueOf('R'), ChemicalHelper.get((TagPrefix)TagPrefix.ring, (Material)GTMaterials.Iron)});
    }

    private static void processPipeTiny(@NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)TagPrefix.pipeTinyFluid, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe").inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(pipeStack.m_255036_(2)).duration((int)material.getMass()).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe_dust").inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(pipeStack.m_255036_(2)).duration((int)material.getMass()).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        } else if (material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("tiny_%s_pipe", material.getName()), (ItemStack)pipeStack.m_255036_(2), (Object[])new Object[]{" s ", "hXw", Character.valueOf('X'), new MaterialEntry(GTOTagPrefix.CURVED_PLATE, material)});
        }
    }

    private static void processPipeSmall(@NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe").inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe_dust").inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        } else if (material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("small_%s_pipe", material.getName()), (ItemStack)pipeStack, (Object[])new Object[]{"wXh", Character.valueOf('X'), new MaterialEntry(GTOTagPrefix.CURVED_PLATE, material)});
        }
    }

    private static void processPipeNormal(@NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe").inputItems(TagPrefix.ingot, material, 3).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe_dust").inputItems(TagPrefix.dust, material, 3).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        } else if (material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("medium_%s_pipe", material.getName()), (ItemStack)pipeStack, (Object[])new Object[]{"XXX", "w h", Character.valueOf('X'), new MaterialEntry(GTOTagPrefix.CURVED_PLATE, material)});
        }
    }

    private static void processPipeLarge(@NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe").inputItems(TagPrefix.ingot, material, 6).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe_dust").inputItems(TagPrefix.dust, material, 6).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        } else if (material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("large_%s_pipe", material.getName()), (ItemStack)pipeStack, (Object[])new Object[]{"XXX", "w h", "XXX", Character.valueOf('X'), new MaterialEntry(GTOTagPrefix.CURVED_PLATE, material)});
        }
    }

    private static void processPipeHuge(@NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack pipeStack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (pipeStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe").inputItems(TagPrefix.ingot, material, 12).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe_dust").inputItems(TagPrefix.dust, material, 12).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        } else if (TagPrefix.plateDouble.doGenerateItem(material) && material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("huge_%s_pipe", material.getName()), (ItemStack)pipeStack, (Object[])new Object[]{"XXX", "w h", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plateDouble, material)});
        }
    }

    private static void processPipeQuadruple(@NotNull Material material) {
        ItemStack quadPipe = ChemicalHelper.get((TagPrefix)TagPrefix.pipeQuadrupleFluid, (Material)material);
        if (quadPipe.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get((TagPrefix)TagPrefix.pipeSmallFluid, (Material)material, (int)4);
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_quadruple_pipe").inputItems(smallPipe).circuitMeta(4).outputItems(quadPipe).duration(30).EUt((long)GTValues.VA[0]).save();
    }

    private static void processPipeNonuple(@NotNull Material material) {
        ItemStack nonuplePipe = ChemicalHelper.get((TagPrefix)TagPrefix.pipeNonupleFluid, (Material)material);
        if (nonuplePipe.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get((TagPrefix)TagPrefix.pipeSmallFluid, (Material)material, (int)9);
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_nonuple_pipe").inputItems(smallPipe).circuitMeta(9).outputItems(nonuplePipe).duration(40).EUt((long)GTValues.VA[0]).save();
    }
}

