/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.classified;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.armor.PowerlessJetpack;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOFluidStorageKey;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.multiblock.generator.FullCellGenerator;
import com.gtolib.utils.FluidUtils;
import com.gtolib.utils.TagUtils;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class FuelCell {
    public static void init() {
        int i = 0;
        for (Map.Entry materialSet : FullCellGenerator.Wrapper.ELECTROLYTES_PER_MATERIAL_PER_MILLIBUCKET.entrySet()) {
            Material material = (Material)materialSet.getKey();
            Long euPerMb = (Long)materialSet.getValue();
            ItemStack membrane = ChemicalHelper.get((TagPrefix)GTOTagPrefix.MEMBRANE_ELECTRODE, (Material)((Material)FullCellGenerator.Wrapper.MEMBRANE_MATS.get(i++)));
            GTORecipeTypes.FUEL_CELL_ENERGY_RELEASE_RECIPES.recipeBuilder(material.getName() + "_release").notConsumable(membrane.m_41777_()).inputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_ANODE), 20L).inputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_CATHODE), 20L).outputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_ANODE), 19L).outputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_CATHODE), 19L).EUt(-euPerMb.longValue() * 5L).duration(20).save();
            for (Map.Entry materialSet2 : ImmutableMap.copyOf(FullCellGenerator.Wrapper.ELECTROLYTES_PER_MATERIAL_PER_MILLIBUCKET).entrySet()) {
                Material material2 = (Material)materialSet2.getKey();
                Long euPerMb2 = (Long)materialSet2.getValue();
                long partialEuPerMb1 = euPerMb >> 8;
                long partialEuPerMb2 = euPerMb2 >> 8;
                if (material == material2) continue;
                GTORecipeTypes.FUEL_CELL_ENERGY_TRANSFER_RECIPES.recipeBuilder(material.getName() + "_to_" + material2.getName() + "_absorption").notConsumable(membrane.m_255036_(2)).inputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_ANODE), 20L * partialEuPerMb2).inputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_CATHODE), 20L * partialEuPerMb2).inputFluids(material2.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_ANODE), 19L * partialEuPerMb1).inputFluids(material2.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_CATHODE), 19L * partialEuPerMb1).outputFluids(material2.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_ANODE), 19L * partialEuPerMb1).outputFluids(material2.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_CATHODE), 19L * partialEuPerMb1).outputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_ANODE), 19L * partialEuPerMb2).outputFluids(material.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_CATHODE), 19L * partialEuPerMb2).EUt(1L).duration(20).addData("efficiency", (float)partialEuPerMb1 / (float)partialEuPerMb2 * (float)euPerMb2.longValue() / (float)euPerMb.longValue() * 0.95f).save();
            }
        }
        PowerlessJetpack.FUELS.forEach((fluidStack, duration) -> {
            Fluid fluid = fluidStack.getStacks()[0].getFluid();
            long totalEu = (long)duration.intValue() * 4L;
            GTORecipeTypes.FUEL_CELL_ENERGY_ABSORPTION_RECIPES.recipeBuilder(FluidUtils.getIdLocation((Fluid)fluid).m_135815_()).notConsumable(TagUtils.createTGItemTag((String)"membrane_electrodes")).inputFluids(GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID), (long)fluidStack.getAmount()).inputFluids(fluid, (long)fluidStack.getAmount()).EUt(1L).duration(20).addData("convertedEnergy", totalEu).save();
        });
    }
}

