/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.builder.research.ExResearchManager;
import com.gtolib.api.recipe.RecipeBuilder;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;

public final class DataAnalysisRecipeBuilder {
    private int inputData = 0;
    private int[] outputData = new int[0];
    private int[] outputWeights = new int[0];
    private int errorWeight = 2000;
    private ItemStack catalyst;
    private long eut = GTValues.VA[6];
    private int cwut = 0;
    private int totalCWU = 0;

    public static DataAnalysisRecipeBuilder buildRecipe() {
        return new DataAnalysisRecipeBuilder();
    }

    public DataAnalysisRecipeBuilder catalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public DataAnalysisRecipeBuilder inputData(int data) {
        this.inputData = data;
        return this;
    }

    public DataAnalysisRecipeBuilder outputData(int data, int weight) {
        if (this.outputData.length > 5) {
            return this;
        }
        if (weight < 0) {
            throw new IllegalArgumentException("Output weights cannot be negative");
        }
        this.outputData = Arrays.copyOf(this.outputData, this.outputData.length + 1);
        this.outputData[this.outputData.length - 1] = data;
        this.outputWeights = Arrays.copyOf(this.outputWeights, this.outputWeights.length + 1);
        this.outputWeights[this.outputWeights.length - 1] = weight;
        return this;
    }

    public DataAnalysisRecipeBuilder errorWeight(int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u6570\u636e\u6743\u91cd\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        this.errorWeight = weight;
        return this;
    }

    public DataAnalysisRecipeBuilder EUt(long eut) {
        this.eut = eut;
        return this;
    }

    public DataAnalysisRecipeBuilder CWUt(int cwut) {
        this.cwut = cwut;
        this.totalCWU = cwut * 800;
        return this;
    }

    public DataAnalysisRecipeBuilder CWUt(int cwut, int totalCWU) {
        this.cwut = cwut;
        this.totalCWU = totalCWU;
        return this;
    }

    public void save() {
        if (this.cwut > this.totalCWU) {
            throw new IllegalStateException("Total CWU cannot be greater than CWU/t!");
        }
        if (this.catalyst == null) {
            throw new IllegalStateException("Catalyst input required");
        }
        ExResearchManager.DataCrystal dataCrystal = (ExResearchManager.DataCrystal)ExResearchManager.scanningMap.get(this.inputData);
        if (dataCrystal == null) {
            throw new IllegalStateException("Unknown input items");
        }
        int crystalTire = dataCrystal.tier();
        if (crystalTire < 0 || crystalTire > 5) {
            throw new IllegalStateException("DataCrystal Out of index");
        }
        int totalWeight = this.errorWeight;
        for (int w : this.outputWeights) {
            totalWeight += w;
        }
        int[] outputChances = new int[this.outputWeights.length];
        int sumNormalized = 0;
        for (int i = 0; i < this.outputWeights.length; ++i) {
            outputChances[i] = (int)((double)this.outputWeights[i] / (double)totalWeight * 10000.0);
            sumNormalized += outputChances[i];
        }
        int errorChance = (int)((double)this.errorWeight / (double)totalWeight * 10000.0);
        int difference = 10000 - sumNormalized - errorChance;
        if (difference != 0) {
            errorChance += difference;
        }
        RecipeBuilder build = GTORecipeTypes.DATA_ANALYSIS_RECIPES.recipeBuilder(dataCrystal.data());
        build.notConsumable(this.catalyst).inputItems(ExResearchManager.EmptyDataCrystalList.get(crystalTire)).notConsumable(ExResearchManager.getDataCrystal(this.inputData));
        for (int i = 0; i < this.outputData.length; ++i) {
            build.chancedOutput(ExResearchManager.getDataCrystal(this.outputData[i]), outputChances[i], 0);
        }
        build.chancedOutput(ExResearchManager.ErrorDataCrystalList.get(crystalTire), errorChance, 0).EUt(this.eut).CWUt(this.cwut).totalCWU(this.totalCWU).save();
    }
}

