/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.crafting.RecipeTerraPlate;

public final class TerrestrialAgglomerationRecipeBuilder {
    private final ResourceLocation id;
    private ItemStack output;
    private int mana;
    private final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();

    public static TerrestrialAgglomerationRecipeBuilder builder(String name) {
        return new TerrestrialAgglomerationRecipeBuilder(GTOCore.id((String)("terra_plate/" + name)));
    }

    private TerrestrialAgglomerationRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public TerrestrialAgglomerationRecipeBuilder output(ItemLike output) {
        return this.output(new ItemStack(output));
    }

    public TerrestrialAgglomerationRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public TerrestrialAgglomerationRecipeBuilder mana(int mana) {
        this.mana = mana;
        return this;
    }

    public TerrestrialAgglomerationRecipeBuilder addIngredient(Ingredient ingredient) {
        if (ingredient != null) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public TerrestrialAgglomerationRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public TerrestrialAgglomerationRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public void save() {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients added to terrestrial agglomeration recipe");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output specified for terrestrial agglomeration recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new RecipeTerraPlate(this.id, this.mana, this.ingredients, this.output));
    }
}

