/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import java.util.ArrayList;
import java.util.List;
import mythicbotany.rune.RuneRitualRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class RuneRitualRecipeBuilder {
    private final ResourceLocation id;
    private Ingredient centerRune;
    private final List<RuneRitualRecipe.RunePosition> runes = new ArrayList<RuneRitualRecipe.RunePosition>();
    private int mana = 0;
    private int ticks = 200;
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();

    public static RuneRitualRecipeBuilder builder(String name) {
        return new RuneRitualRecipeBuilder(GTOCore.id((String)("rune_ritual/" + name)));
    }

    private RuneRitualRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public RuneRitualRecipeBuilder centerRune(Ingredient centerRune) {
        this.centerRune = centerRune;
        return this;
    }

    public RuneRitualRecipeBuilder centerRune(ItemLike centerRune) {
        return this.centerRune(Ingredient.m_43929_((ItemLike[])new ItemLike[]{centerRune}));
    }

    public RuneRitualRecipeBuilder centerRune(TagKey<Item> centerRuneTag) {
        return this.centerRune(Ingredient.m_204132_(centerRuneTag));
    }

    public RuneRitualRecipeBuilder addOuterRune(Ingredient rune, int x, int z, boolean consume) {
        this.runes.add(new RuneRitualRecipe.RunePosition(rune, x, z, consume));
        return this;
    }

    public RuneRitualRecipeBuilder addOuterRune(ItemLike rune, int x, int z, boolean consume) {
        return this.addOuterRune(Ingredient.m_43929_((ItemLike[])new ItemLike[]{rune}), x, z, consume);
    }

    public RuneRitualRecipeBuilder addOuterRune(TagKey<Item> runeTag, int x, int z, boolean consume) {
        return this.addOuterRune(Ingredient.m_204132_(runeTag), x, z, consume);
    }

    public RuneRitualRecipeBuilder mana(int mana) {
        this.mana = mana;
        return this;
    }

    public RuneRitualRecipeBuilder ticks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public RuneRitualRecipeBuilder addInput(Ingredient input) {
        this.inputs.add(input);
        return this;
    }

    public RuneRitualRecipeBuilder addInput(ItemLike input) {
        return this.addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
    }

    public RuneRitualRecipeBuilder addInput(TagKey<Item> inputTag) {
        return this.addInput(Ingredient.m_204132_(inputTag));
    }

    public RuneRitualRecipeBuilder addOutput(ItemStack output) {
        this.outputs.add(output);
        return this;
    }

    public RuneRitualRecipeBuilder addOutput(ItemLike output) {
        return this.addOutput(new ItemStack(output));
    }

    public void save() {
        if (this.centerRune == null) {
            throw new IllegalStateException("\u7b26\u6587\u4eea\u5f0f\u914d\u65b9 " + String.valueOf(this.id) + " \u672a\u8bbe\u7f6e\u4e2d\u5fc3\u7b26\u6587\uff01");
        }
        if (this.outputs.isEmpty()) {
            throw new IllegalStateException("\u7b26\u6587\u4eea\u5f0f\u914d\u65b9 " + String.valueOf(this.id) + " \u672a\u8bbe\u7f6e\u8f93\u51fa\u7269\u54c1\uff01");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new RuneRitualRecipe(this.id, this.centerRune, this.runes, this.mana, this.ticks, this.inputs, this.outputs, null, null));
    }
}

