/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.MarimorphosisRecipe;
import vazkii.botania.common.crafting.StateIngredientHelper;

public final class MarimorphosisRecipeBuilder {
    private final ResourceLocation id;
    private StateIngredient input;
    private Block output;
    private int weight = 1;
    private int biomeBonus = 11;
    private TagKey<Biome> biomeTag;

    public static MarimorphosisRecipeBuilder builder(String name) {
        return new MarimorphosisRecipeBuilder(GTOCore.id((String)("marimorphosis/" + name)));
    }

    private MarimorphosisRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    private MarimorphosisRecipeBuilder input(StateIngredient input) {
        this.input = input;
        return this;
    }

    public MarimorphosisRecipeBuilder input(Block input) {
        return this.input(StateIngredientHelper.of((Block)input));
    }

    public MarimorphosisRecipeBuilder input(TagKey<Block> inputTag) {
        return this.input(StateIngredientHelper.of(inputTag));
    }

    public MarimorphosisRecipeBuilder output(Block output) {
        this.output = output;
        return this;
    }

    public MarimorphosisRecipeBuilder weight(int weight) {
        this.weight = weight;
        return this;
    }

    public MarimorphosisRecipeBuilder biomeBonus(int biomeBonus) {
        this.biomeBonus = biomeBonus;
        return this;
    }

    public MarimorphosisRecipeBuilder biomeTag(TagKey<Biome> biomeTag) {
        this.biomeTag = biomeTag;
        return this;
    }

    public void save() {
        GTRecipes.RECIPE_MAP.put(this.id, new MarimorphosisRecipe(this.id, this.input, StateIngredientHelper.of((BlockState)this.output.m_49966_()), this.weight, CommandFunction.CacheableFunction.f_77990_, this.biomeBonus, this.biomeTag));
    }
}

