/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.crafting.BotanicalBreweryRecipe;

public final class BrewRecipeBuilder {
    private final ResourceLocation id;
    private Brew brew;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public static BrewRecipeBuilder builder(String name) {
        return new BrewRecipeBuilder(GTOCore.id((String)("brew/" + name)));
    }

    private BrewRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public BrewRecipeBuilder brew(Brew brew) {
        this.brew = brew;
        return this;
    }

    private BrewRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public BrewRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public BrewRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public void save() {
        if (this.brew == null) {
            throw new IllegalStateException("No brew specified for brew recipe");
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients added to brew recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new BotanicalBreweryRecipe(this.id, this.brew, this.ingredients.toArray(new Ingredient[0])));
    }
}

