/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.ars;

import com.arsmeteorites.arsmeteorites.common.RecipeRegistry;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Ints;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gtolib.GTOCore;
import com.gtolib.utils.RegistriesUtils;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class MeteoriteRegistryHelper {
    public static void registerMeteoriteType(String inputItemId, double source, int model, Item consumeitem, String[] blockIds, int[] weights) {
        if (model == 3 || model == 4) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b: \u8f93\u5165\u7269\u54c1 {}, \u9668\u77f3\u6a21\u578b {} \u9700\u8981\u5c42\u4fe1\u606f", (Object)inputItemId, (Object)model);
            return;
        }
        int[] layer = new int[]{0};
        MeteoriteRegistryHelper.registerMeteoriteType(inputItemId, source, model, consumeitem, blockIds, weights, layer);
    }

    public static void registerMeteoriteType(String inputItemId, double source, int model, Item consumeitem, String[] blockIds, int[] weights, int[] layer) {
        Item input = RegistriesUtils.getItem((String)inputItemId);
        if (input == Items.f_41852_) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u7269\u54c1\u4e0d\u5b58\u5728", (Object)inputItemId);
            return;
        }
        Block[] blocks = new Block[blockIds.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blocks[i] = RegistriesUtils.getBlock((String)blockIds[i]);
            if (blocks[i] != Blocks.f_50016_) continue;
            GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u65b9\u5757 {} \u4e0d\u5b58\u5728", (Object)inputItemId, (Object)blockIds[i]);
            return;
        }
        if (weights.length != blockIds.length) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u6743\u91cd\u6570\u7ec4\u957f\u5ea6\u4e0d\u5339\u914d", (Object)inputItemId);
            return;
        }
        MeteoriteRegistryHelper.registerMeteoriteType(input, source, model, consumeitem, blocks, weights, layer);
    }

    public static void registerMeteoriteType(Item input, double source, int model, Item catalysts, Block[] meteorites, int[] weights) {
        if (model == 3 || model == 4) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u9668\u77f3\u6a21\u578b {} \u9700\u8981\u5c42\u4fe1\u606f", (Object)input, (Object)model);
            return;
        }
        int[] layer = new int[]{0};
        MeteoriteRegistryHelper.registerMeteoriteType(input, source, model, catalysts, meteorites, weights, layer);
    }

    public static void registerMeteoriteType(Item input, double source, Item consumeitem, Block[] stones, int[] weights1, TagPrefix tagPrefix, Material[] material, int[] weights2) {
        Object[] ores = new Block[material.length];
        for (int i = 0; i < material.length; ++i) {
            ores[i] = ChemicalHelper.getBlock((TagPrefix)tagPrefix, (Material)material[i]);
            if (ores[i] != Blocks.f_50016_) continue;
            GTOCore.LOGGER.error("\u9668\u77f3\u7684 {}: \u5bf9\u5e94\u77ff\u77f3 {} \u4e0d\u5b58\u5728", (Object)material[i], (Object)tagPrefix);
            return;
        }
        Object[] InnerBlock = (Block[])ObjectArrays.concat((Object[])stones, (Object[])ores, Block.class);
        Block[] allBlock = (Block[])ObjectArrays.concat((Object[])InnerBlock, (Object[])stones, Block.class);
        int[] weights = Ints.concat((int[][])new int[][]{weights1, weights2, weights1});
        int[] layer = new int[]{InnerBlock.length, stones.length, 60, 10};
        MeteoriteRegistryHelper.registerMeteoriteType(input, source, 3, consumeitem, allBlock, weights, layer);
    }

    public static void registerMeteoriteType(@NotNull Item input, double source, int model, Item consumeitem, Block[] meteorites, int[] weights, int[] layer) {
        int[] newLayer;
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)input);
        String id = itemId.m_135827_() + "-" + itemId.m_135815_();
        int totalWeight = 0;
        for (int weight : weights) {
            totalWeight += weight;
        }
        if (model == 3 || model == 4) {
            if (layer.length % 2 != 0) {
                GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u5c42\u7ea7\u53c2\u6570\u9519\u8bef", (Object)input);
                return;
            }
            int TotalLayers = layer.length / 2;
            int m = meteorites.length;
            for (int i = 0; i < TotalLayers; ++i) {
                m -= layer[i];
            }
            if (m < 0) {
                GTOCore.LOGGER.error("\u65e0\u6cd5\u6ce8\u518c\u9668\u77f3\u7c7b\u578b {}: \u5c42\u4e2d\u65b9\u5757\u6570\u91cf\u5927\u4e8e\u603b\u65b9\u5757\u6570", (Object)input);
                return;
            }
            int[] TotalMeteoritesWeights = new int[TotalLayers + 2];
            TotalMeteoritesWeights[TotalLayers] = TotalLayers;
            for (int i = 0; i < TotalLayers; ++i) {
                int n = TotalLayers + 1;
                TotalMeteoritesWeights[n] = TotalMeteoritesWeights[n] + layer[TotalLayers + i];
            }
            int k = 0;
            for (int i = 0; i < TotalLayers; ++i) {
                for (int j = 0; j < layer[i]; ++j) {
                    int n = i;
                    TotalMeteoritesWeights[n] = TotalMeteoritesWeights[n] + weights[k + j];
                }
                k += layer[i];
            }
            newLayer = IntStream.concat(Arrays.stream(layer), Arrays.stream(TotalMeteoritesWeights)).toArray();
        } else {
            newLayer = layer;
        }
        try {
            RecipeRegistry.registerMeteoriteType((RecipeRegistry.MeteoriteType)new RecipeRegistry.MeteoriteType(id, input, source, model, consumeitem, meteorites, weights, totalWeight, newLayer));
        }
        catch (IllegalStateException e) {
            GTOCore.LOGGER.error("\u6ce8\u518c\u9668\u77f3\u7c7b\u578b\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

