/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.lootTables.GTOLootTool;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLogicFunction
implements LootItemFunction {
    private final LootLogic logic;

    public CustomLogicFunction(LootLogic logic) {
        this.logic = logic;
    }

    public ItemStack apply(ItemStack stack, LootContext context) {
        ServerLevel level = context.m_78952_();
        if (level.m_5776_()) {
            return stack;
        }
        Entity thisEntity = (Entity)this.getParam(context, LootContextParams.f_81455_);
        Player lastDamagePlayer = (Player)this.getParam(context, LootContextParams.f_81456_);
        DamageSource damageSource = (DamageSource)this.getParam(context, LootContextParams.f_81457_);
        Entity killerEntity = (Entity)this.getParam(context, LootContextParams.f_81458_);
        Entity directKiller = (Entity)this.getParam(context, LootContextParams.f_81459_);
        Vec3 origin = (Vec3)this.getParam(context, LootContextParams.f_81460_);
        BlockState blockState = (BlockState)this.getParam(context, LootContextParams.f_81461_);
        BlockEntity blockEntity = (BlockEntity)this.getParam(context, LootContextParams.f_81462_);
        ItemStack tool = this.getParamOrDefault(context, LootContextParams.f_81463_, ItemStack.f_41583_);
        Float explosionRadius = (Float)this.getParam(context, LootContextParams.f_81464_);
        this.logic.execute(level, thisEntity, lastDamagePlayer, damageSource, killerEntity, directKiller, origin, blockState, blockEntity, tool, explosionRadius, stack);
        return stack;
    }

    private <T> T getParam(LootContext context, LootContextParam<T> param) {
        return (T)context.m_78953_(param);
    }

    private <T> T getParamOrDefault(LootContext context, LootContextParam<T> param, T defaultValue) {
        Object value = context.m_78953_(param);
        return (T)(value != null ? value : defaultValue);
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return null;
    }

    @FunctionalInterface
    public static interface LootLogic {
        public void execute(@NotNull ServerLevel var1, @Nullable Entity var2, @Nullable Player var3, @Nullable DamageSource var4, @Nullable Entity var5, @Nullable Entity var6, @Nullable Vec3 var7, @Nullable BlockState var8, @Nullable BlockEntity var9, @NotNull ItemStack var10, @Nullable Float var11, @NotNull ItemStack var12);
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final LootLogic logic;

        public Builder(LootLogic logic) {
            this.logic = logic;
        }

        @NotNull
        public CustomLogicFunction build() {
            return new CustomLogicFunction(this.logic);
        }
    }
}

