/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.lang;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gtocore.api.machine.part.GTOPartAbility;
import com.gtocore.client.Tooltips;
import com.gtocore.common.data.GTOBedrockFluids;
import com.gtocore.common.data.GTOFluidStorageKey;
import com.gtocore.common.data.GTOFluids;
import com.gtocore.common.data.GTORecipeCategories;
import com.gtocore.common.data.translation.GTOItemTooltips;
import com.gtocore.common.item.misc.OrganType;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformTemplateStorage;
import com.gtocore.data.lang.BlockLang;
import com.gtocore.data.lang.ItemLang;
import com.gtocore.data.lang.MachineLang;
import com.gtocore.data.recipe.research.AnalyzeData;
import com.gtocore.data.transaction.data.GTOTrade;
import com.gtocore.data.transaction.data.TradeLang;
import com.gtolib.api.annotation.component_builder.TranslationKeyProvider;
import com.gtolib.api.annotation.dynamic.DynamicInitialData;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.lang.CNEN;
import com.gtolib.api.lang.SimplifiedChineseLanguageProvider;
import com.gtolib.api.lang.TraditionalChineseLanguageProvider;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.registries.GTOMachineBuilder;
import com.gtolib.api.registries.MultiblockBuilder;
import com.gtolib.api.registries.ScanningClass;
import com.gtolib.utils.ChineseConverter;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.gtolib.utils.register.ItemRegisterUtils;
import com.gtolib.utils.register.MaterialsRegisterUtils;
import com.gtolib.utils.register.RecipeTypeRegisterUtils;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.data.LanguageProvider;

public final class LangHandler {
    private static final Map<String, CNEN> LANGS = new O2OOpenCacheHashMap();

    private static void addCNEN(String key, CNEN CNEN2) {
        if (LANGS.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        LANGS.put(key, CNEN2);
    }

    public static void addCNEN(String key, String cn, String en) {
        LangHandler.addCNEN(key, new CNEN(cn, en));
    }

    public static void addCN(String key, String cn) {
        LangHandler.addCNEN(key, cn, null);
    }

    private static void init() {
        GTOItemTooltips.INSTANCE.initLanguage();
        GTOFluids.LANG.forEach((k, v) -> {
            LangHandler.addCN("fluid.gtocore." + k, v);
            LangHandler.addCN("item.gtocore." + k + "_bucket", v + "\u6876");
        });
        MaterialsRegisterUtils.LANG.forEach((k, v) -> LangHandler.addCNEN("material.gtocore." + k, v));
        RecipeTypeRegisterUtils.LANG.forEach((k, v) -> LangHandler.addCNEN("gtceu." + k, v));
        GTOBedrockFluids.LANG.forEach((k, v) -> LangHandler.addCNEN("gtceu.jei.bedrock_fluid." + k, v));
        ItemRegisterUtils.LANG.forEach((k, v) -> LangHandler.addCN("item.gtocore." + k, v));
        BlockRegisterUtils.LANG.forEach((k, v) -> LangHandler.addCN("block.gtocore." + k, v));
        GTORecipeCategories.LANG.forEach((k, v) -> LangHandler.addCNEN("gtceu.recipe.category." + k, v));
        GTOFluidStorageKey.initLang();
        OrganType.getEntries().forEach(it -> LangHandler.addCNEN(it.getTranslationKey(), it.getCn(), it.getKey()));
        GTOMachineBuilder.LANG.forEach(LangHandler::addCNEN);
        MultiblockBuilder.LANG.forEach(LangHandler::addCNEN);
        Tooltips.LANG.forEach(LangHandler::addCNEN);
        PlatformTemplateStorage.LANG.forEach((k, v) -> LangHandler.addCNEN("gtocore.platform." + k, v));
        AnalyzeData.INSTANCE.getLangMap().forEach((k, v) -> LangHandler.addCNEN("gtocore.data." + k, v));
        GTOPartAbility.LANG.forEach(LangHandler::addCNEN);
        ScanningClass.LANG.forEach(LangHandler::addCNEN);
        DynamicInitialData.LANG.forEach(LangHandler::addCNEN);
        TranslationKeyProvider.LANG.forEach(LangHandler::addCNEN);
        GTOTrade.init();
        TradeLang.LANG.forEach(LangHandler::addCNEN);
        for (IdleReason reasons : IdleReason.values()) {
            if (reasons.getEn() == null) continue;
            LangHandler.addCNEN(reasons.getKey(), reasons.getCn(), reasons.getEn());
        }
        Arrays.stream(Dimension.values()).forEach(d -> LangHandler.addCNEN(d.getKey(), d.getCn(), d.getEn()));
        LangHandler.addCN("entity.gtocore.task_entity", "\u4efb\u52a1\u6267\u884c\u5b9e\u4f53");
        LangHandler.addCN("itemGroup.gtocore.block", "GTO | \u65b9\u5757");
        LangHandler.addCN("itemGroup.gtocore.item", "GTO | \u7269\u54c1");
        LangHandler.addCN("itemGroup.gtocore.machine", "GTO | \u673a\u5668");
        LangHandler.addCN("itemGroup.gtocore.material_block", "GTO | \u6750\u6599\u65b9\u5757");
        LangHandler.addCN("itemGroup.gtocore.material_fluid", "GTO | \u6750\u6599\u6d41\u4f53");
        LangHandler.addCN("itemGroup.gtocore.material_item", "GTO | \u6750\u6599\u7269\u54c1");
        LangHandler.addCN("itemGroup.gtocore.material_pipe", "GTO | \u6750\u6599\u7ba1\u9053");
        for (int tier = 9; tier < 17; ++tier) {
            int a2 = 1 << 2 * (tier - 4);
            LangHandler.addCNEN("gtceu.machine.parallel_hatch_mk" + tier + ".tooltip", "\u5141\u8bb8\u540c\u65f6\u5904\u7406\u81f3\u591a" + a2 + "\u4e2a\u914d\u65b9\u3002", "Allows to run up to " + a2 + " recipes in parallel.");
        }
        LangHandler.addCNEN("gtceu.machine.available_recipe_map_5.tooltip", "\u53ef\u7528\u914d\u65b9\u7c7b\u578b\uff1a%s\uff0c%s\uff0c%s\uff0c%s\uff0c%s", "Available Recipe Types: %s, %s, %s, %s, %s");
        LangHandler.addCNEN("gtceu.machine.available_recipe_map_6.tooltip", "\u53ef\u7528\u914d\u65b9\u7c7b\u578b\uff1a%s\uff0c%s\uff0c%s\uff0c%s\uff0c%s\uff0c%s", "Available Recipe Types: %s, %s, %s, %s, %s, %s");
        LangHandler.addCNEN("key.gtocore.flyingspeed", "\u98de\u884c\u901f\u5ea6\u8c03\u8282", "Flight Speed Adjustment");
        LangHandler.addCNEN("key.gtocore.nightvision", "\u591c\u89c6\u5f00\u5173", "Night Vision Toggle");
        LangHandler.addCNEN("key.gtocore.vajra", "\u91d1\u521a\u6775\u6309\u952e", "Vajra Key");
        LangHandler.addCNEN("key.gtocore.drift", "\u98de\u884c\u60ef\u6027", "Flight Inertia");
        LangHandler.addCNEN("key.gtocore.debug_inspect", "\u8c03\u8bd5\u68c0\u67e5GUI\u69fd\u4f4d", "Debug Inspect GUI Slot");
        LangHandler.addCNEN("key.keybinding.gtocore", "GTO\u6309\u952e\u7ed1\u5b9a", "GTO Key Bindings");
        LangHandler.addCNEN("selectWorld.self_restraint_mode.enabled", "\u81ea\u6211\u7ea6\u675f\u6a21\u5f0f\u5f00\uff01", "Self-restraint mode enabled!");
        LangHandler.addCNEN("selectWorld.gto_difficulty", "GTO\u96be\u5ea6\uff1a%s", "GTO Difficulty: %s");
        LangHandler.addCNEN("selectWorld.gto_difficulty.no_suffix", "GTO\u96be\u5ea6", "GTO Difficulty");
        LangHandler.addCNEN("selectWorld.dev_mode", "\u5f00\u53d1\u8005\u6a21\u5f0f\u5df2\u542f\u7528", "Developer Mode Enabled");
        LangHandler.addCNEN("selectWorld.gto_difficulty.current", "\u4e0e\u5f53\u524d\u6e38\u620f\u96be\u5ea6\u5339\u914d", "Matches current game difficulty");
        LangHandler.addCNEN("selectWorld.gto_difficulty.not_current", "\u4e0e\u5f53\u524d\u6e38\u620f\u96be\u5ea6\u4e0d\u5339\u914d", "Does not match current game difficulty");
        LangHandler.addCNEN("message.gtocore.difficulty_mismatch", "\u670d\u52a1\u5668\u96be\u5ea6\u4e0e\u5f53\u524d\u5ba2\u6237\u7aef\u4e0d\u7b26\uff0c\u65e0\u6cd5\u52a0\u5165\u6e38\u620f\uff01\uff08\u670d\u52a1\u5668\uff1a%s\uff0c\u5f53\u524d\uff1a%s\uff09", "The server difficulty does not match the current client and cannot join the game! (Server: %s, Current: %s)");
        LangHandler.addCNEN("selectWorld.gto_difficulty.tooltip.easy", "\u7b80\u5355\u6a21\u5f0f\uff1a\u6e38\u620f\u6d41\u7a0b\u7684\u5404\u73af\u8282\uff08\u8d44\u6e90\u83b7\u53d6\uff0c\u5236\u4f5c\uff0c\u81ea\u52a8\u5316\u7b49\uff09\u5747\u6709\u5927\u91cf\u7b80\u5316\uff0c\u6e38\u620f\u96be\u5ea6\u4f4e\u3002", "Easy Mode: All aspects of the game process (resource acquisition, crafting, automation, etc.) are greatly simplified, making the game easier. ");
        LangHandler.addCNEN("selectWorld.gto_difficulty.tooltip.normal", "\u666e\u901a\u6a21\u5f0f\uff1a\u6807\u51c6\u7684GTO\u4f53\u9a8c\uff0c\u673a\u5236\u73a9\u6cd5\u5747\u4e3a\u9ed8\u8ba4\u8bbe\u5b9a\u3002", "Normal Mode: Standard GTO experience, with all mechanics and gameplay set to default. ");
        LangHandler.addCNEN("selectWorld.gto_difficulty.tooltip.expert", "\u4e13\u5bb6\u6a21\u5f0f\uff1a\u5177\u6709\u66f4\u96be\u7684\u6e38\u620f\u673a\u5236\u548c\u66f4\u590d\u6742\u7684\u914d\u65b9\uff0c\u9002\u5408\u5bfb\u6c42\u6311\u6218\u7684\u73a9\u5bb6\u3002", "Expert Mode: Features more difficult game mechanics and complex recipes, suitable for players seeking a challenge. ");
        LangHandler.addCNEN("selectWorld.gto_difficulty.tooltip.generic", "\u5177\u4f53\u673a\u5236\u53ef\u5728config/gtocore/gtocore_startup.cfg\u4e2d\u67e5\u770b\u3002", "Specific mechanics can be found in config/gtocore/gtocore_startup.cfg. ");
        LangHandler.addCNEN("structure_writer.export_order", "\u5bfc\u51fa\u987a\u5e8f\uff1a C:%s  S:%s  A:%s", "Export Order: C:%s  S:%s  A:%s");
        LangHandler.addCNEN("structure_writer.structural_scale", "\u7ed3\u6784\u89c4\u6a21\uff1a X:%s  Y:%s  Z:%s", "Structural Scale: X:%s  Y:%s  Z:%s");
        LangHandler.addCNEN("gtocore.pattern.blocking_mode", "\u5bb9\u5668\u6709\u4efb\u4f55\u5185\u5bb9\u65f6\u963b\u6b62\u63d2\u5165", "Block insertion when the container has any content");
        LangHandler.addCNEN("gtocore.pattern.blocking_reverse", "\u975e\u540c\u4e00\u6837\u677f\u65f6\u963b\u6b62\u63d2\u5165", "Prevent insertion when not using the same pattern");
        LangHandler.addCNEN("gtocore.pattern.blocking_parallel", "\u5e76\u884c\u53d1\u914d\u540e\u5bb9\u5668\u5185\u5b58\u5728\u5408\u6210\u6750\u6599\u65f6\u6682\u505c\u53d1\u9001", "Prevent insertion after parallel allocation if container has synthetic materials");
        LangHandler.addCNEN("gtocore.pattern.multiply", "\u6837\u677f\u914d\u65b9 x %s", "Pattern Recipe x %s");
        LangHandler.addCNEN("gtocore.pattern.tooltip.multiply", "\u5c06\u6837\u677f\u6750\u6599\u6570\u91cf x %s", "Multiply Pattern materials amount by %s");
        LangHandler.addCNEN("gtocore.pattern.divide", "\u6837\u677f\u914d\u65b9 \u00f7 %s", "Pattern Recipe \u00f7 %s");
        LangHandler.addCNEN("gtocore.pattern.tooltip.divide", "\u5c06\u6837\u677f\u6750\u6599\u6570\u91cf \u00f7 %s", "Divide Pattern materials amount by %s");
        LangHandler.addCNEN("gtocore.pattern.clearSecOutput", "\u6e05\u9664\u6837\u677f\u526f\u4ea7\u7269", "Clear pattern byproducts");
        LangHandler.addCNEN("gtocore.pattern.tooltip.clearSecOutput", "\u6e05\u9664\u6837\u677f\u526f\u4ea7\u7269", "Clear pattern byproducts");
        LangHandler.addCNEN("gtocore.gtm", "\u6574\u5408\u5305\u4f7f\u7528\u7684GregTech-Modern\u6a21\u7ec4\uff0c\u4ee5\u53caApplied Energetics 2\u6a21\u7ec4\u5747\u4e3a\u975e\u5b98\u65b9\u7248\u672c\uff0c\u5982\u679c\u60a8\u9047\u5230\u4efb\u4f55\u95ee\u9898\u6216\u6709\u4efb\u4f55\u5efa\u8bae\uff0c\u8bf7\u524d\u5f80%s\u63d0\u4f9b\u53cd\u9988\uff0c\u800c\u4e0d\u662f\u6a21\u7ec4\u5b98\u65b9\u6e20\u9053", "The GregTech-Modern and Applied Energetics 2 mod used in the modpack is an unofficial version. If you encounter any issues or have any suggestions, please go to %s to provide feedback instead of the official mod channel.");
        LangHandler.addCNEN("gtocore.dev", "\u5f53\u524d\u7248\u672c\u662f\u5f00\u53d1\u6d4b\u8bd5\u7248\u672c\uff0c\u4e0d\u80fd\u4fdd\u8bc1\u5185\u5bb9\u7684\u7a33\u5b9a\u6027\u548c\u5b8c\u6574\u6027\u3002\u5982\u679c\u60a8\u9047\u5230\u4efb\u4f55\u95ee\u9898\u6216\u6709\u4efb\u4f55\u5efa\u8bae\uff0c\u8bf7\u524d\u5f80%s\u63d0\u4f9b\u53cd\u9988\u3002", "The current version is a development test version and cannot guarantee the stability and completeness of the content. If you encounter any issues or have any suggestions, please go to %s to provide feedback.");
        LangHandler.addCNEN("gtocore.fly_speed_reset", "\u98de\u884c\u901f\u5ea6\u5df2\u91cd\u7f6e", "fly Speed Reset");
        LangHandler.addCNEN("gtocore.fly_speed", "\u98de\u884c\u901f\u5ea6 x%s", "fly Speed x%s");
        LangHandler.addCNEN("gtocore.reach_limit", "\u8fbe\u5230\u6781\u9650", "Reach Limit");
        LangHandler.addCNEN("gtocore.me_any", "ME\u4ed3\u5141\u8bb8\u4efb\u610f\u9762\u8fde\u63a5", "ME hatch allows connection from any side.");
        LangHandler.addCNEN("gtocore.me_front", "ME\u4ed3\u53ea\u5141\u8bb8\u6b63\u9762\u8fde\u63a5", "ME hatch only allows connection from the front side.");
        LangHandler.addCNEN("gtocore.unlocked", "\u89e3\u9501\u7684", "Unlocked");
        LangHandler.addCNEN("gtocore.ununlocked", "\u672a\u89e3\u9501", "Ununlocked");
        LangHandler.addCNEN("gtocore.build", "\u6784\u5efa", "Build");
        LangHandler.addCNEN("gtocore.shape", "\u5f62\u6001%s", "Shape %s");
        LangHandler.addCNEN("item.gtocore.pattern_modifier_pro.name", "\u6837\u677f\u4fee\u6539\u5668 Pro", "Pattern Modifier Pro");
        LangHandler.addCNEN("gtocore.patternModifierPro.0", "\u8bbe\u7f6e\u5b8c\u6210\u540e\uff0c\u6f5c\u884c\u53f3\u51fb\u6837\u677f\u4f9b\u5e94\u5668\u4ee5\u5e94\u7528", "After setup,shift + right-click template provider to apply");
        LangHandler.addCNEN("gtocore.patternModifierPro.1", "\u6a21\u677f\u4e58\u6570\uff1a\u6240\u6709\u7269\u54c1\u548c\u6d41\u4f53\u4e58\u4ee5\u6307\u5b9a\u500d\u6570", "Set Item and Fluid Multiplier");
        LangHandler.addCNEN("gtocore.patternModifierPro.2", "\u6a21\u677f\u9664\u6570\uff1a\u6240\u6709\u7269\u54c1\u548c\u6d41\u4f53\u9664\u4ee5\u6307\u5b9a\u500d\u6570", "Set Item and Fluid Divider");
        LangHandler.addCNEN("gtocore.patternModifierPro.3", "\u6700\u5927\u7269\u54c1\u6570\uff1a\u6240\u6709\u7269\u54c1\u4e0d\u4f1a\u8d85\u8fc7\u6b64\u6570\u91cf", "Set Maximum Item Count");
        LangHandler.addCNEN("gtocore.patternModifierPro.4", "\u6700\u5927\u6d41\u4f53\u6570\uff1a\u6240\u6709\u6d41\u4f53\u4e0d\u4f1a\u8d85\u8fc7\u6b64\u6876\u6570", "Set Maximum Fluid Amount / Bucket");
        LangHandler.addCNEN("gtocore.patternModifierPro.5", "\u5e94\u7528\u6b21\u6570\u4e3a\uff1a\u5faa\u73af\u4e0a\u8ff0\u64cd\u4f5c\u6b21\u6570\uff0c\u6700\u5927\u4e3a16", "Set Application Cycles , Up to 16");
        LangHandler.addCNEN("gtocore.emi.tagprefix.tooltip", "\u6750\u6599\u6807\u7b7e\u7c7b\u578b", "Material Tag Prefix");
        LangHandler.addCNEN("gtocore.emi.tagprefix.tooltip.1", "\u5728\u7f16\u7801\u6837\u677f\u65f6\u5c06\u5b83\u4eec\u62d6\u5165\u7ec8\u7aef\uff0c\u53ef\u4ee5\u5236\u4f5c\u901a\u914d\u7b26\u6837\u677f", "When encoding patterns, drag them into the terminal to create wildcard patterns.");
        LangHandler.addCNEN("gtocore.emi.tagprefix.tooltip.2", "\u5728\u901a\u914d\u7b26\u6837\u677f\u603b\u6210\u4e2d\uff0c\u5c06\u81ea\u52a8\u5339\u914d\u6240\u6709\u7b26\u5408\u6807\u7b7e\u7684\u7269\u54c1\u6216\u6d41\u4f53", "In wildcard pattern assemblies, all items or fluids that match the tag will be automatically matched.");
        LangHandler.addCNEN("gtceu.jei.ore_vein.bauxite_vein", "\u94dd\u571f\u77ff\u8109", "Bauxite Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.chromite_vein", "\u94ec\u94c1\u77ff\u8109", "Chromite Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.pitchblende_vein", "\u6ca5\u9752\u94c0\u77ff\u8109", "Pitchblende Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.magnetite_vein", "\u78c1\u94c1\u77ff\u8109", "Magnetite Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.titanium_vein", "\u949b\u77ff\u8109", "Titanium Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.calorite_vein", "\u8010\u70ed\u77ff\u8109", "Calorite Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.celestine_vein", "\u5929\u9752\u77f3\u77ff\u8109", "Celestine Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.desh_vein", "\u6234\u65af\u77ff\u8109", "Desh Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.ostrum_vein", "\u7d2b\u91d1\u77ff\u8109", "Ostrum Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.zircon_vein", "\u9506\u77f3\u77ff\u8109", "Zircon Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.borax_vein", "\u787c\u7802\u77ff\u8109", "Borax Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.crystal_vein_water_fire", "\u9b54\u6676\u77ff\u8109(\u6c34-\u706b)", "Crystal Vein(Water-Fire)");
        LangHandler.addCNEN("gtceu.jei.ore_vein.crystal_vein_earth_wind", "\u9b54\u6676\u77ff\u8109(\u5730-\u98ce)", "Crystal Vein(Earth-Wind)");
        LangHandler.addCNEN("gtceu.jei.ore_vein.mana_steel_vein", "\u9b54\u529b\u94a2\u77ff\u8109", "Mana Steel Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.elementium_vein", "\u6e90\u8d28\u94a2\u77ff\u8109", "Elementium Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.gaia_core_vein", "\u76d6\u4e9a\u4e4b\u6838\u77ff\u8109", "Gaia Core Vein");
        LangHandler.addCNEN("gtceu.jei.ore_vein.anima_tree_leyline", "\u547d\u6811\u7075\u8109", "Anima Tree Leyline");
        LangHandler.addCNEN("gtocore.recipe.ev_max", "\u6700\u5927\u4e2d\u5b50\u52a8\u80fd\uff1a%s MeV", "Maximum Neutron Energy: %s MeV");
        LangHandler.addCNEN("gtocore.recipe.ev_min", "\u6700\u5c0f\u4e2d\u5b50\u52a8\u80fd\uff1a%s MeV", "Minimum Neutron Energy: %s MeV");
        LangHandler.addCNEN("gtocore.recipe.evt", "\u6bcf\u523b\u4e2d\u5b50\u52a8\u80fd\u6d88\u8017\uff1a%s KeV", "Energy Consumption per Tick: %s KeV");
        LangHandler.addCNEN("gtocore.recipe.frheat", "\u6bcf\u79d2\u5347\u6e29\uff1a%s K", "Heating per Second: %s K");
        LangHandler.addCNEN("gtocore.recipe.grindball", "\u7814\u78e8\u7403\u6750\u8d28\uff1a%s", "macerator Ball Material: %s");
        LangHandler.addCNEN("gtocore.recipe.spool", "\u7ebf\u8f74\u7c7b\u578b\uff1a%s", "Spool Type: %s");
        LangHandler.addCNEN("gtocore.recipe.law_cleanroom.display_name", "\u7edd\u5bf9\u8d85\u51c0\u95f4", "Absolute Clean");
        LangHandler.addCNEN("gtocore.recipe.nano_forge_tier", "\u7eb3\u7c73\u953b\u7089\u7b49\u7ea7\uff1a%s", "Nano Forge Tier: %s");
        LangHandler.addCNEN("gtocore.recipe.radioactivity", "\u8f90\u5c04\u5242\u91cf\uff1a%s Sv", "Radiation Dose: %s Sv");
        LangHandler.addCNEN("gtocore.recipe.vacuum.tier", "\u771f\u7a7a\u7b49\u7ea7\uff1a%s", "Vacuum Tier: %s");
        LangHandler.addCNEN("gtocore.recipe.restricted_machine", "\u53ea\u80fd\u8fd0\u884c\u5728\uff1a%s", "Only runnable on: %s");
        LangHandler.addCNEN("gtocore.recipe.heat.temperature", "\u9700\u8981\u5916\u90e8\u70ed\u6e90\uff1a%s K", "External heat source is required: %s K");
        LangHandler.addCNEN("gtocore.recipe.runlimit.count", "\u8fd0\u884c\u6b21\u6570\u9650\u5236\uff1a%s", "Run Limit: %s times");
        LangHandler.addCNEN("gtocore.recipe.mana_consumption", "\u9b54\u529b\u6d88\u8017", "Mana Consumption");
        LangHandler.addCNEN("gtocore.recipe.mana_production", "\u9b54\u529b\u4ea7\u51fa", "Mana Production");
        LangHandler.addCNEN("gtocore.recipe.efficiency", "\u603b\u8017\u80fd\u500d\u7387\uff1a%s", "Total Energy Cost Multiplier: %s");
        LangHandler.addCNEN("gtocore.recipe.efficiency.o", "\u603b\u4ea7\u80fd\u500d\u7387\uff1a%s", "Total Energy Cost Multiplier: %s");
        LangHandler.addCNEN("gtocore.recipe.mana_efficiency", "\u603b\u8017\u9b54\u500d\u7387\uff1a%s", "Total Mana Cost Multiplier: %s");
        LangHandler.addCNEN("gtocore.recipe.mana_efficiency.o", "\u603b\u4ea7\u9b54\u500d\u7387\uff1a%s", "Total Mana Cost Multiplier: %s");
        LangHandler.addCNEN("gtocore.recipe.time_cost_multiplier", "\u603b\u8017\u65f6\u500d\u7387\uff1a%s", "Total Time Cost Multiplier: %s");
        LangHandler.addCNEN("gtceu.multiblock.batch_parallel_multiplier", "(\u6279\u5904\u7406/\u8d85\u9891\u8865\u507f %s)", "(Batch/OC Compensation %s)");
        LangHandler.addCNEN("gtocore.condition.gravity", "\u9700\u8981\u5f3a\u91cd\u529b\u73af\u5883", "Requires Strong Gravity Environment");
        LangHandler.addCNEN("gtocore.condition.zero_gravity", "\u9700\u8981\u65e0\u91cd\u529b\u73af\u5883", "Requires Zero Gravity Environment");
        LangHandler.addCNEN("gtocore.condition.within_galaxy", "\u9700\u8981\u5728%s\u5185", "Requires within Galaxy: %s");
        LangHandler.addCNEN("gtocore.tier.advanced", "\u9ad8\u7ea7", "Advanced");
        LangHandler.addCNEN("gtocore.tier.base", "\u57fa\u7840", "Basic");
        LangHandler.addCNEN("gtocore.tier.ultimate", "\u7ec8\u6781", "Ultimate");
        LangHandler.addCNEN("gtocore.tier.hermetic_casing", "\u5bc6\u5c01\u673a\u68b0\u65b9\u5757\u7b49\u7ea7\uff1a%s", "Hermetic Casing Tier: %s");
        LangHandler.addCNEN("config.jade.plugin_gtocore.accelerate_provider", "[GTOCore] \u52a0\u901f\u6761", "[GTOCore] Accelerated Bar");
        LangHandler.addCNEN("config.jade.plugin_gtocore.wireless_data_hatch_provider", "[GTOCore] \u65e0\u7ebf\u6570\u636e", "[GTOCore] Wireless Data");
        LangHandler.addCNEN("config.jade.plugin_gtocore.mana_container_provider", "[GTOCore] \u9b54\u529b\u5bb9\u5668", "[GTOCore] Mana Container");
        LangHandler.addCNEN("config.jade.plugin_gtocore.vacuum_tier_provider", "[GTOCore] \u771f\u7a7a\u7b49\u7ea7", "[GTOCore] Vacuum Tier");
        LangHandler.addCNEN("config.jade.plugin_gtocore.temperature_provider", "[GTOCore] \u673a\u5668\u6e29\u5ea6", "[GTOCore] Machine Temperature");
        LangHandler.addCNEN("config.jade.plugin_gtocore.ae_grid_provider", "[GTOCore] AE\u7f51\u7edc\u4fe1\u606f", "[GTOCore] AE Grid Info");
        LangHandler.addCNEN("config.jade.plugin_gtocore.ae_item_amount", "[GTOCore] AE\u7269\u54c1\u6570\u91cf", "[GTOCore] AE Item Amount");
        LangHandler.addCNEN("config.jade.plugin_gtocore.tick_time_provider", "[GTOCore] Tick\u65f6\u95f4", "[GTOCore] Tick Time");
        LangHandler.addCNEN("config.jade.plugin_gtocore.wireless_interactor_provider", "[GTOCore] \u65e0\u7ebf\u4ea4\u4e92\u673a\u5668\u4fe1\u606f", "[GTOCore] Wireless Interactive Machine Info");
        LangHandler.addCNEN("config.jade.plugin_gtocore.upgrade_module_provider", "[GTOCore] \u5347\u7ea7\u6a21\u5757\u4fe1\u606f", "[GTOCore] Upgrade Module Info");
        LangHandler.addCNEN("config.jade.plugin_gtocore.destroy_time_provider", "[GTOCore] \u786c\u5ea6\u4fe1\u606f", "[GTOCore] Destroy Time Info");
        LangHandler.addCNEN("config.jade.plugin_gtocore.wireless_grid_provider", "[GTOCore] \u65e0\u7ebfAE\u7f51\u7edc\u4fe1\u606f", "[GTOCore] Wireless AE Network Info");
        LangHandler.addCNEN("config.jade.plugin_gtocore.maintenance_hatch_provider", "[GTOCore] \u7ef4\u62a4\u4ed3\u4fe1\u606f", "[GTOCore] Maintenance Hatch Info");
        LangHandler.addCNEN("gtocore.applicable_modules", "\u5b89\u88c5\u9644\u5c5e\u6a21\u5757\u540e\u53ef\u89e3\u9501\u7684\u4ed3\u5ba4\u7c7b\u578b : %s", "Hatch types unlocked by installing auxiliary modules : %s");
        LangHandler.addCNEN("gtocore.applicable_recipes", "\u5b89\u88c5\u9644\u5c5e\u6a21\u5757\u540e\u53ef\u89e3\u9501\u7684\u914d\u65b9\u7c7b\u578b : %s", "Recipe types unlocked by installing auxiliary modules : %s");
        LangHandler.addCNEN("fluid.gtocore.gelid_cryotheum", "\u6781\u5bd2\u4e4b\u51db\u51b0", "Gelid Cryotheum");
        LangHandler.addCNEN("biome.gtocore.ancient_world_biome", "\u8fdc\u53e4\u4e16\u754c", "Ancient World");
        LangHandler.addCNEN("biome.gtocore.barnarda_c_biome", "\u5df4\u7eb3\u5fb7 C", "Barnarda C");
        LangHandler.addCNEN("biome.gtocore.ceres_biome", "\u8c37\u795e\u661f", "Ceres");
        LangHandler.addCNEN("biome.gtocore.enceladus_biome", "\u571f\u536b\u4e8c", "Enceladus");
        LangHandler.addCNEN("biome.gtocore.ganymede_biome", "\u6728\u536b\u4e09", "Ganymede");
        LangHandler.addCNEN("biome.gtocore.io_biome", "\u6728\u536b\u4e00", "Io");
        LangHandler.addCNEN("biome.gtocore.pluto_biome", "\u51a5\u738b\u661f", "Pluto");
        LangHandler.addCNEN("biome.gtocore.titan_biome", "\u571f\u536b\u516d", "Titan");
        LangHandler.addCNEN("biome.gtocore.create", "\u521b\u9020", "Create");
        LangHandler.addCNEN("biome.gtocore.void", "\u865a\u7a7a", "Void");
        LangHandler.addCNEN("biome.gtocore.flat", "\u8d85\u5e73\u5766", "Superflat");
        LangHandler.addCNEN("planet.gtocore.barnarda_c", "\u5df4\u7eb3\u5fb7 C", "Barnarda C");
        LangHandler.addCNEN("planet.gtocore.barnarda_c_orbit", "\u5df4\u7eb3\u5fb7 C\u8f68\u9053", "Barnarda C Orbit");
        LangHandler.addCNEN("planet.gtocore.ceres", "\u8c37\u795e\u661f", "Ceres");
        LangHandler.addCNEN("planet.gtocore.ceres_orbit", "\u8c37\u795e\u661f\u8f68\u9053", "Ceres Orbit");
        LangHandler.addCNEN("planet.gtocore.enceladus", "\u571f\u536b\u4e8c", "Enceladus");
        LangHandler.addCNEN("planet.gtocore.enceladus_orbit", "\u571f\u536b\u4e8c\u8f68\u9053", "Enceladus Orbit");
        LangHandler.addCNEN("planet.gtocore.ganymede", "\u6728\u536b\u4e09", "Ganymede");
        LangHandler.addCNEN("planet.gtocore.ganymede_orbit", "\u6728\u536b\u4e09\u8f68\u9053", "Ganymede Orbit");
        LangHandler.addCNEN("planet.gtocore.io", "\u6728\u536b\u4e00", "Io");
        LangHandler.addCNEN("planet.gtocore.io_orbit", "\u6728\u536b\u4e00\u8f68\u9053", "Io Orbit");
        LangHandler.addCNEN("planet.gtocore.pluto", "\u51a5\u738b\u661f", "Pluto");
        LangHandler.addCNEN("planet.gtocore.pluto_orbit", "\u51a5\u738b\u661f\u8f68\u9053", "Pluto Orbit");
        LangHandler.addCNEN("planet.gtocore.titan", "\u571f\u536b\u516d", "Titan");
        LangHandler.addCNEN("planet.gtocore.titan_orbit", "\u571f\u536b\u516d\u8f68\u9053", "Titan Orbit");
        LangHandler.addCNEN("gui.ad_astra.text.barnarda", "\u5df4\u7eb3\u5fb7", "Barnarda");
        LangHandler.addCNEN("gtocore.tooltip.fluid.electrolyte_energy_density", "\u00a7d\u7535\u89e3\u6db2\u80fd\u91cf\u5bc6\u5ea6\uff1a\u00a7r%s EU/mB", "\u00a7dElectrolyte Energy Density:\u00a7r %s EU/mB");
        LangHandler.addCNEN("gtocore.tooltip.fluid.electrolyte_energy_density.va", "\u00a7d\u76f8\u5f53\u4e8e\uff1a\u00a7r%s @ \u00a7b%s\u00a7rA/mB", "\u00a7dEquivalent to\u00a7r %s @ \u00a7b%sA\u00a7r/mB");
        LangHandler.addCNEN("key.ae2.me2in1_wireless_locating_service", "\u6253\u5f00ME2\u54081\u65e0\u7ebf\u7ec8\u7aef", "Open ME2in1 Wireless Terminal");
        LangHandler.addCNEN("gtocore.player_exp_status.mysterious_boost_potion.success", "\u4f60\u4f3c\u4e4e\u88ab\u8d4b\u4e88\u4e86\u67d0\u79cd\u795e\u79d8\u80fd\u529b...", "You seem to be granted with some mysterious ability ......");
        LangHandler.addCNEN("gtocore.gui.encoding_desc", "\u00a7o[Shift + \u5de6\u51fb] \u5c06\u6837\u677f\u5b58\u5165\u80cc\u5305/\u6e05\u7a7a\u6240\u6709\u5df2\u7f16\u7801\u6837\u677f", "\u00a7o[Shift + Click] insert encoding pattern into player inventory / clear all encoded patterns");
        LangHandler.addCNEN("gtocore.xaero_waypoint_set", "\u77ff\u8109", "Ore Vein");
        LangHandler.addCNEN("ftbquests.task.gtocore.gtodifficulty", "GTO\u96be\u5ea6", "GTO Difficulty");
        LangHandler.addCNEN("ftbquests.task.gtocore.gtodifficulty.difficulty", "\u96be\u5ea6\u8bbe\u7f6e\uff080=\u901a\u7528\uff0c1=\u7b80\u5355\uff0c2=\u666e\u901a\uff0c3=\u4e13\u5bb6\uff09", "Difficulty Setting (0=Generic, 1=Easy, 2=Normal, 3=Expert)");
        LangHandler.addCNEN("ftbquests.task.gtocore.mod", "\u6a21\u7ec4\u52a0\u8f7d", "Mod Loaded");
        LangHandler.addCNEN("ftbquests.task.gtocore.mod.modid", "\u6a21\u7ec4ID", "Mod ID");
        LangHandler.addCNEN("ftbquests.task.gtocore.scheduled", "\u5b9a\u65f6\u4efb\u52a1", "Scheduled Task");
        LangHandler.addCNEN("ftbquests.task.gtocore.scheduled.intervalInSeconds", "\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09", "Time (in seconds)");
        LangHandler.addCNEN("ftbquests.task.gtocore.scheduled.isInGame", "\u6e38\u620f\u5185\u65f6\u95f4\uff08\u8bbe\u4e3afalse\u5219\u4e3a\u73b0\u5b9e\u65f6\u95f4\uff09", "In-game time (set to false for real time)");
        LangHandler.addCNEN("ftbquests.task.gtocore.scheduled.refreshInFixedTime", "\u4ee5\u56fa\u5b9a\u65f6\u95f4\u5237\u65b0\uff08\u4f8b\u5982\u5f53\u65f6\u95f4\u8bbe\u4e3a180\uff0c\u5373\u6bcf\u4e2a3\u5206\u949f\u65f6\u95f4\u95f4\u9694\u4ec5\u5224\u5b9a\u4e00\u6b21\u5b8c\u6210\uff09", "Refresh in fixed time (for example, when the time is set to 180, it is only judged once every fixed 3-minute time interval)");
        LangHandler.addCNEN("affix.apotheosis:ftbu", "\u8fde\u9501", "Chainbound");
        LangHandler.addCNEN("affix.apotheosis:ftbu.suffix", "\u77ff\u8109\u7206\u7834", "the Veinseeker");
        LangHandler.addCNEN("affix.apotheosis:bedrock_ore", "\u52d8\u63a2", "Prospecting");
        LangHandler.addCNEN("affix.apotheosis:bedrock_ore.suffix", "\u57fa\u5ca9\u900f\u89c6\u8005", "the Bedrock Seer");
        LangHandler.addCNEN("affix.apotheosis:bedrock_fluid_ore", "\u5bfb\u6d41", "Flowseeking");
        LangHandler.addCNEN("affix.apotheosis:bedrock_fluid_ore.suffix", "\u77f3\u6cb9\u4e4b\u773c", "the Oil Penetrator");
        LangHandler.addCNEN("affix.apotheosis:stress", "\u5e94\u529b", "Stress");
        LangHandler.addCNEN("affix.apotheosis:stress.suffix", "\u5343\u94a7\u4e00\u53d1", "the Brinkbreaker");
        LangHandler.addCNEN("affix.apotheosis:kinetic", "\u52a8\u80fd", "Kinetic");
        LangHandler.addCNEN("affix.apotheosis:kinetic.suffix", "\u52bf\u5982\u7834\u7af9", "the Momentum Master");
        LangHandler.addCNEN("gtocore.bar.distillation.1", "\u4ea7\u51fa\uff0c\u6d88\u8017\u6c34", "Output , Consumption water");
        LangHandler.addCNEN("gtocore.bar.exploration", "\u7206\u70b8", "Explosion");
        LangHandler.addCNEN("gtocore.bar.heat", "\u6e29\u5ea6", "Heat");
        LangHandler.addCNEN("gtocore.player.organ.info_exclamation", "\u5173\u4e8e\uff1a", "About : ");
        LangHandler.addCNEN("gtocore.player.organ.that_is_your", "\u8fd9\u662f\u4f60\u7684", "That is your ");
        LangHandler.addCNEN("gtocore.player.organ.dont_take_it_all_down", "\u5343\u4e07\u4e0d\u8981\u5168\u90e8\u62ff\u4e0b\u6765", "Don't take it all down");
        LangHandler.addCNEN("gtocore.player.organ.precision_very_high", "\u7cbe\u5ea6\u9ad8\uff0c\u53ef\u4ee5\u88c5\u8f7d\u5927\u90e8\u5206\u90e8\u4ef6", "Precision is high, can load most parts");
        LangHandler.addCNEN("gtocore.player.organ.precision_very_low", "\u7cbe\u5ea6\u4f4e\u3002\u53ea\u80fd\u88c5\u8f7d\u5c0f\u90e8\u5206\u90e8\u4ef6", "Precision is low,  can load only small parts");
        LangHandler.addCNEN("gtocore.player.organ.even_make_die", "\u751a\u81f3\u81f4\u6b7b", "Even make you die");
        LangHandler.addCNEN("gtocore.player.organ.can_modifier_your_body", "\u53ef\u4ee5\u4fee\u6539\u4f60\u7684\u8eab\u4f53\u90e8\u4ef6", "It can Modify your body");
        LangHandler.addCNEN("gtocore.player.organ.name.attribute_tag", "\u5c5e\u6027\u6807\u7b7e", "Attribute Tags");
        LangHandler.addCNEN("gtocore.player.organ.name.visceral_editor", "\u5668\u5b98\u6539\u9020", "Visceral Editor");
        LangHandler.addCNEN("gtocore.player.organ.trans2open", "\u8bbe\u4e3a\u542f\u7528", "set to enable");
        LangHandler.addCNEN("gtocore.player.organ.trans2close", "\u8bbe\u4e3a\u7981\u7528", "set to disable");
        LangHandler.addCNEN("gtocore.player.organ.you_wing_is_broken", "\u4f60\u7684\u7fc5\u8180\u5df2\u635f\u574f", "Your wing is broken");
        LangHandler.addCNEN("gtocore.player.organ.time_left", "\u5269\u4f59\u65f6\u957f: %s \u5c0f\u65f6 %s \u79d2", "%s hours %s second time left");
        LangHandler.addCNEN("gtocore.player.organ.you_wing_need_to_charge", "\u4f60\u7684\u7fc5\u8180\u9700\u8981\u5145\u7535", "Your wing need to charge");
        LangHandler.addCNEN("gtocore.player.organ.power", "\u529f\u7387", "power");
        LangHandler.addCNEN("gtocore.player.organ.need_precision_level", "\u9700\u8981\u7cbe\u5ea6\u7b49\u7ea7%s\u7ea7\u7684\u4eea\u5668", "Need Precision Level %s Tool");
        LangHandler.addCNEN("gtocore.player.organ.name.function", "\u5b9a\u5236\u529f\u80fd", "Costume Your Function");
        LangHandler.addCNEN("gtocore.player.organ.name.effect", "\u6548\u679c", "Effect");
        LangHandler.addCNEN("gtocore.player.organ.name.change", "\u66f4\u6539", "Change");
        LangHandler.addCNEN("gtocore.player.organ.name.other", "\u5176\u5b83", "Other");
        LangHandler.addCNEN("gtocore.satellite_control_center.emi.launch_satellite", "\u53d1\u5c04\u536b\u661f", "Launch Satellite");
        LangHandler.addCNEN("effect.gtocore.mysterious_boost", "\u673a\u68b0\u4e4b\u795e\u9644\u8eab", "Possession of the Machine God");
        LangHandler.addCNEN("gtocore.death.attack.turbulence_of_another_star", "%s\u6b7b\u4e8e\u5f02\u661f\u4e71\u6d41\uff0c%s\u7ea7\u522b\u7684\u661f\u7403\u9700\u8981%s\u5668\u5b98\u6539\u9020", "%s died in the turbulence of another star, and a planet of %s level requires %s organ modification");
        LangHandler.addCNEN("gtocore.not_safe", "\u73b0\u5728\u4e0d\u5b89\u5168", "It's not safe now");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.main", "\u68c0\u6d4b\u5230\u5faa\u73af\u4f9d\u8d56\uff0c\u81ea\u52a8\u5408\u6210\u65e0\u6cd5\u8fdb\u884c", "Cyclic dependency detected, automatic crafting cannot proceed");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.count", "\n\u53d1\u73b0 %s \u4e2a\u73af:", "\nFound %s cycles:");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.more_cycles", "\n    ... \u8fd8\u6709 %s \u4e2a\u73af\u672a\u663e\u793a", "\n    ... and %s more cycles not shown");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.cycle_number", "\n    \u73af %s\uff1a", "\n    Cycle %s:");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.indent", "\n          ", "\n          ");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.footer", "\n\n\u8bf7\u5904\u7406\u6240\u6709\u5faa\u73af\u4f9d\u8d56\u540e\u624d\u53ef\u4ee5\u8fdb\u884c\u81ea\u52a8\u5408\u6210", "\n\nPlease resolve all cyclic dependencies before automatic crafting");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.click_instruction", "\n\u70b9\u51fb\u7269\u54c1ID\u53ef\u590d\u5236\u5230\u526a\u8d34\u677f", "\nClick on item ID to copy to clipboard");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.item_prefix", "- ", "- ");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.bracket_open", " (", " (");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.bracket_close", ")", ")");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.cycle_error.click_to_copy", "\u70b9\u51fb\u590d\u5236: %s", "Click to copy: %s");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.show_molecular_assembler_only", "\u53ea\u663e\u793a\u5408\u6210\u6837\u677f", "Show crafting pattern only");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.show_molecular_assembler_expect", "\u4e0d\u663e\u793a\u5408\u6210\u6837\u677f", "Expect crafting pattern");
        LangHandler.addCNEN("gtocore.ae.appeng.crafting.show_molecular_assembler_all", "\u9ed8\u8ba4", "Default");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.shift_transfer_to", "Shift + \u5de6\u952e\u5c06\u6837\u677f\u8f6c\u79fb\u5230", "Shift + Left Click to transfer pattern to");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.shift_transfer_to.inventory_or_buffer", "\u80cc\u5305\u6216\u7f13\u51b2\u533a", "Inventory or buffer");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.shift_transfer_to.accessor", "\u5f53\u524d\u9875\u9762\u4e2d\u7a7a\u767d\u7684\u6837\u677f\u7ba1\u7406\u7ec8\u7aef", "Blank slots on the current page of the Pattern Terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.encode_to.accessor.title", "\u7f16\u7801\u5230\u6837\u677f\u7ba1\u7406\u7ec8\u7aef", "Encode to Pattern Terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.encode_to.accessor", "\u76f4\u63a5\u7f16\u7801\u5230\u5f53\u524d\u9875\u9762\u4e2d\u7684\u7a7a\u767d\u90e8\u5206", "Encode directly to the blank slots on the current page of terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.draggable_mark.tooltip", "\u6309\u4f4f\u5e76\u62d6\u52a8\u4ee5\u8c03\u6574\u8be5\u9762\u677f\u4f4d\u7f6e", "Hold and drag to adjust the position of this panel");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.material_slot", "\u6750\u6599\u69fd", "Material Slot");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.material_slot.1", "\u5c06\u5e26\u6709\u6750\u6599\u7c7b\u578b\u7684\u7269\u54c1\uff08\u5982xx\u677f\uff0cxx\u6746\u7b49\uff09\u653e\u5165\u6b64\u69fd\u4f4d", "Place items with materials (such as xx plate, xx rod, etc.) in this slot");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.material_slot.2", "\u7f16\u7801\u65f6\u5c06\u81ea\u52a8\u5e94\u7528\u6750\u6599\u7c7b\u578b\u5230\u53ef\u66ff\u6362\u7684\u7269\u54c1\u4e0a", "The material type will be automatically applied to replaceable items when encoding");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_encode_rename_pattern", "\u81ea\u52a8\u7f16\u7801\u91cd\u547d\u540d\u6837\u677f", "Auto Encode Renaming Pattern");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_encode_rename_pattern.1", "\u542f\u7528\u540e\uff0c\u6240\u6709\u91cd\u547d\u540d\u540e\u7684\u7269\u54c1\u5c06\u989d\u5916\u7f16\u7801\u4e00\u4efd\u6837\u677f\uff0c\u6570\u91cf\u4e0e\u539f\u6837\u677f\u4e2d\u8bbe\u7f6e\u7684\u4e00\u81f4\u3002", "When enabled, all renamed items will encode an additional pattern, with the same quantity as set in the original pattern.");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.catalyst", "\u7f16\u7801\u9ed8\u8ba4\u4e0d\u586b\u5145\u50ac\u5316\u5242", "Shift + Left Click: Fill catalysts into the pattern");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.catalyst.fill", "Shift + \u5de6\u51fb\uff1a\u5c06\u50ac\u5316\u5242\u586b\u5145\u81f3\u6837\u677f", "Shift + Left Click: Fill catalysts into the pattern");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.catalyst.virtual", "Ctrl + \u5de6\u51fb\uff1a\u5c06\u50ac\u5316\u5242\uff08\u865a\u62df\u7269\u54c1\uff09\u586b\u5145\u81f3\u6837\u677f", "Hold Ctrl to encode catalysts as virtual item catalysts");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.multiblock.sub", "Shift + \u5de6\u51fb\uff1a\u7f16\u7801\u57fa\u7840\u7ed3\u6784\u548c\u5f53\u524d\u6a21\u5757", "Shift + Click: Encode base structure and this module");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.multiblock.sub.all", "Ctrl + \u5de6\u51fb\uff1a\u7f16\u7801\u5230\u5f53\u524d\u6a21\u5757\u4e3a\u6b62\u7684\u5168\u90e8\u7ed3\u6784", "Ctrl + Click: Encode all modules up to this one");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.gt_batch_encode", "Alt + \u5de6\u51fb\uff1a\u6279\u91cf\u7f16\u7801\uff0c\u8bd5\u56fe\u66ff\u6362\u7684\u6750\u6599\u7528\u9ec4\u8272\u6807\u8bb0", "Batch encoding is available while holding Alt, materials to be replaced are marked in yellow");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.emi.gt_batch_encode.1", "\u66ff\u6362\u5931\u8d25\u7684\u6750\u6599\uff08\u5982\u8be5\u6750\u6599\u4e0d\u5b58\u5728\u8fd9\u79cd\u7269\u54c1\uff09\u5c06\u5728\u7f16\u7801\u65f6\u4fdd\u6301\u539f\u6837\u677f\u7684\u72b6\u6001", "Materials that fail to replace (e.g., the material does not exist for this item) will retain the original state of the pattern during encoding");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.save_default_rename_pattern", "\u4fdd\u5b58\u9ed8\u8ba4\u91cd\u547d\u540d\u6837\u677f\uff0c\u5c06\u53ef\u4ee5\u5728\u81ea\u52a8\u586b\u5145\u65f6\u4f7f\u7528\uff01", "Save the default renaming pattern, which can be used for auto-filling!");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_search", "\u4f7f\u7528EMI\u586b\u5145\u914d\u65b9\u65f6\uff0c", "When using EMI to fill recipes,");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_search.on", "\u81ea\u52a8\u586b\u5145\u914d\u65b9\u7684\u76ee\u5f55\u540d\u79f0\u5230\u6837\u677f\u641c\u7d22\u680f\u4e2d", "automatically fills the directory name of the recipe into the pattern search bar");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_search.off", "\u4e0d\u81ea\u52a8\u5728\u6837\u677f\u7ec8\u7aef\u4e2d\u641c\u7d22", "does not automatically search in the pattern terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.auto_search.config", "\u4e2d\u952e\u70b9\u51fb\u4ee5\u914d\u7f6e\u81ea\u5b9a\u4e49\u76ee\u5f55\u540d\u79f0\u641c\u7d22\u6620\u5c04", "Middle-click to configure custom directory name search mapping");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.vanilla_craft_station", "\u5206\u5b50\u88c5\u914d", "Molecular Assembl");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.wireless", "\u65e0\u7ebf2\u54081\u7ec8\u7aef", "Wireless 2-in-1 Terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1", "ME2\u54081\u7ec8\u7aef", "ME 2-in-1 Terminal");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.collapse_or_expand_toolbar", "\u6298\u53e0/\u5c55\u5f00 \u5de5\u5177\u680f", "Collapse/Expand Toolbar");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.collapse_or_expand_toolbar.desc", "\u6298\u53e0\u6216\u5c55\u5f00\u663e\u793a\u5143\u4ef6\u4e0e\u7f51\u7edc\u5de5\u5177\u69fd", "Collapse or expand the display components and network tool slots");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.reset_panel_position", "\u91cd\u7f6e\u9762\u677f\u4f4d\u7f6e", "Reset Panel Position");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.reset_panel_position.1", "\u91cd\u7f6e\u6240\u6709\u9762\u677f\u4f4d\u7f6e\u5230\u9ed8\u8ba4\u4f4d\u7f6e", "Reset all panel positions to default");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.quick_remove_pattern", "\u70b9\u51fb\u79fb\u9664\u4ee5\u6b64\u4e3a\u4e3b\u4ea7\u7269\u7684\u5904\u7406\u6837\u677f\u81f3\u7f13\u51b2\u69fd", "Click to remove patterns with this main product to the buffer slot");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.quick_remove_pattern.1", "shift + \u70b9\u51fb\u4ee5\u989d\u5916\u79fb\u9664\u5176\u5408\u6210\u6811\u4e2d\u4e0d\u53c2\u4e0e\u5176\u4ed6\u6837\u677f\u7684\u5904\u7406\u6837\u677f", "Shift + Click to additionally remove patterns in its crafting tree that are not involved in other patterns");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.quantum_bridge", "\u5b89\u88c5\u7ea0\u7f20\u5947\u70b9", "Install Quantum Entangled Singularity");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.quantum_bridge.info", "\u8be5\u7ec8\u7aef\u5df2\u5185\u7f6e\u91cf\u5b50\u73af\uff0c\u65e0\u9700\u989d\u5916\u63d2\u4ef6\u5373\u53ef\u5b9e\u73b0\u8fdc\u7a0b\u8bbf\u95eeME\u7f51\u7edc", "This terminal has a built-in quantum ring, allowing remote access to the ME network without additional plugins");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.add_mapping", "\u6dfb\u52a0\u914d\u65b9\u641c\u7d22\u6620\u5c04", "Add Recipe Search Mapping");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.add_mapping.desc", "\u5355\u51fb\u6253\u5f00EMI\u4e2d\u7684\u914d\u65b9\uff0c\u7136\u540e\u70b9\u51fb\u60f3\u8981\u81ea\u5b9a\u4e49\u6620\u5c04\u7684\u76ee\u5f55\u4e2d\u914d\u65b9\u7684\"+\"\u6309\u94ae\u4ee5\u6dfb\u52a0\u6620\u5c04\u3002\u81ea\u5b9a\u4e49\u7684\u914d\u65b9\u6620\u5c04\u4fdd\u5b58\u4e8econfig/me2in1category.json\u4e2d\u3002", "Click to open the recipe in EMI, then click the \"+\" button of the recipe in the directory you want to customize the mapping for to add the mapping. The custom recipe mappings are saved in config/me2in1category.json.");
        LangHandler.addCNEN("gtocore.ae.appeng.me2in1.config_mapping", "\u914d\u7f6e\u914d\u65b9\u641c\u7d22\u6620\u5c04", "Configure Recipe Search Mapping");
        LangHandler.addCNEN("gtocore.ae.appeng.craft.add_missing_to_emi", "\u6536\u85cf\u7f3a\u5931", "Bookmark Missing");
        LangHandler.addCNEN("gtocore.ae.appeng.craft.add_missing_to_emi.desc", "\u5c06\u7f3a\u5931\u7684\u7269\u54c1\u6dfb\u52a0\u5230EMI\u4e66\u7b7e\u9875", "Add missing items to EMI bookmark page");
        LangHandler.addCNEN("gtocore.ae.appeng.craft.missing_start", "\u7f3a\u5931\u5408\u6210", "Missing Crafting");
        LangHandler.addCNEN("gtocore.ae.appeng.craft.missing_start.desc", "\u5728\u6750\u6599\u4e0d\u8db3\u7684\u60c5\u51b5\u4e0b\u4ecd\u7136\u5f00\u59cb\u5408\u6210\uff0c\u7f3a\u5931\u7684\u539f\u6599\u5c06\u88ab\u7b49\u5f85", "Start crafting even when materials are insufficient, missing ingredients will be waited for");
        LangHandler.addCNEN("gtocore.ae.appeng.craft.used_percent", "\u5df2\u4f7f\u7528 %s%%", "Used %s%%");
        LangHandler.addCNEN("gtocore.ae.appeng.fetching_items", "\u53d6\u5f97\u4fe1\u606f\u4e2d...", "Fetching items...");
        LangHandler.addCNEN("gtocore.ae.appeng.me_storage_amount", "ME\u7f51\u7edc\u5b58\u50a8\u6570\u91cf", "ME Network Stored Amount");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.error.title", "Pick-Craft \u9519\u8bef", "Pick-Craft Error");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.all_right.title", "Pick-Craft \u6210\u529f", "Pick-Craft Success");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.all_right", "\u5df2\u542f\u52a8\u5408\u6210\uff01", "Crafting started!");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.error.1", "\u8ba1\u7b97\u5408\u6210\u8def\u5f84\u65f6\u53d1\u751f\u9519\u8bef\u3002", "An error occurred while calculating the crafting path.");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.error.2", "\u6ca1\u6709\u8db3\u591f\u7684\u6750\u6599/CPU\u6765\u5408\u6210\u6240\u9700\u7269\u54c1\u3002", "Insufficient materials/No available CPU to craft the desired item.");
        LangHandler.addCNEN("gtocore.ae.appeng.pick_craft.error.3", "\u521b\u5efa\u7684\u4efb\u52a1\u6570\u5df2\u8fbe\u4e0a\u9650\u3002", "The number of created tasks has reached the limit.");
        LangHandler.addCNEN("gtocore.ae.appeng.highlight_button.try_open_ui", "\u5f53\u76ee\u6807\u4e3a\u6837\u677f\u603b\u6210\uff0c\u53f3\u952e\u4ee5\u8bd5\u56fe\u6253\u5f00\u5176\u754c\u9762", "When the target is a Pattern Provider, right-click to try to open its UI");
        LangHandler.addCNEN("gtocore.adv_terminal.block.confirm", "\u786e\u8ba4", "Confirm");
        LangHandler.addCNEN("gtocore.adv_terminal.block.cancel", "\u53d6\u6d88", "Cancel");
        LangHandler.addCNEN("gtocore.adv_terminal.block.select", "\u9009\u62e9\u65b9\u5757", "Select Block");
        LangHandler.addCNEN("gtocore.adv_terminal.category.select", "\u9009\u62e9\u7c7b\u522b", "Select Category");
        LangHandler.addCNEN("gtocore.adv_terminal.setting_already_existed", "\u5b58\u5728\u5df2\u6709\u8bbe\u7f6e", "Setting Already Existed");
        LangHandler.addCNEN("gtocore.travel.mode.all", "\u6240\u6709\u76ee\u6807", "All Targets");
        LangHandler.addCNEN("gtocore.travel.mode.one_per_chunk", "\u6bcf\u4e2a\u533a\u5757\u4e00\u4e2a\u76ee\u6807", "One Target per Chunk");
        LangHandler.addCNEN("gtocore.travel.mode.filter_by_block", "\u4ece\u76ee\u6807\u7c7b\u578b\u7b5b\u9009", "Filter by block type");
        LangHandler.addCNEN("gtocore.travel.mode.switched", "\u5207\u6362\u6a21\u5f0f", "Switch Mode");
        LangHandler.addCNEN("gtocore.travel.mode.filter.noblock", "\u4f60\u7684\u89c6\u7ebf\u6ca1\u6709\u53ef\u4f5c\u4e3a\u76ee\u6807\u7684\u65b9\u5757", "Your view does not have a block that can be used as a target");
        LangHandler.addCNEN("gtocore.travel.missing_block", "[\u672a\u8bbe\u7f6e\u65b9\u5757]", "[No block set]");
        LangHandler.addCNEN("ftbultimine.shape.area", "\u4e0d\u5b9a\u5f62 (\u4e0d\u8fde\u7eed)", "Shapeless (Area)");
        LangHandler.addCNEN("gtocore.source", "\u7ed3\u6784\u6765\u6e90\uff1a%s", "Structure From: %s");
        LangHandler.addCNEN(MultiblockState.UNLOAD_ERROR.translateKey, "\u6709\u533a\u5757\u672a\u52a0\u8f7d", "There are chunk not loaded");
        LangHandler.addCNEN(MultiblockState.UNINIT_ERROR.translateKey, "\u673a\u5668\u672a\u521d\u59cb\u5316", "Machine not initialized");
        LangHandler.addCNEN(MultiblockState.SHARE_ERROR.translateKey, "\u8be5\u65b9\u5757\u4e0d\u80fd\u5171\u4eab", "This block cannot be shared");
        LangHandler.addCNEN(MultiblockState.BANNED_ERROR.translateKey, "\u8be5\u65b9\u5757\u88ab\u7981\u6b62", "This block is banned");
        LangHandler.addCNEN("gtocore.multiblock.invalid.message", "\u591a\u65b9\u5757%s\u4f4d\u4e8e(%s)\u672a\u6210\u578b\uff01\u8fd0\u884c /gtocorec multiblock on \u67e5\u770b\u8be6\u60c5\u3002", "Multiblock %s at (%s) is not formed! Run /gtocorec multiblock on for details.");
        LangHandler.addCNEN("gtocore.celestial_condenser.solaris", "\u66e6\u714c\uff1a%s", "Solaris: %s");
        LangHandler.addCNEN("gtocore.celestial_condenser.lunara", "\u80e7\u534e\uff1a%s", "Lunara: %s");
        LangHandler.addCNEN("gtocore.celestial_condenser.voidflux", "\u865a\u6e6e\uff1a%s", "Voidflux: %s");
        LangHandler.addCNEN("gtocore.celestial_condenser.stellarm", "\u661f\u9ad3\uff1a%s", "Stellarm: %s");
        LangHandler.addCNEN("gtocore.celestial_condenser.any", "\u4efb\u610f\uff1a%s", "Any: %s");
        LangHandler.addCNEN("gtocore.elemental_resonance.0", "\u5171\u9e23\u6d88\u8017: %s/%st", "Resonance consumption: %s/%st");
        LangHandler.addCNEN("gtocore.elemental_resonance.1", "\u5171\u9e23\u6d88\u8017: %s\u00d7%s/%st", "Resonance consumption: %s\u00d7%s/%st");
        LangHandler.addCNEN("tooltip.gtocore.hold_for_more", "\u00a71\u6309\u4f4f %s \u663e\u793a\u66f4\u591a\u4fe1\u606f\u3002\u00a7r", "\u00a71Hold %s for more info.\u00a7r");
        LangHandler.addCNEN("gtocore.pattern.recipe", "\u914d\u65b9\u5df2\u7f13\u5b58", "Recipe cached");
        LangHandler.addCNEN("gtocore.pattern.type", "\u673a\u5668\u6a21\u5f0f\uff1a%s", "Machine recipe type:%s");
        LangHandler.addCNEN("gtocore.pattern.recipeInfoButton.title.enabled", "\u914d\u65b9\u4fe1\u606f\u5df2\u542f\u7528", "Recipe Info Recording");
        LangHandler.addCNEN("gtocore.pattern.recipeInfoButton.title.disabled", "\u914d\u65b9\u4fe1\u606f\u5df2\u7981\u7528", "Recipe Info Not Recorded");
        LangHandler.addCNEN("gtocore.pattern.recipeInfoButton.clickToEnable", "\u70b9\u51fb\u542f\u7528\u914d\u65b9\u4fe1\u606f\u5199\u5165", "Click to start recording recipe info");
        LangHandler.addCNEN("gtocore.pattern.recipeInfoButton.clickToDisable", "\u70b9\u51fb\u7981\u7528\u914d\u65b9\u4fe1\u606f\u5199\u5165", "Click to stop recording recipe info");
        LangHandler.addCNEN("gtocore.pattern.recipeInfoButton.clickToClear", "\u70b9\u51fb\u6e05\u9664\u5df2\u8bb0\u5f55\u7684\u914d\u65b9\u4fe1\u606f", "Click to clear recorded recipe info");
        LangHandler.addCNEN("gtocore.recipe.recycler.random_output", "\u968f\u673a\u7269\u54c1", "Random Item");
        LangHandler.addCNEN("gtocore.emi.search_text", "\u5df2\u4fdd\u5b58\u7684\u641c\u7d22: %s", "Saved Search: %s");
        LangHandler.addCNEN("gtocore.emi.search_text.how_to_use", "\u5c06\u5b83\u62d6\u62fd\u81f3\u6587\u672c\u6846\u4ee5\u5feb\u901f\u586b\u5165\u641c\u7d22\u680f", "Drag it to the text box to quickly fill in the search bar");
    }

    public static void enInitialize(LanguageProvider provider) {
        LangHandler.init();
        MachineLang.init();
        BlockLang.init();
        ItemLang.init();
        LANGS.forEach((k, v) -> {
            if (v.en() == null) {
                return;
            }
            provider.add(k, v.en());
        });
    }

    public static void cnInitialize(SimplifiedChineseLanguageProvider provider) {
        LANGS.forEach((k, v) -> {
            if (v.cn() == null) {
                return;
            }
            provider.add(k, v.cn());
        });
    }

    public static void twInitialize(TraditionalChineseLanguageProvider provider) {
        LANGS.forEach((k, v) -> {
            if (v.cn() == null) {
                return;
            }
            provider.add(k, ChineseConverter.convert((String)v.cn()));
        });
    }
}

