/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.saved;

import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.data.Galaxy;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public final class DysonSphereSavaedData
extends SavedData {
    private final Reference2IntOpenHashMap<Galaxy> dysonLaunchData;
    private final Reference2IntOpenHashMap<Galaxy> dysonDamageData = new Reference2IntOpenHashMap();
    private final Reference2BooleanOpenHashMap<Galaxy> dysonUse;
    public static DysonSphereSavaedData INSTANCE = new DysonSphereSavaedData();

    public static boolean getDimensionUse(ResourceKey<Level> dim) {
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)dim.m_135782_());
        if (galaxy == null) {
            return false;
        }
        return DysonSphereSavaedData.INSTANCE.dysonUse.getOrDefault((Object)galaxy, false);
    }

    public static IntIntImmutablePair getDimensionData(ResourceKey<Level> dim) {
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)dim.m_135782_());
        if (galaxy == null) {
            return IntIntImmutablePair.of((int)0, (int)0);
        }
        return IntIntImmutablePair.of((int)DysonSphereSavaedData.INSTANCE.dysonLaunchData.getOrDefault((Object)galaxy, 0), (int)DysonSphereSavaedData.INSTANCE.dysonDamageData.getOrDefault((Object)galaxy, 0));
    }

    public static int getDimensionLaunchData(ResourceKey<Level> dim) {
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)dim.m_135782_());
        if (galaxy == null) {
            return 0;
        }
        return DysonSphereSavaedData.INSTANCE.dysonLaunchData.getOrDefault((Object)galaxy, 0);
    }

    public static void setDysonData(ResourceKey<Level> dim, int a2, int b2) {
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)dim.m_135782_());
        if (galaxy == null) {
            return;
        }
        DysonSphereSavaedData.INSTANCE.dysonLaunchData.put((Object)galaxy, a2);
        DysonSphereSavaedData.INSTANCE.dysonDamageData.put((Object)galaxy, b2);
        INSTANCE.m_77762_();
    }

    public static void setDysonUse(ResourceKey<Level> dim, boolean a2) {
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)dim.m_135782_());
        if (galaxy == null) {
            return;
        }
        DysonSphereSavaedData.INSTANCE.dysonUse.put((Object)galaxy, a2);
        INSTANCE.m_77762_();
    }

    public DysonSphereSavaedData() {
        this.dysonLaunchData = new Reference2IntOpenHashMap();
        this.dysonUse = new Reference2BooleanOpenHashMap();
    }

    public DysonSphereSavaedData(CompoundTag compoundTag) {
        this();
        ListTag dyson = compoundTag.m_128437_("l", 10);
        for (int i = 0; i < dyson.size(); ++i) {
            CompoundTag tag = dyson.m_128728_(i);
            this.dysonLaunchData.put((Object)Galaxy.get((String)tag.m_128461_("g")), tag.m_128451_("c"));
            this.dysonDamageData.put((Object)Galaxy.get((String)tag.m_128461_("g")), tag.m_128451_("d"));
            this.dysonUse.put((Object)Galaxy.get((String)tag.m_128461_("g")), tag.m_128471_("u"));
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        this.dysonLaunchData.forEach((g, i) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("g", g.name());
            tag.m_128405_("c", i.intValue());
            tag.m_128405_("d", this.dysonDamageData.getOrDefault(g, 0));
            tag.m_128379_("u", this.dysonUse.getOrDefault(g, false));
            listTag.add((Object)tag);
        });
        compoundTag.m_128365_("l", (Tag)listTag);
        return compoundTag;
    }

    @Generated
    public Reference2IntOpenHashMap<Galaxy> getDysonLaunchData() {
        return this.dysonLaunchData;
    }

    @Generated
    public Reference2IntOpenHashMap<Galaxy> getDysonDamageData() {
        return this.dysonDamageData;
    }

    @Generated
    public Reference2BooleanOpenHashMap<Galaxy> getDysonUse() {
        return this.dysonUse;
    }
}

