/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtolib.api.machine.feature.IGravityPartMachine;
import com.gtolib.api.recipe.Recipe;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class GravityCondition
extends AbstractRecipeCondition {
    private final boolean zero;

    public GravityCondition(boolean zero) {
        this.zero = zero;
    }

    public RecipeConditionType<?> getType() {
        return GRAVITY;
    }

    public Component getTooltips() {
        return Component.m_237115_((String)("gtocore.condition." + (this.zero ? "zero_" : "") + "gravity"));
    }

    @Override
    public boolean test(@NotNull Recipe recipe, @NotNull RecipeLogic recipeLogic) {
        Planet planet;
        MetaMachine machine = recipeLogic.getMachine();
        if (machine instanceof MultiblockControllerMachine) {
            MultiblockControllerMachine controllerMachine = (MultiblockControllerMachine)machine;
            for (IMultiPart part : controllerMachine.getParts()) {
                if (!(part instanceof IGravityPartMachine)) continue;
                IGravityPartMachine gravityPart = (IGravityPartMachine)part;
                return gravityPart.getCurrentGravity() == (this.zero ? 0 : 100);
            }
        }
        return (planet = PlanetApi.API.getPlanet(machine.getLevel())) != null && planet.isSpace() && this.zero;
    }
}

