/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.trait;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachine;
import com.gtolib.api.ae2.stacks.IAEFluidKey;
import com.gtolib.api.ae2.stacks.IAEItemKey;
import com.gtolib.api.machine.trait.ExtendedRecipeHandlerList;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.machine.trait.NonStandardHandler;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeCapabilityMap;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.api.recipe.modifier.ParallelCache;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalSlotRecipeHandler {
    private final List<RecipeHandlerList> slotHandlers;

    public InternalSlotRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot[] slots) {
        this.slotHandlers = new ArrayList<RecipeHandlerList>(slots.length);
        for (MEPatternBufferPartMachine.InternalSlot slot : slots) {
            this.slotHandlers.add((RecipeHandlerList)new SlotRHL(buffer, slot));
        }
    }

    @Generated
    public List<RecipeHandlerList> getSlotHandlers() {
        return this.slotHandlers;
    }

    static final class SlotRHL
    extends AbstractRHL {
        final IRecipeHandlerTrait<Ingredient> itemRecipeHandler;
        final IRecipeHandlerTrait<FluidIngredient> fluidRecipeHandler;

        private SlotRHL(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot) {
            super(slot, (IMultiPart)buffer);
            this.itemRecipeHandler = new SlotItemRecipeHandler(buffer, slot);
            this.fluidRecipeHandler = new SlotFluidRecipeHandler(buffer, slot);
            this.addHandlers(new IRecipeHandler[]{this.itemRecipeHandler, this.fluidRecipeHandler, slot.circuitInventory, slot.shareInventory, slot.shareTank, buffer.circuitInventorySimulated, buffer.shareInventory, buffer.shareTank});
        }
    }

    private static abstract class NonstandardSlotRecipeHandler<ING>
    extends NotifiableRecipeHandlerTrait<ING>
    implements NonStandardHandler {
        final MEPatternBufferPartMachine.InternalSlot slot;

        private NonstandardSlotRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot) {
            super((MetaMachine)buffer);
            this.slot = slot;
            slot.setOnContentsChanged(() -> ((NonstandardSlotRecipeHandler)this).notifyListeners());
        }

        public boolean hasCapability(@Nullable Direction side) {
            return false;
        }

        public int getSize() {
            return 81;
        }

        public boolean isDistinct() {
            return true;
        }

        public IO getHandlerIO() {
            return IO.IN;
        }

        public boolean isRecipeOnly() {
            return true;
        }
    }

    private static final class SlotFluidRecipeHandler
    extends NonstandardSlotRecipeHandler<FluidIngredient> {
        private SlotFluidRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot) {
            super(buffer, slot);
            slot.setOnContentsChanged(() -> ((SlotFluidRecipeHandler)this).notifyListeners());
        }

        public List<FluidIngredient> handleRecipe(IO io, GTRecipe recipe, List left, boolean simulate) {
            if (this.slot.fluidInventory.isEmpty()) {
                return left;
            }
            return this.handleRecipeInner(io, recipe, new ArrayList<FluidIngredient>(left), simulate);
        }

        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
            return this.slot.handleFluidInternal(left, simulate);
        }

        public RecipeCapability<FluidIngredient> getCapability() {
            return FluidRecipeCapability.CAP;
        }

        public boolean forEachFluids(ObjectLongPredicate<FluidStack> function) {
            ObjectIterator it = this.slot.fluidInventory.reference2LongEntrySet().fastIterator();
            while (it.hasNext()) {
                Reference2LongMap.Entry e = (Reference2LongMap.Entry)it.next();
                long a2 = e.getLongValue();
                if (a2 < 1L) {
                    it.remove();
                    continue;
                }
                if (!function.test((Object)((AEFluidKey)e.getKey()).getReadOnlyStack(), a2)) continue;
                return true;
            }
            return false;
        }

        public void fastForEachFluids(ObjectLongConsumer<FluidStack> function) {
            this.slot.fluidInventory.reference2LongEntrySet().fastForEach(e -> {
                long a2 = e.getLongValue();
                if (a2 < 1L) {
                    return;
                }
                function.accept((Object)((AEFluidKey)e.getKey()).getReadOnlyStack(), a2);
            });
        }

        public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
            if (this.slot.fluidChanged) {
                this.slot.fluidChanged = false;
                this.slot.fluidIngredientMap.clear();
                this.slot.fluidInventory.reference2LongEntrySet().fastForEach(e -> {
                    long a2 = e.getLongValue();
                    if (a2 < 1L) {
                        return;
                    }
                    ((IAEFluidKey)e.getKey()).gtolib$convert(a2, this.slot.fluidIngredientMap);
                });
            }
            return this.slot.fluidIngredientMap;
        }
    }

    private static final class SlotItemRecipeHandler
    extends NonstandardSlotRecipeHandler<Ingredient> {
        private SlotItemRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot) {
            super(buffer, slot);
            slot.setOnContentsChanged(() -> ((SlotItemRecipeHandler)this).notifyListeners());
        }

        public List<Ingredient> handleRecipe(IO io, GTRecipe recipe, List left, boolean simulate) {
            if (this.slot.itemInventory.isEmpty()) {
                return left;
            }
            return this.handleRecipeInner(io, recipe, new ArrayList<Ingredient>(left), simulate);
        }

        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
            return this.slot.handleItemInternal(left, simulate);
        }

        public RecipeCapability<Ingredient> getCapability() {
            return ItemRecipeCapability.CAP;
        }

        public boolean forEachItems(ObjectLongPredicate<ItemStack> function) {
            ObjectIterator it = this.slot.itemInventory.reference2LongEntrySet().fastIterator();
            while (it.hasNext()) {
                Reference2LongMap.Entry e = (Reference2LongMap.Entry)it.next();
                long a2 = e.getLongValue();
                if (a2 < 1L) {
                    it.remove();
                    continue;
                }
                if (!function.test((Object)((AEItemKey)e.getKey()).getReadOnlyStack(), a2)) continue;
                return true;
            }
            return false;
        }

        public void fastForEachItems(ObjectLongConsumer<ItemStack> function) {
            this.slot.itemInventory.reference2LongEntrySet().fastForEach(e -> {
                long a2 = e.getLongValue();
                if (a2 < 1L) {
                    return;
                }
                function.accept((Object)((AEItemKey)e.getKey()).getReadOnlyStack(), a2);
            });
        }

        public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
            if (this.slot.itemChanged) {
                this.slot.itemChanged = false;
                this.slot.itemIngredientMap.clear();
                this.slot.itemInventory.reference2LongEntrySet().fastForEach(e -> {
                    long a2 = e.getLongValue();
                    if (a2 < 1L) {
                        return;
                    }
                    ((IAEItemKey)e.getKey()).gtolib$convert(a2, this.slot.itemIngredientMap);
                });
            }
            return this.slot.itemIngredientMap;
        }
    }

    static abstract class AbstractRHL
    extends ExtendedRecipeHandlerList {
        final MEPatternBufferPartMachine.InternalSlot slot;

        AbstractRHL(MEPatternBufferPartMachine.InternalSlot slot, IMultiPart part) {
            super(IO.IN, part);
            this.slot = slot;
            this.priority = 1000;
        }

        public ExtendedRecipeHandlerList wrapper() {
            return new WrapperRHL(this);
        }

        public boolean findRecipe(IRecipeCapabilityHolder holder, GTRecipeType recipeType, Predicate<GTRecipe> canHandle) {
            IntLongMap map;
            GTRecipeType type;
            if (this.slot.isEmpty() || !(holder instanceof IRecipeLogicMachine)) {
                return false;
            }
            IRecipeLogicMachine machine = (IRecipeLogicMachine)holder;
            if (this.slot.recipe != null) {
                GTRecipeType[] gTRecipeTypeArray;
                GTRecipeType gTRecipeType = this.slot.recipe.recipeType;
                if (machine.disabledCombined()) {
                    GTRecipeType[] gTRecipeTypeArray2 = new GTRecipeType[1];
                    gTRecipeTypeArray = gTRecipeTypeArray2;
                    gTRecipeTypeArray2[0] = machine.getRecipeType();
                } else {
                    gTRecipeTypeArray = machine.getRecipeTypes();
                }
                if (RecipeType.available((GTRecipeType)gTRecipeType, (GTRecipeType[])gTRecipeTypeArray)) {
                    holder.setCurrentHandlerList((RecipeHandlerList)this);
                    return canHandle.test((GTRecipe)this.slot.recipe);
                }
                this.slot.setRecipe(null);
            }
            if ((type = this.slot.machine.recipeType) != GTORecipeTypes.HATCH_COMBINED && type != recipeType && !machine.disabledCombined()) {
                if (GTRecipeType.available((GTRecipeType)type, (GTRecipeType[])machine.getRecipeTypes())) {
                    recipeType = type;
                } else {
                    return false;
                }
            }
            if ((map = this.getIngredientMap(recipeType)).isEmpty()) {
                return false;
            }
            holder.setCurrentHandlerList((RecipeHandlerList)this);
            return recipeType.db.find(map, canHandle);
        }

        public boolean isDistinct() {
            return true;
        }

        private Reference2LongOpenHashMap<Item> getItemMap(ParallelCache parallelCache) {
            Reference2LongOpenHashMap ingredientStacks = parallelCache.getItemIngredientMap();
            for (IRecipeHandler container : this.getCapability((RecipeCapability)ItemRecipeCapability.CAP)) {
                NonStandardHandler handler;
                if (container.isNotConsumable() || container instanceof NonStandardHandler && (handler = (NonStandardHandler)container).isNonStandardHandler()) continue;
                container.fastForEachItems((a2, b2) -> ingredientStacks.addTo((Object)a2.m_41720_(), b2));
            }
            return ingredientStacks;
        }

        public long getInputItemParallel(IRecipeLogicMachine holder, List<Content> contents, long parallelAmount) {
            ParallelCache parallelCache = IEnhancedRecipeLogic.of((RecipeLogic)holder.getRecipeLogic()).gtolib$getParallelCache();
            Reference2LongOpenHashMap<Item> ingredientStacks = null;
            for (Content content : contents) {
                Reference2LongMap.Entry e;
                FastSizedIngredient ingredient;
                long needed;
                Object object;
                if (content.chance <= 0 || !((object = content.content) instanceof FastSizedIngredient) || (needed = (ingredient = (FastSizedIngredient)object).getAmount()) < 1L) continue;
                long available = 0L;
                ObjectIterator it = this.slot.itemInventory.reference2LongEntrySet().fastIterator();
                while (it.hasNext() && (!ingredient.testItem(((AEItemKey)(e = (Reference2LongMap.Entry)it.next()).getKey()).getItem()) || (available += e.getLongValue()) < needed)) {
                }
                if (available < needed) {
                    Reference2LongMap.Entry inventoryEntry;
                    if (ingredientStacks == null) {
                        ingredientStacks = this.getItemMap(parallelCache);
                    }
                    ObjectIterator iter = ingredientStacks.reference2LongEntrySet().fastIterator();
                    while (iter.hasNext() && (!ingredient.testItem((Item)(inventoryEntry = (Reference2LongMap.Entry)iter.next()).getKey()) || (available += inventoryEntry.getLongValue()) < needed)) {
                    }
                }
                if (available >= needed) {
                    parallelAmount = Math.min(parallelAmount, available / needed);
                    continue;
                }
                parallelAmount = 0L;
                break;
            }
            parallelCache.cleanItemMap();
            return parallelAmount;
        }

        public long getInputFluidParallel(IRecipeLogicMachine holder, List<Content> contents, long parallelAmount) {
            for (Content content : contents) {
                FastFluidIngredient ingredient;
                long needed;
                Object object;
                if (content.chance <= 0 || !((object = content.content) instanceof FastFluidIngredient) || (needed = (long)(ingredient = (FastFluidIngredient)object).getAmount()) < 1L) continue;
                long available = 0L;
                ObjectIterator it = this.slot.fluidInventory.reference2LongEntrySet().fastIterator();
                while (it.hasNext()) {
                    Reference2LongMap.Entry e = (Reference2LongMap.Entry)it.next();
                    if (!ingredient.testFluid(((AEFluidKey)e.getKey()).getFluid())) continue;
                    available = e.getLongValue();
                    break;
                }
                if (available >= needed) {
                    parallelAmount = Math.min(parallelAmount, available / needed);
                    continue;
                }
                parallelAmount = 0L;
                break;
            }
            return parallelAmount;
        }

        public boolean handleRecipeContent(IO io, Recipe recipe, RecipeCapabilityMap<List<Object>> contents, boolean simulate) {
            List left;
            boolean item;
            if (this.slot.isEmpty() || this.slot.recipe != null && this.slot.recipe != recipe.rootRecipe) {
                return false;
            }
            boolean bl = item = contents.item == null;
            if (!item) {
                left = (List)contents.item;
                for (IRecipeHandler handler : this.getCapability((RecipeCapability)ItemRecipeCapability.CAP)) {
                    left = handler.handleRecipe(IO.IN, (GTRecipe)recipe, left, simulate);
                    if (left != null) continue;
                    item = true;
                    break;
                }
            }
            if (item) {
                if (contents.fluid == null) {
                    this.slot.setRecipe(recipe.rootRecipe);
                    return true;
                }
                left = (List)contents.fluid;
                for (IRecipeHandler handler : this.getCapability((RecipeCapability)FluidRecipeCapability.CAP)) {
                    left = handler.handleRecipe(IO.IN, (GTRecipe)recipe, left, simulate);
                    if (left != null) continue;
                    this.slot.setRecipe(recipe.rootRecipe);
                    return true;
                }
            }
            return false;
        }
    }

    private static class WrapperRHL
    extends AbstractRHL {
        private WrapperRHL(AbstractRHL rhl) {
            super(rhl.slot, rhl.part);
        }

        private Reference2LongOpenHashMap<Fluid> getFluidMap(ParallelCache parallelCache) {
            Reference2LongOpenHashMap ingredientStacks = parallelCache.getFluidIngredientMap();
            for (IRecipeHandler container : this.getCapability((RecipeCapability)FluidRecipeCapability.CAP)) {
                NonStandardHandler nonStandardHandler;
                if (container.isNotConsumable() || container instanceof NonStandardHandler && (nonStandardHandler = (NonStandardHandler)container).isNonStandardHandler()) continue;
                container.fastForEachFluids((a2, b2) -> ingredientStacks.addTo((Object)a2.getFluid(), b2));
            }
            return ingredientStacks;
        }

        @Override
        public long getInputFluidParallel(IRecipeLogicMachine holder, List<Content> contents, long parallelAmount) {
            ParallelCache parallelCache = IEnhancedRecipeLogic.of((RecipeLogic)holder.getRecipeLogic()).gtolib$getParallelCache();
            Reference2LongOpenHashMap<Fluid> ingredientStacks = null;
            for (Content content : contents) {
                FastFluidIngredient ingredient;
                long needed;
                Object object;
                if (content.chance <= 0 || !((object = content.content) instanceof FastFluidIngredient) || (needed = (long)(ingredient = (FastFluidIngredient)object).getAmount()) < 1L) continue;
                long available = 0L;
                ObjectIterator it = this.slot.fluidInventory.reference2LongEntrySet().fastIterator();
                while (it.hasNext()) {
                    Reference2LongMap.Entry e = (Reference2LongMap.Entry)it.next();
                    if (!ingredient.testFluid(((AEFluidKey)e.getKey()).getFluid())) continue;
                    available = e.getLongValue();
                    break;
                }
                if (available == 0L) {
                    if (ingredientStacks == null) {
                        ingredientStacks = this.getFluidMap(parallelCache);
                    }
                    it = ingredientStacks.reference2LongEntrySet().fastIterator();
                    while (it.hasNext()) {
                        Reference2LongMap.Entry inventoryEntry = (Reference2LongMap.Entry)it.next();
                        if (!ingredient.testFluid((Fluid)inventoryEntry.getKey())) continue;
                        available = inventoryEntry.getLongValue();
                        break;
                    }
                }
                if (available >= needed) {
                    parallelAmount = Math.min(parallelAmount, available / needed);
                    continue;
                }
                parallelAmount = 0L;
                break;
            }
            parallelCache.cleanFluidMap();
            return parallelAmount;
        }
    }
}

