/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.steam;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gtolib.api.machine.feature.IVacuumMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import lombok.Generated;

public final class SteamVacuumPumpMachine
extends SimpleSteamMachine
implements IVacuumMachine {
    @Persisted
    private int vacuumTier;
    private TickableSubscription tickSubs;

    public SteamVacuumPumpMachine(MetaMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public void afterWorking() {
        super.afterWorking();
        this.update();
    }

    private void tick() {
        this.vacuumTier = this.isHighPressure() && this.getRecipeLogic().getTotalContinuousRunningTime() > 1200L ? 2 : (this.getRecipeLogic().getTotalContinuousRunningTime() > (long)(this.isHighPressure() ? 600 : 1200) ? 1 : 0);
    }

    public int getVacuumTier() {
        return this.vacuumTier;
    }

    @Generated
    public TickableSubscription getTickSubs() {
        return this.tickSubs;
    }
}

