/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyMap;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.api.ae2.storage.CellDataStorage;
import com.gtolib.utils.SortUtils;
import com.hepdd.gtmthings.common.item.VirtualItemProviderBehavior;
import com.hepdd.gtmthings.data.CustomItems;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class VirtualItemProviderMachine
extends MetaMachine
implements IUIMachine,
IDropSaveMachine,
MEStorage,
IGridConnectedMachine,
IStorageProvider {
    private static final Item VIRTUAL_ITEM_PROVIDER = CustomItems.VIRTUAL_ITEM_PROVIDER.m_5456_();
    private static final AEKey EMPTY_STACK;
    private final CellDataStorage storage = new CellDataStorage();
    @Persisted
    private final NotifiableItemStackHandler inventory = new NotifiableItemStackHandler((MetaMachine)this, 288, IO.NONE, IO.BOTH);
    @Persisted
    private final GridNodeHolder nodeHolder = new GridNodeHolder((IGridConnectedMachine)this);
    @DescSynced
    private boolean isOnline;
    private boolean change = true;

    public VirtualItemProviderMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this);
        this.storage.setStoredMap(new AEKeyMap());
        this.inventory.addChangedListener(() -> {
            this.change = true;
            this.storage.getStoredMap().clear();
            this.storage.getStoredMap().addTo((Object)EMPTY_STACK, 576460752303423424L);
            for (int i = 0; i < this.inventory.storage.size; ++i) {
                ItemStack stack = this.inventory.storage.stacks[i];
                if (stack.m_41619_()) continue;
                if (stack.m_41720_() == VIRTUAL_ITEM_PROVIDER.m_5456_() && stack.m_41782_()) {
                    stack = stack.m_255036_(1);
                    stack.m_41784_().m_128379_("marked", true);
                    this.storage.getStoredMap().addTo((Object)AEItemKey.of((ItemStack)stack), 0x1FFFFFFFFFFFFFL);
                    continue;
                }
                int count = stack.m_41613_();
                stack = VirtualItemProviderBehavior.setVirtualItem((ItemStack)new ItemStack((ItemLike)VIRTUAL_ITEM_PROVIDER.m_5456_()), (ItemStack)stack);
                stack = stack.m_255036_(1);
                stack.m_41784_().m_128379_("marked", true);
                this.storage.getStoredMap().addTo((Object)AEItemKey.of((ItemStack)stack), 0x1FFFFFFFFFFFFFL * (long)count);
            }
        });
    }

    public void onLoad() {
        super.onLoad();
        this.inventory.notifyListeners();
    }

    public ModularUI createUI(Player entityPlayer) {
        int xOffset = 162;
        int yOverflow = 9;
        ModularUI modularUI = new ModularUI(xOffset + 19, 244, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(5, 5, () -> Component.m_237115_((String)this.getBlockState().m_60734_().m_7705_()).getString() + "(" + Stream.of(this.inventory.storage.stacks).filter(i -> !i.m_41619_()).count() + "/288)")).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)7, (int)162, (boolean)true));
        DraggableScrollableWidgetGroup innerContainer = new DraggableScrollableWidgetGroup(4, 4, xOffset + 6, 130).setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON).setYScrollBarWidth(4);
        modularUI.widget((Widget)new ButtonWidget(161, 3, 14, 14, (IGuiTexture)new ResourceTexture(GTOCore.id((String)"textures/gui/sort.png")), press -> SortUtils.sort()));
        int x = 0;
        int y = 0;
        for (int slot = 0; slot < 288; ++slot) {
            innerContainer.addWidget((Widget)new SlotWidget(this, (IItemHandlerModifiable)this.inventory.storage, slot, x * 18, y * 18){

                public boolean isEnabled() {
                    return true;
                }
            }.setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            if (++x != yOverflow) continue;
            x = 0;
            ++y;
        }
        WidgetGroup container = new WidgetGroup(3, 17, xOffset + 20, 140).addWidget((Widget)innerContainer);
        return modularUI.widget((Widget)container);
    }

    public void loadFromItem(CompoundTag tag) {
        this.inventory.storage.deserializeNBT(tag.m_128469_("inventory"));
    }

    public void saveToItem(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.inventory.storage.serializeNBT());
    }

    public void mountInventories(IStorageMounts storageMounts) {
        storageMounts.mount((MEStorage)this, 0x7FFFFFFE);
    }

    public Component getDescription() {
        return this.getDefinition().asItem().m_41466_();
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setOnline(boolean online) {
        this.isOnline = online;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEItemKey itemKey;
        return what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() == VIRTUAL_ITEM_PROVIDER && itemKey.hasTag();
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        ItemStack stack;
        CompoundTag tag;
        AEItemKey itemKey;
        if (amount > 0L && what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() == VIRTUAL_ITEM_PROVIDER && (tag = (stack = itemKey.getReadOnlyStack()).m_41783_()) != null && tag.f_128329_.containsKey("n")) {
            if (tag.m_128471_("marked")) {
                return amount;
            }
            if ((long)ItemHandlerHelper.insertItem((IItemHandler)this.inventory.storage, (ItemStack)stack, (boolean)mode.isSimulate()).m_41613_() < amount) {
                return amount;
            }
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        if (amount > 0L && what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() == VIRTUAL_ITEM_PROVIDER && this.storage.getStoredMap().containsKey((Object)itemKey)) {
            return amount;
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        AEKeyMap map = this.storage.getStoredMap();
        IKeyCounter.addAll((KeyCounter)out, (int)map.size(), m -> map.reference2LongEntrySet().fastForEach(e -> m.addTo((Object)((AEKey)e.getKey()), e.getLongValue())));
    }

    public KeyCounter getAvailableStacks() {
        KeyCounter keyCounter = this.storage.getKeyCounter();
        if (keyCounter == null) {
            keyCounter = new KeyCounter();
            this.storage.setKeyCounter(keyCounter);
            this.change = true;
        } else if (this.change) {
            keyCounter.clear();
        }
        if (this.change) {
            this.getAvailableStacks(keyCounter);
            keyCounter.removeEmptySubmaps();
            this.change = false;
        }
        return keyCounter;
    }

    static {
        ItemStack es = VirtualItemProviderBehavior.setVirtualItem((ItemStack)new ItemStack((ItemLike)VIRTUAL_ITEM_PROVIDER.m_5456_()), (ItemStack)ItemStack.f_41583_);
        es = es.m_255036_(1);
        es.m_41784_().m_128379_("marked", true);
        EMPTY_STACK = AEItemKey.of((ItemStack)es);
    }
}

