/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy.PlatformDeployment;

import com.gregtechceu.gtceu.utils.TaskHandler;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformBlockType;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformCreators;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import it.unimi.dsi.fastutil.chars.Char2ReferenceOpenHashMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LightEngine;

final class PlatformStructurePlacer {
    private final ServerLevel serverLevel;
    private final BlockIterator blockIterator;
    private final int perTick;
    private final boolean breakBlocks;
    private final boolean skipAir;
    private final boolean updateLight;
    private final IntConsumer onBatch;
    private final Runnable onFinished;
    private final ISubscription subscription;

    private PlatformStructurePlacer(ServerLevel serverLevel, BlockIterator blockIterator, int perTick, boolean breakBlocks, boolean skipAir, boolean updateLight, IntConsumer onBatch, Runnable onFinished) {
        this.serverLevel = serverLevel;
        this.blockIterator = blockIterator;
        this.perTick = perTick;
        this.breakBlocks = breakBlocks;
        this.skipAir = skipAir;
        this.updateLight = updateLight;
        this.onBatch = onBatch;
        this.onFinished = onFinished;
        this.subscription = TaskHandler.enqueueServerTick((ServerLevel)serverLevel, this::placeBatch, (int)0, (int)0);
    }

    private void placeBatch() {
        int processedThisTick = 0;
        while (this.blockIterator.hasNext() && processedThisTick < this.perTick) {
            FullChunkStatus fullStatus;
            EntityBlock entityBlock;
            BlockEntity be;
            Block block;
            int z;
            int localY;
            int x;
            LevelChunk chunk;
            LevelChunkSection section;
            BlockState oldState;
            BlockPos pos;
            int y;
            BlockIterator.Entry entry = this.blockIterator.next();
            BlockState state = entry.state();
            if (this.skipAir && state.m_60795_() || this.serverLevel.m_151562_(y = (pos = entry.pos()).m_123342_()) || (oldState = (section = (chunk = this.serverLevel.m_46745_(pos)).m_183278_(chunk.m_151564_(y))).m_62982_(x = pos.m_123341_() & 0xF, localY = y & 0xF, z = pos.m_123343_() & 0xF)).m_60734_() == GTOMachines.INDUSTRIAL_PLATFORM_DEPLOYMENT_TOOLS.get() || state.m_60795_() && oldState.m_60795_()) continue;
            if (!this.breakBlocks && !oldState.m_60795_()) {
                ++processedThisTick;
                continue;
            }
            if (oldState.m_60713_(Blocks.f_50752_)) {
                ++processedThisTick;
                continue;
            }
            section.m_62986_(x, localY, z, state);
            chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64249_(x, y, z, state);
            chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).m_64249_(x, y, z, state);
            chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR).m_64249_(x, y, z, state);
            chunk.m_6005_(Heightmap.Types.WORLD_SURFACE).m_64249_(x, y, z, state);
            if (this.updateLight && LightEngine.m_284387_((BlockGetter)this.serverLevel, (BlockPos)pos, (BlockState)oldState, (BlockState)state)) {
                this.serverLevel.m_7726_().m_7827_().m_7174_(pos);
            }
            oldState.m_60753_((Level)this.serverLevel, pos, state, false);
            if (oldState.m_155947_()) {
                this.serverLevel.m_46747_(pos);
            }
            if (state.m_155947_() && (block = state.m_60734_()) instanceof EntityBlock && (be = (entityBlock = (EntityBlock)block).m_142194_(pos, state)) != null) {
                this.serverLevel.m_151523_(be);
                chunk.m_142169_(be);
            }
            if ((fullStatus = chunk.m_287138_()).m_287205_(FullChunkStatus.BLOCK_TICKING)) {
                this.serverLevel.m_7726_().m_8450_(pos);
            }
            chunk.m_8092_(true);
            ++processedThisTick;
        }
        if (this.onBatch != null) {
            this.onBatch.accept(this.blockIterator.getProgressPercentage());
        }
        if (!this.blockIterator.hasNext()) {
            this.subscription.unsubscribe();
            if (this.onFinished != null) {
                this.onFinished.run();
            }
        }
    }

    static void placeStructureAsync(Level level, BlockPos startPos, PlatformBlockType.PlatformBlockStructure structure, int perTick, boolean breakBlocks, boolean skipAir, boolean updateLight, boolean zMirror, boolean xMirror, int rotation, IntConsumer onBatch, Runnable onFinished) throws IOException {
        block8: {
            String resourcePath = "assets/" + structure.resource().toString().replace(":", "/");
            try (InputStream input = PlatformStructurePlacer.class.getClassLoader().getResourceAsStream(resourcePath);){
                if (input == null) {
                    throw new FileNotFoundException("Structure file not found: " + String.valueOf(structure.resource()));
                }
                BlockIterator iterator = new BlockIterator(input, startPos, PlatformCreators.loadMappingFromJson(structure.blockMapping()), resourcePath, xMirror, zMirror, rotation);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    new PlatformStructurePlacer(serverLevel, iterator, perTick, breakBlocks, skipAir, updateLight, onBatch, onFinished);
                    break block8;
                }
                throw new IllegalArgumentException("Structure placement can only be done on ServerLevel");
            }
        }
    }

    private static class BlockIterator
    implements Iterator<Entry> {
        private final BufferedReader reader;
        private final BlockPos startPos;
        private final Char2ReferenceOpenHashMap<BlockState> blockMapping;
        private final Pattern aislePattern = Pattern.compile("\\.aisle\\(([^)]+)\\)");
        private final Pattern stringPattern = Pattern.compile("\"([^\"]+)\"");
        private String[] currentAisle;
        private int y = 0;
        private int x = 0;
        private int z = 0;
        private final int totalAisles;
        private int processedAisles = 0;
        private final boolean zMirror;
        private final boolean xMirror;
        private final int rotation;
        private final int sizeX;
        private final int sizeZ;
        private final int offsetX;
        private final int offsetY;
        private final int offsetZ;

        BlockIterator(InputStream input, BlockPos startPos, Char2ReferenceOpenHashMap<BlockState> blockMapping, String resourcePath, boolean zMirror, boolean xMirror, int rotation) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(input));
            this.startPos = startPos;
            this.blockMapping = blockMapping;
            this.totalAisles = BlockIterator.countTotalAisles(resourcePath);
            this.zMirror = zMirror;
            this.xMirror = xMirror;
            this.rotation = rotation;
            int sx = 0;
            int sy = 0;
            int sz = 0;
            try (InputStream sizeInput = PlatformStructurePlacer.class.getClassLoader().getResourceAsStream(resourcePath);){
                if (sizeInput != null) {
                    String line;
                    BufferedReader sizeReader = new BufferedReader(new InputStreamReader(sizeInput));
                    while ((line = sizeReader.readLine()) != null) {
                        Pattern sizePattern;
                        Matcher m;
                        if (!(line = line.trim()).startsWith(".size(") || !(m = (sizePattern = Pattern.compile("\\.size\\((\\d+), (\\d+), (\\d+)\\)")).matcher(line)).find()) continue;
                        sx = Integer.parseInt(m.group(1));
                        sy = Integer.parseInt(m.group(2));
                        sz = Integer.parseInt(m.group(3));
                        break;
                    }
                    sizeReader.close();
                }
            }
            this.sizeX = sx;
            this.sizeZ = sz;
            int minLx = Integer.MAX_VALUE;
            int minLy = Integer.MAX_VALUE;
            int minLz = Integer.MAX_VALUE;
            for (int iz = 0; iz < sz; ++iz) {
                for (int iy = 0; iy < sy; ++iy) {
                    for (int ix = 0; ix < sx; ++ix) {
                        int[] transformed = BlockIterator.transformCoords(ix, iy, iz, sx, sz, rotation, xMirror, zMirror);
                        minLx = Math.min(minLx, transformed[0]);
                        minLy = Math.min(minLy, transformed[1]);
                        minLz = Math.min(minLz, transformed[2]);
                    }
                }
            }
            this.offsetX = -minLx;
            this.offsetY = -minLy;
            this.offsetZ = -minLz;
            this.readNextAisle();
        }

        private static int[] transformCoords(int lx, int ly, int lz, int sx, int sz, int rotation, boolean xMirror, boolean zMirror) {
            int rx = lx;
            int rz = lz;
            switch (rotation) {
                case 90: {
                    int t = rx;
                    rx = sz - 1 - rz;
                    rz = t;
                    break;
                }
                case 180: {
                    rx = sx - 1 - rx;
                    rz = sz - 1 - rz;
                    break;
                }
                case 270: {
                    int t = rx;
                    rx = rz;
                    rz = sx - 1 - t;
                }
            }
            if (xMirror) {
                rx = sx - 1 - rx;
            }
            if (zMirror) {
                rz = sz - 1 - rz;
            }
            return new int[]{rx, ly, rz};
        }

        private static int countTotalAisles(String resourcePath) throws IOException {
            try (InputStream countInput = PlatformStructurePlacer.class.getClassLoader().getResourceAsStream(resourcePath);){
                String line;
                if (countInput == null) {
                    throw new FileNotFoundException("Structure file not found: " + resourcePath);
                }
                BufferedReader countReader = new BufferedReader(new InputStreamReader(countInput));
                int count = 0;
                while ((line = countReader.readLine()) != null) {
                    if (!line.trim().startsWith(".aisle(")) continue;
                    ++count;
                }
                int n = count;
                return n;
            }
        }

        private void readNextAisle() throws IOException {
            String line;
            while ((line = this.reader.readLine()) != null) {
                Matcher aisleMatcher;
                if (!(line = line.trim()).startsWith(".aisle(") || !(aisleMatcher = this.aislePattern.matcher(line)).find()) continue;
                String content = aisleMatcher.group(1);
                Matcher stringMatcher = this.stringPattern.matcher(content);
                ArrayList<String> rows = new ArrayList<String>();
                while (stringMatcher.find()) {
                    rows.add(stringMatcher.group(1));
                }
                if (rows.isEmpty()) continue;
                this.currentAisle = rows.toArray(new String[0]);
                this.y = 0;
                this.x = 0;
                ++this.processedAisles;
                return;
            }
            this.currentAisle = null;
        }

        int getProgressPercentage() {
            if (this.totalAisles == 0) {
                return 0;
            }
            return Math.min(100, (int)((double)this.processedAisles / (double)this.totalAisles * 100.0));
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.currentAisle == null) {
                        return false;
                    }
                    if (this.y < this.currentAisle.length) {
                        String row = this.currentAisle[this.y];
                        while (this.x < row.length()) {
                            char c = row.charAt(this.x);
                            if (this.blockMapping.containsKey(c)) {
                                return true;
                            }
                            ++this.x;
                        }
                        this.x = 0;
                        ++this.y;
                        continue;
                    }
                    this.readNextAisle();
                    ++this.z;
                }
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String row = this.currentAisle[this.y];
            char c = row.charAt(this.x);
            BlockState state = (BlockState)this.blockMapping.get(c);
            int[] transformed = BlockIterator.transformCoords(this.x, this.y, this.z, this.sizeX, this.sizeZ, this.rotation, this.xMirror, this.zMirror);
            int lx = transformed[0] + this.offsetX;
            int ly = transformed[1] + this.offsetY;
            int lz = transformed[2] + this.offsetZ;
            Rotation rotationEnum = switch (this.rotation) {
                case 90 -> Rotation.CLOCKWISE_90;
                case 180 -> Rotation.CLOCKWISE_180;
                case 270 -> Rotation.COUNTERCLOCKWISE_90;
                default -> Rotation.NONE;
            };
            state = state.m_60717_(rotationEnum);
            if (this.xMirror && this.zMirror) {
                state = state.m_60715_(Mirror.LEFT_RIGHT);
                state = state.m_60715_(Mirror.FRONT_BACK);
            } else if (this.xMirror) {
                state = state.m_60715_(Mirror.FRONT_BACK);
            } else if (this.zMirror) {
                state = state.m_60715_(Mirror.LEFT_RIGHT);
            }
            BlockPos pos = new BlockPos(this.startPos.m_123341_() + lx, this.startPos.m_123342_() + ly, this.startPos.m_123343_() + lz);
            Entry entry = new Entry(pos, state);
            ++this.x;
            return entry;
        }

        public record Entry(BlockPos pos, BlockState state) {
        }
    }
}

