/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy.PlatformDeployment;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.GTCEu;
import com.gtolib.GTOCore;
import com.gtolib.utils.RegistriesUtils;
import com.gtolib.utils.holder.IntObjectHolder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class PlatformBlockType {

    public record PlatformPreset(String name, @Nullable String displayName, @Nullable String description, @Nullable String source, List<PlatformBlockStructure> structures) {
        public PlatformPreset(String name, @Nullable String displayName, @Nullable String description, @Nullable String source, List<PlatformBlockStructure> structures) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(structures, "structures must not be null");
            if (structures.isEmpty()) {
                throw new IllegalArgumentException("structures must not be empty");
            }
            structures = ImmutableList.copyOf(structures);
        }

        public static PresetBuilder preset(String name) {
            return new PresetBuilder(name);
        }

        public static final class PresetBuilder {
            private final String name;
            private String displayName;
            private String description;
            private String source;
            private final List<PlatformBlockStructure> structures = new ArrayList<PlatformBlockStructure>();

            public PresetBuilder(String name) {
                this.name = name;
            }

            public PresetBuilder displayName(@Nullable String displayName) {
                this.displayName = displayName;
                return this;
            }

            public PresetBuilder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public PresetBuilder source(@Nullable String source) {
                this.source = source;
                return this;
            }

            public PresetBuilder addStructure(PlatformBlockStructure structure) {
                if (structure != null) {
                    this.structures.add(structure);
                }
                return this;
            }

            public PlatformPreset build() {
                if (GTCEu.isDataGen()) {
                    return null;
                }
                if (this.name == null || this.name.isEmpty()) {
                    GTOCore.LOGGER.error("Platform registration group error: missing name");
                    return null;
                }
                if (this.structures.isEmpty()) {
                    GTOCore.LOGGER.error("Platform registration group error: preset must contain at least one structure");
                    return null;
                }
                return new PlatformPreset(this.name, this.displayName, this.description, this.source, this.structures);
            }
        }
    }

    public record PlatformBlockStructure(String name, @Nullable String type, @Nullable String displayName, @Nullable String description, @Nullable String source, boolean preview, ResourceLocation resource, ResourceLocation blockMapping, int[] materials, List<IntObjectHolder<ItemStack>> extraMaterials, int xSize, int ySize, int zSize) {
        public PlatformBlockStructure(String name, @Nullable String type, @Nullable String displayName, @Nullable String description, @Nullable String source, boolean preview, ResourceLocation resource, ResourceLocation blockMapping, int[] materials, List<IntObjectHolder<ItemStack>> extraMaterials, int xSize, int ySize, int zSize) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(resource, "resource must not be null");
            Objects.requireNonNull(blockMapping, "blockMapping must not be null");
            Objects.requireNonNull(materials, "materials must not be null");
            Objects.requireNonNull(extraMaterials, "extraMaterials must not be null");
            materials = Arrays.copyOf(materials, materials.length);
            extraMaterials = ImmutableList.copyOf(extraMaterials);
            if (xSize % 16 != 0) {
                throw new IllegalArgumentException("X size must be multiple of 16");
            }
            if (zSize % 16 != 0) {
                throw new IllegalArgumentException("Z size must be multiple of 16");
            }
        }

        public static Builder structure(String name) {
            return new Builder(name);
        }

        public static final class Builder {
            private final String name;
            private String type = "default";
            private String displayName;
            private String description;
            private String source;
            private boolean preview = false;
            private ResourceLocation resource;
            private ResourceLocation symbolMap;
            private final int[] materials = new int[]{0, 0, 0};
            private final List<IntObjectHolder<ItemStack>> extraMaterials = new ArrayList<IntObjectHolder<ItemStack>>();

            public Builder(String name) {
                this.name = name;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder displayName(@Nullable String displayName) {
                this.displayName = displayName;
                return this;
            }

            public Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public Builder source(@Nullable String source) {
                this.source = source;
                return this;
            }

            public Builder preview(boolean preview) {
                this.preview = preview;
                return this;
            }

            public Builder resource(ResourceLocation resource) {
                this.resource = resource;
                return this;
            }

            public Builder symbolMap(ResourceLocation symbolMap) {
                this.symbolMap = symbolMap;
                return this;
            }

            public Builder materials(int material, int count) {
                this.materials[material] = count;
                return this;
            }

            public Builder extraMaterials(String item, int count) {
                this.extraMaterials.add((IntObjectHolder<ItemStack>)new IntObjectHolder(count, (Object)RegistriesUtils.getItemStack((String)item)));
                return this;
            }

            public Builder extraMaterials(Item item, int count) {
                this.extraMaterials.add((IntObjectHolder<ItemStack>)new IntObjectHolder(count, (Object)new ItemStack((ItemLike)item)));
                return this;
            }

            public Builder extraMaterials(ItemStack stack, int count) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                this.extraMaterials.add((IntObjectHolder<ItemStack>)new IntObjectHolder(count, (Object)copy));
                return this;
            }

            public PlatformBlockStructure build() {
                int[] sizes;
                block12: {
                    if (GTCEu.isDataGen()) {
                        return null;
                    }
                    if (this.name == null || this.name.isEmpty()) {
                        GTOCore.LOGGER.error("Platform registration error: missing name");
                        return null;
                    }
                    if (this.resource == null) {
                        GTOCore.LOGGER.error("Platform registration error: missing Structural Resources: {}", (Object)this.name);
                        return null;
                    }
                    if (this.symbolMap == null) {
                        GTOCore.LOGGER.error("Platform registration error: missing Block Mapping: {}", (Object)this.name);
                        return null;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(PlatformBlockType.class.getClassLoader().getResourceAsStream("assets/" + this.resource.toString().replace(":", "/")))));){
                        String line = reader.readLine().trim();
                        if (line.startsWith(".size(") && !line.isEmpty() && line.charAt(line.length() - 1) == ')') {
                            String[] parts = line.substring(6, line.length() - 1).split(",");
                            sizes = new int[]{Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim())};
                            break block12;
                        }
                        throw new IOException("Missing .size(...) definition in: " + String.valueOf(this.resource));
                    }
                    catch (Exception e) {
                        GTOCore.LOGGER.error("Failed to read structure size for {}: {}", (Object)this.resource, (Object)e.getMessage());
                        return null;
                    }
                }
                return new PlatformBlockStructure(this.name, this.type, this.displayName, this.description, this.source, this.preview, this.resource, this.symbolMap, this.materials, this.extraMaterials, sizes[0], sizes[1], sizes[2]);
            }
        }
    }
}

