/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import appeng.api.parts.IPartHost;
import appeng.parts.AEBasePart;
import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gtocore.integration.jade.provider.AEGridProvider;
import com.gtolib.api.ae2.IExpandedGrid;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.utils.RLUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public final class PerformanceMonitorMachine
extends MetaMachine
implements IFancyUIMachine {
    @RegisterLanguage(cn="AE\u7f51\u7edc", en="AE Grid")
    private static final String GRID = "gtocore.performance_monitor.grid";
    private static final Pattern PATTERN = Pattern.compile(", ");
    private List<Component> textListCache;
    private boolean grid = false;

    public PerformanceMonitorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private void handleDisplayClick(String componentData, ClickData clickData) {
        if (componentData.equals("grid")) {
            this.grid = !this.grid;
            this.textListCache = null;
        } else if (clickData.isRemote) {
            if (componentData.isEmpty()) {
                return;
            }
            String[] parts = PATTERN.split(componentData);
            if (parts.length == 4) {
                BlockPos pos = new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                EAEHighlightHandler.highlight((BlockPos)pos, (ResourceKey)GTODimensions.getDimensionKey((ResourceLocation)RLUtils.parse((String)parts[3])), (long)(System.currentTimeMillis() + 15000L));
            }
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private void addDisplayText(@NotNull List<Component> textList) {
        if (this.isRemote()) {
            return;
        }
        textList.add((Component)Component.m_237115_((String)"gtocore.digital_miner.show_range").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)(this.grid ? GRID : "config.gtceu.option.machines")), (String)"grid")));
        if (this.grid) {
            AEGridProvider.OBSERVE = true;
            if (this.textListCache == null || this.holder.getOffsetTimer() % 80 == 0) {
                this.textListCache = new ArrayList<Component>();
                TreeMap sortedMap = new TreeMap(Comparator.comparing(IExpandedGrid::getLatency).reversed());
                sortedMap.putAll(IExpandedGrid.PERFORMANCE_MAP);
                IExpandedGrid.PERFORMANCE_MAP.clear();
                for (Map.Entry entry : sortedMap.entrySet()) {
                    IExpandedGrid key = (IExpandedGrid)entry.getKey();
                    String pos = "";
                    ServerLevel level = null;
                    if (key.getPivot() != null) {
                        level = key.getPivot().getLevel();
                        Object o = key.getPivot().getOwner();
                        if (o != null) {
                            if (o instanceof AEBasePart) {
                                AEBasePart part = (AEBasePart)o;
                                IPartHost host = part.getHost();
                                if (host != null) {
                                    pos = host.getBlockEntity().m_58899_().m_123344_();
                                }
                            } else if (o instanceof BlockEntity) {
                                BlockEntity be = (BlockEntity)o;
                                pos = be.m_58899_().m_123344_();
                            } else if (o instanceof MetaMachine) {
                                MetaMachine machine = (MetaMachine)o;
                                pos = machine.getPos().m_123344_();
                            }
                        }
                    }
                    this.textListCache.add((Component)Component.m_237115_((String)key.toString()).m_130946_(" ").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"recipe.condition.dimension.tooltip", (Object[])new Object[]{level == null ? " " : level.m_46472_().m_135782_()}).m_130946_(" [").m_130946_(pos).m_130946_("] ")))).m_7220_((Component)Component.m_237110_((String)"gtocore.jade.grid_latency", (Object[])new Object[]{entry.getValue()}).m_130946_(" \u03bcs")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ ] "), (String)(pos + ", " + String.valueOf(level == null ? "" : level.m_46472_().m_135782_())))));
                }
            }
            textList.addAll(this.textListCache);
        }
    }
}

