/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.Comparator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class WaterPurificationPlantMachine
extends ElectricMultiblockMachine {
    static final int DURATION = 2400;
    static final Fluid GradePurifiedWater1 = GTOMaterials.FilteredSater.getFluid();
    static final Fluid GradePurifiedWater2 = GTOMaterials.OzoneWater.getFluid();
    static final Fluid GradePurifiedWater3 = GTOMaterials.FlocculentWater.getFluid();
    static final Fluid GradePurifiedWater4 = GTOMaterials.PHNeutralWater.getFluid();
    static final Fluid GradePurifiedWater5 = GTOMaterials.ExtremeTemperatureWater.getFluid();
    static final Fluid GradePurifiedWater6 = GTOMaterials.ElectricEquilibriumWater.getFluid();
    static final Fluid GradePurifiedWater7 = GTOMaterials.DegassedWater.getFluid();
    static final Fluid GradePurifiedWater8 = GTOMaterials.BaryonicPerfectionWater.getFluid();
    public static final Fluid[] GradePurifiedWater = new Fluid[]{GradePurifiedWater1, GradePurifiedWater2, GradePurifiedWater3, GradePurifiedWater4, GradePurifiedWater5, GradePurifiedWater6, GradePurifiedWater7, GradePurifiedWater8};
    long availableEu;
    final Object2BooleanSortedMap<WaterPurificationUnitMachine> waterPurificationUnitMachineMap = new Object2BooleanRBTreeMap(Comparator.comparingLong(a2 -> -a2.multiple));

    public WaterPurificationPlantMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        IIWirelessInteractor.addToNet((Object)((Object)this));
    }

    public void onUnload() {
        super.onUnload();
        IIWirelessInteractor.removeFromNet((Object)((Object)this));
    }

    public void onStructureInvalid() {
        IIWirelessInteractor.removeFromNet((Object)((Object)this));
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue()) continue;
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).getRecipeLogic().resetRecipeLogic();
            entry.setValue(false);
        }
        super.onStructureInvalid();
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue() || ((WaterPurificationUnitMachine)((Object)entry.getKey())).getRecipeLogic().getLastRecipe() == null) continue;
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).getRecipeLogic().onRecipeFinish();
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).onRecipeFinish();
            entry.setValue(false);
        }
    }

    public boolean onWorking() {
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue()) continue;
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).onWorking();
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).getRecipeLogic().setProgress(this.getRecipeLogic().getProgress());
        }
        return super.onWorking();
    }

    public void onWaiting() {
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue()) continue;
            ((WaterPurificationUnitMachine)((Object)entry.getKey())).getRecipeLogic().setWaiting(this.getEnhancedRecipeLogic().gtolib$getIdleReason());
        }
        super.onWaiting();
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            WaterPurificationUnitMachine machine = (WaterPurificationUnitMachine)((Object)entry.getKey());
            machine.setWorking(isWorkingAllowed);
            entry.setValue(machine.getRecipeLogic().isWorking());
        }
        super.setWorkingEnabled(isWorkingAllowed);
    }

    protected boolean beforeWorking(Recipe r) {
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            WaterPurificationUnitMachine m = (WaterPurificationUnitMachine)((Object)entry.getKey());
            if (!entry.getBooleanValue() || m.recipe == null) continue;
            RecipeLogic l = m.getRecipeLogic();
            l.resetRecipeLogic();
            if (l.isSuspend() || !m.isRecipeLogicAvailable()) continue;
            l.setupRecipe((GTRecipe)((WaterPurificationUnitMachine)((Object)entry.getKey())).recipe);
        }
        return true;
    }

    public int getOutputSignal(@Nullable Direction side) {
        if (this.getRecipeLogic().getProgress() == 0) {
            return 0;
        }
        return 15 * this.getRecipeLogic().getProgress() / 2400;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.digital_miner.show_range"), (String)"show"));
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        super.addDisplayText(textList);
        if (!this.isFormed()) {
            return;
        }
        textList.add((Component)Component.m_237115_((String)"gtocore.machine.water_purification_plant.bind"));
        for (Object2BooleanMap.Entry entry : this.waterPurificationUnitMachineMap.object2BooleanEntrySet()) {
            MutableComponent component = Component.m_237115_((String)((WaterPurificationUnitMachine)((Object)entry.getKey())).getBlockState().m_60734_().m_7705_()).m_130946_(" ");
            if (entry.getBooleanValue()) {
                component.m_7220_((Component)Component.m_237115_((String)"gtceu.multiblock.running").m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"gtceu.multiblock.energy_consumption", (Object[])new Object[]{FormattingUtil.formatNumbers((long)((WaterPurificationUnitMachine)((Object)entry.getKey())).eut), Component.m_237113_((String)GTValues.VNF[GTUtil.getTierByVoltage((long)((WaterPurificationUnitMachine)((Object)entry.getKey())).eut)])})));
            } else {
                component.m_7220_((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            textList.add((Component)component);
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (clickData.isRemote && "show".equals(componentData)) {
            ClientUtil.highlighting((BlockPos)this.getPos(), (int)32);
        }
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    @Nullable
    private Recipe getRecipe() {
        Recipe recipe;
        long eut = 0L;
        if (this.getEnergyContainer().getEnergyStored() < 1000L) {
            return null;
        }
        this.availableEu = this.getOverclockVoltage();
        ObjectBidirectionalIterator it = this.waterPurificationUnitMachineMap.object2BooleanEntrySet().iterator();
        while (it.hasNext()) {
            Object2BooleanMap.Entry entry = (Object2BooleanMap.Entry)it.next();
            entry.setValue(false);
            WaterPurificationUnitMachine machine = (WaterPurificationUnitMachine)((Object)entry.getKey());
            if (machine.isFormed() && !machine.isInValid()) {
                long eu;
                if (!machine.getRecipeLogic().isIdle() || (eu = machine.before()) <= 0L) continue;
                entry.setValue(true);
                this.availableEu -= eu;
                eut += eu;
                continue;
            }
            it.remove();
        }
        if (eut > 0L && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)(recipe = this.getRecipeBuilder().duration(2400).EUt(eut).buildRawRecipe()))) {
            return recipe;
        }
        return null;
    }
}

