/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class OzonationPurificationUnitMachine
extends WaterPurificationUnitMachine
implements IExplosionMachine {
    private static final Fluid Ozone = GTOMaterials.Ozone.getFluid();

    public OzonationPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 2L);
    }

    @Override
    long before() {
        this.eut = 0L;
        long[] a2 = this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater1, Ozone});
        long ozoneCount = a2[1];
        if (ozoneCount > 1024000L) {
            this.inputFluid(Ozone, ozoneCount);
            this.doExplosion(10.0f);
        } else {
            long inputCount = Math.min(this.parallel(), Math.min(a2[0], ozoneCount * 10000L));
            if (inputCount > 0L) {
                long outputCount = inputCount * 9L / 10L;
                RecipeBuilder builder = this.getRecipeBuilder();
                builder.duration(2400).inputFluids(Ozone, inputCount / 10000L).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater1, inputCount);
                if (Math.random() * 100.0 <= (double)this.getChance(outputCount / 10L, ozoneCount)) {
                    builder.outputFluids(WaterPurificationPlantMachine.GradePurifiedWater2, outputCount);
                } else {
                    builder.outputFluids(WaterPurificationPlantMachine.GradePurifiedWater1, outputCount);
                }
                this.recipe = builder.buildRawRecipe();
                if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                    this.calculateVoltage(inputCount);
                }
            }
        }
        return this.eut;
    }

    private int getChance(long count, long ozoneCount) {
        int a2 = (int)(80.0 * Math.log(1.0 + (double)ozoneCount / 10000.0) / Math.log(103.0));
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater3, count / 4L)) {
            return a2 + 20;
        }
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater2, count)) {
            return a2 + 15;
        }
        return a2;
    }
}

