/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gtocore.common.machine.multiblock.part.IndicatorHatchPartMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.machine.part.ItemPartMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class HighEnergyLaserPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final List<Item> LENS = List.of(ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Red), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Orange), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Brown), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Yellow), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Green), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Cyan), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Blue), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Purple), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Magenta), ChemicalHelper.getItem((TagPrefix)TagPrefix.lens, (Material)MarkerMaterials.Color.Pink));
    @Persisted
    private int index;
    @Persisted
    private int time;
    @Persisted
    private int await;
    @Persisted
    private int working;
    @Persisted
    private int chance;
    @Persisted
    private long inputCount;
    private IndicatorHatchPartMachine indicatorHatchPartMachine;
    private ItemPartMachine ItemPartMachine;

    public HighEnergyLaserPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 32L);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.indicatorHatchPartMachine == null && part instanceof IndicatorHatchPartMachine) {
            IndicatorHatchPartMachine lensSensorPart;
            this.indicatorHatchPartMachine = lensSensorPart = (IndicatorHatchPartMachine)part;
        } else if (this.ItemPartMachine == null && part instanceof ItemPartMachine) {
            ItemPartMachine itemHatchPart;
            this.ItemPartMachine = itemHatchPart = (ItemPartMachine)part;
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.indicatorHatchPartMachine = null;
        this.ItemPartMachine = null;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237110_((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{this.chance}));
            textList.add((Component)Component.m_237110_((String)"attributeslib.gui.current", (Object[])new Object[]{LENS.get(this.index).m_41466_()}));
        }
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getRecipeLogic().getProgress() > this.time) {
            this.time = GTValues.RNG.m_188503_(120) + 120 + this.getRecipeLogic().getProgress();
            this.index = this.index < 9 ? ++this.index : 0;
            this.await = 80;
        }
        if (this.working > 0 && this.match()) {
            ++this.working;
        }
        if (this.working > 80) {
            this.working = -1;
            this.chance += 10;
        }
        if (this.await > 0) {
            if (this.match()) {
                this.await = 0;
                this.working = 1;
            } else {
                this.indicatorHatchPartMachine.setRedstoneSignalOutput(15);
            }
            --this.await;
        } else {
            this.indicatorHatchPartMachine.setRedstoneSignalOutput(0);
        }
        return true;
    }

    private boolean match() {
        return this.ItemPartMachine.getInventory().storage.getStackInSlot(0).m_150930_(LENS.get(this.index));
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        if (GTValues.RNG.m_188503_(100) <= this.chance) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater6, this.inputCount * 9L / 10L);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.chance = 0;
        this.time = GTValues.RNG.m_188503_(120) + 120;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater5})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater5, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.calculateVoltage(this.inputCount);
            }
        }
        return this.eut;
    }
}

