/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.storage;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.client.hud.Configurator;
import com.gtocore.common.block.WirelessEnergyUnitBlock;
import com.gtolib.api.capability.IExtendWirelessEnergyContainerHolder;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.NoRecipeLogicMultiblockMachine;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.gtolib.utils.FunctionContainer;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.hepdd.gtmthings.utils.BigIntegerUtils;
import com.hepdd.gtmthings.utils.TeamUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WirelessEnergySubstationMachine
extends NoRecipeLogicMultiblockMachine
implements IExtendWirelessEnergyContainerHolder,
ITierCasingMachine,
IEnergyInfoProvider {
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    private final TierCasingTrait tierCasingTrait;
    private final Multimap<Integer, BlockPos> wirelessEnergyUnitPositions = Multimaps.newMultimap((Map)new Int2ObjectOpenHashMap(), ObjectOpenHashSet::new);
    @Persisted
    private ResourceLocation dimension;

    public WirelessEnergySubstationMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_b"});
    }

    private void loadContainer() {
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        int tier = this.getCasingTier("g_b");
        FunctionContainer functionContainer = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"wirelessEnergyUnit");
        int loss = 0;
        int i = 0;
        BigInteger capacity = BigInteger.ZERO;
        if (functionContainer != null) {
            ArrayList blocks = (ArrayList)functionContainer.getValue();
            for (WirelessEnergyUnitBlock.BlockData block : blocks) {
                if (block.block() == null) {
                    this.wirelessEnergyUnitPositions.put((Object)0, (Object)block.pos());
                    continue;
                }
                if (block.block().getTier() <= tier) {
                    ++i;
                    capacity = capacity.add(block.block().getCapacity());
                    loss += block.block().getLoss();
                }
                this.wirelessEnergyUnitPositions.put((Object)block.block().getTier(), (Object)block.pos());
            }
            blocks.clear();
        }
        container.setLoss(i == 0 ? 0 : loss / i);
        container.setCapacity(capacity.multiply(BigInteger.valueOf(Math.max(1, i / 2))));
        this.dimension = level.m_46472_().m_135782_();
        container.setDimension(this.dimension, true);
    }

    private void unloadContainer() {
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.wirelessEnergyUnitPositions.clear();
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        container.setCapacity(BigInteger.ZERO);
        container.setLoss(0);
        container.setDimension(level.m_46472_().m_135782_(), false);
    }

    public void onStructureInvalid() {
        this.unloadContainer();
        super.onStructureInvalid();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.loadContainer();
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() instanceof ServerLevel) {
            ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
            if (container == null) {
                return;
            }
            if (this.dimension != null) {
                container.setDimension(this.dimension, true);
            }
            if (this.isFormed()) {
                this.loadContainer();
            }
        }
    }

    public void onUnload() {
        this.unloadContainer();
        super.onUnload();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (this.getUUID() == null) {
            return;
        }
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.0", (Object[])new Object[]{TeamUtil.GetName((Level)this.getLevel(), (UUID)this.getUUID())}).m_130940_(ChatFormatting.AQUA));
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.1", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)container.getStorage()) + " / " + FormattingUtil.formatNumbers((Object)container.getCapacity())}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.2", (Object[])new Object[]{FormattingUtil.formatNumbers((long)container.getRate()), container.getRate() / GTValues.VEX[GTUtil.getFloorTierByVoltage((long)container.getRate())], Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage((long)container.getRate())])}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{(double)container.getLoss() / 10.0}));
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
        Configurator c = new Configurator((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_OFF);
        iFancyConfiguratorArray[0] = c;
        configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
        if (this.isRemote()) {
            c.setHudInstance("wireless_energy_hud");
        }
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }

    public IEnergyInfoProvider.EnergyInfo getEnergyInfo() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return new IEnergyInfoProvider.EnergyInfo(BigInteger.ZERO, BigInteger.ZERO);
        }
        return new IEnergyInfoProvider.EnergyInfo(container.getCapacity(), container.getStorage());
    }

    public boolean supportsBigIntEnergyValues() {
        return true;
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer WirelessEnergyContainerCache) {
        this.WirelessEnergyContainerCache = WirelessEnergyContainerCache;
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    public long getInputPerSec() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return 0L;
        }
        long input = BigIntegerUtils.getLongValue((BigInteger)container.getEnergyStat().getAvgEnergy().toBigInteger());
        return input > 0L ? input : 0L;
    }

    public long getOutputPerSec() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return 0L;
        }
        long output = BigIntegerUtils.getLongValue((BigInteger)container.getEnergyStat().getAvgEnergy().toBigInteger().negate());
        return output > 0L ? output : 0L;
    }

    public int substituteBlocks(WirelessEnergyUnitBlock block, int count, ServerPlayer player) {
        if (this.getLevel() == null || this.wirelessEnergyUnitPositions.isEmpty()) {
            return 0;
        }
        O2OOpenCacheHashMap map = new O2OOpenCacheHashMap(count);
        int tier = block.getTier();
        block0: for (int t = 0; t <= tier; ++t) {
            for (BlockPos pos : this.wirelessEnergyUnitPositions.get((Object)t)) {
                if (count <= 0) break block0;
                if (pos == null) continue;
                map.put(new WirelessEnergyUnitBlock.BlockData(WirelessEnergyUnitBlock.get(t), pos), block);
                --count;
            }
        }
        int successfulCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            BlockPos pos = ((WirelessEnergyUnitBlock.BlockData)entry.getKey()).pos();
            WirelessEnergyUnitBlock originBlockDrop = ((WirelessEnergyUnitBlock.BlockData)entry.getKey()).block();
            if (!this.getLevel().m_7731_(pos, ((WirelessEnergyUnitBlock)((Object)entry.getValue())).m_49966_(), 11)) continue;
            ++successfulCount;
            if (originBlockDrop == null || player.m_150109_().m_36054_(originBlockDrop.m_5456_().m_7968_())) continue;
            player.m_36176_(originBlockDrop.m_5456_().m_7968_(), false);
        }
        this.requestCheck();
        return successfulCount;
    }
}

