/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.storage;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.api.transfer.item.LockableItemStackHandler;
import com.gtolib.GTOCore;
import com.gtolib.utils.SortUtils;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MultiblockCrateMachine
extends MultiblockControllerMachine
implements IUIMachine,
IDropSaveMachine {
    public static final int Capacity = 576;
    @Persisted
    private final NotifiableItemStackHandler inventory = new NotifiableItemStackHandler((MetaMachine)this, 576, IO.BOTH);
    private final LockableItemStackHandler itemStackHandler = new LockableItemStackHandler((IItemHandlerModifiable)this.inventory).setLock(true);

    public MultiblockCrateMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return this.isFormed && super.shouldOpenUI(player, hand, hit);
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return this.itemStackHandler;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.itemStackHandler.setLock(false);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.itemStackHandler.setLock(true);
    }

    public ModularUI createUI(Player entityPlayer) {
        int xOffset = 162;
        int yOverflow = 9;
        ModularUI modularUI = new ModularUI(xOffset + 19, 244, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(5, 5, () -> Component.m_237115_((String)this.getBlockState().m_60734_().m_7705_()).getString() + "(" + Stream.of(this.inventory.storage.stacks).filter(i -> !i.m_41619_()).count() + "/576)")).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)7, (int)162, (boolean)true));
        DraggableScrollableWidgetGroup innerContainer = new DraggableScrollableWidgetGroup(4, 4, xOffset + 6, 130).setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON).setYScrollBarWidth(4);
        modularUI.widget((Widget)new ButtonWidget(161, 3, 14, 14, (IGuiTexture)new ResourceTexture(GTOCore.id((String)"textures/gui/sort.png")), press -> SortUtils.sort()));
        int x = 0;
        int y = 0;
        for (int slot = 0; slot < 576; ++slot) {
            innerContainer.addWidget((Widget)new SlotWidget(this, (IItemHandlerModifiable)this.inventory.storage, slot, x * 18, y * 18){

                public boolean isEnabled() {
                    return true;
                }
            }.setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            if (++x != yOverflow) continue;
            x = 0;
            ++y;
        }
        WidgetGroup container = new WidgetGroup(3, 17, xOffset + 20, 140).addWidget((Widget)innerContainer);
        return modularUI.widget((Widget)container);
    }

    public void loadFromItem(CompoundTag tag) {
        this.inventory.storage.deserializeNBT(tag.m_128469_("inventory"));
    }

    public void saveToItem(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.inventory.storage.serializeNBT());
    }
}

