/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.storage;

import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.multiblock.part.ae.StorageAccessPartMachine;
import com.gtolib.api.ae2.storage.BigCellDataStorage;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.multiblock.IStorageMultiblock;
import com.gtolib.api.machine.multiblock.NoRecipeLogicMultiblockMachine;
import com.gtolib.utils.FunctionContainer;
import com.gtolib.utils.NumberUtils;
import com.gtolib.utils.StringUtils;
import com.hepdd.gtmthings.api.capability.IBindable;
import com.hepdd.gtmthings.utils.BigIntegerUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public final class MEStorageMachine
extends NoRecipeLogicMultiblockMachine
implements IBindable,
IDropSaveMachine,
IStorageMultiblock {
    public static final long infinite = 1000000000000L;
    @RegisterLanguage(en="Data Index Position: ", cn="\u6570\u636e\u7d22\u5f15\u4f4d\u7f6e\uff1a")
    private static final String MODE = "gtocore.machine.me_storage.mode";
    @Persisted
    private final NotifiableItemStackHandler machineStorage;
    @Persisted
    private UUID uuid;
    @Persisted
    private boolean player = true;
    private StorageAccessPartMachine accessPartMachine;
    private final List<Reference2ReferenceMap.Entry<AEKey, BigInteger>> list = new ArrayList<Reference2ReferenceMap.Entry<AEKey, BigInteger>>();

    public MEStorageMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.machineStorage = this.createMachineStorage(i -> i.m_41720_() == GTOItems.INFINITE_CELL_COMPONENT.m_5456_());
    }

    public void onMachineChanged() {
        this.unloadContainer();
        this.loadContainer();
    }

    private void loadContainer() {
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        for (IMultiPart part : this.getParts()) {
            StorageAccessPartMachine storageAccessPartMachine;
            if (!(part instanceof StorageAccessPartMachine)) continue;
            this.accessPartMachine = storageAccessPartMachine = (StorageAccessPartMachine)part;
            break;
        }
        if (this.accessPartMachine == null) {
            return;
        }
        FunctionContainer functionContainer = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"MEStorageCore");
        if (functionContainer == null) {
            return;
        }
        if (this.player) {
            this.accessPartMachine.setUUID(this.getOwnerUUID());
        } else {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.accessPartMachine.setUUID(this.uuid);
        }
        this.accessPartMachine.setCapacity((Double)functionContainer.getValue());
        this.accessPartMachine.setInfinite(this.accessPartMachine.getCapacity() > 1.0E12 && this.getStorageStack().m_41613_() == 64);
        this.accessPartMachine.setCheck(true);
    }

    private void unloadContainer() {
        if (this.accessPartMachine != null) {
            this.accessPartMachine.setCapacity(0.0);
            this.accessPartMachine.setUUID(null);
            this.accessPartMachine.setCheck(false);
            this.accessPartMachine.setInfinite(false);
            this.accessPartMachine = null;
        }
    }

    public void onStructureInvalid() {
        this.unloadContainer();
        super.onStructureInvalid();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (this.isFormed()) {
            this.loadContainer();
        }
    }

    public void onUnload() {
        this.unloadContainer();
        super.onUnload();
    }

    public Widget createUIWidget() {
        return this.createUIWidget(super.createUIWidget());
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        textList.add((Component)Component.m_237115_((String)MODE).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[").m_7220_((Component)(this.player ? Component.m_237115_((String)"gtceu.ownership.name.player") : Component.m_237115_((String)"config.gtceu.option.machines"))).m_130946_("]"), (String)"switch")));
        if (this.accessPartMachine != null) {
            if (this.getOffsetTimer() % 10 == 0) {
                this.accessPartMachine.setObserve(true);
            }
            textList.add((Component)Component.m_237110_((String)"gui.ae2.BytesUsed", (Object[])new Object[]{NumberUtils.numberText((double)this.accessPartMachine.getBytes()).m_130946_(" / ").m_130946_(this.accessPartMachine.isInfinite() ? StringUtils.full_color((String)"infinity") : NumberUtils.formatDouble((double)this.accessPartMachine.getCapacity())).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.GRAY));
            textList.add((Component)Component.m_237113_((String)String.valueOf(this.accessPartMachine.getTypes())).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"gui.ae2.Types").m_130940_(ChatFormatting.GRAY))));
            StorageAccessPartMachine storageAccessPartMachine = this.accessPartMachine;
            if (storageAccessPartMachine instanceof StorageAccessPartMachine.Big) {
                StorageAccessPartMachine.Big machine = (StorageAccessPartMachine.Big)storageAccessPartMachine;
                BigCellDataStorage data = machine.getCellStorage();
                if (data == BigCellDataStorage.EMPTY) {
                    return;
                }
                Reference2ReferenceOpenHashMap map = data.getStoredMap();
                if (map == null) {
                    return;
                }
                this.list.clear();
                map.reference2ReferenceEntrySet().forEach(entry -> {
                    BigInteger currentAmount = (BigInteger)entry.getValue();
                    if (currentAmount.compareTo(BigIntegerUtils.BIG_INTEGER_MAX_LONG) > 0) {
                        this.list.add((Reference2ReferenceMap.Entry<AEKey, BigInteger>)entry);
                    }
                });
                this.list.sort((e1, e2) -> ((BigInteger)e2.getValue()).compareTo((BigInteger)e1.getValue()));
                this.list.forEach(entry -> textList.add((Component)((AEKey)entry.getKey()).getDisplayName().m_6881_().m_130946_(": ").m_7220_((Component)NumberUtils.numberText((double)((BigInteger)entry.getValue()).doubleValue())).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote && "switch".equals(componentData)) {
            this.player = !this.player;
            this.onMachineChanged();
        }
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public boolean saveBreak() {
        return this.uuid != null;
    }

    public boolean savePickClone() {
        return false;
    }

    public void saveToItem(CompoundTag tag) {
        if (this.uuid != null) {
            tag.m_128362_("uuid", this.uuid);
        }
    }

    public void loadFromItem(CompoundTag tag) {
        if (tag.m_128403_("uuid")) {
            this.uuid = tag.m_128342_("uuid");
        }
    }

    public NotifiableItemStackHandler getMachineStorage() {
        return this.machineStorage;
    }
}

