/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.maintenance;

import com.fast.fastcollection.OpenCacheHashSet;
import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.DummyCleanroom;
import com.gregtechceu.gtceu.common.machine.multiblock.part.AutoMaintenanceHatchPartMachine;
import com.gtolib.api.machine.GTOCleanroomType;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CMHatchPartMachine
extends AutoMaintenanceHatchPartMachine {
    private static final Set<CleanroomType> CLEANROOM = new OpenCacheHashSet(2, 0.9f);
    private static final Set<CleanroomType> STERILE_CLEANROOM = new OpenCacheHashSet(3, 0.9f);
    private static final Set<CleanroomType> LAW_CLEANROOM = new OpenCacheHashSet(4, 0.9f);
    public static final ICleanroomProvider DUMMY_CLEANROOM;
    public static final ICleanroomProvider STERILE_DUMMY_CLEANROOM;
    public static final ICleanroomProvider LAW_DUMMY_CLEANROOM;
    private final ICleanroomProvider cleanroomTypes;

    public CMHatchPartMachine(MetaMachineBlockEntity metaTileEntityId, ICleanroomProvider cleanroomTypes) {
        super(metaTileEntityId);
        this.cleanroomTypes = cleanroomTypes;
    }

    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)controller;
            receiver.setCleanroom(this.cleanroomTypes);
        }
    }

    public void removedFromController(IMultiController controller) {
        ICleanroomReceiver receiver;
        super.removedFromController(controller);
        if (controller instanceof ICleanroomReceiver && (receiver = (ICleanroomReceiver)controller).getCleanroom() == this.cleanroomTypes) {
            receiver.setCleanroom(null);
        }
    }

    public static ImmutableSet<CleanroomType> getCleanroomTypes(ICleanroomProvider p) {
        return ImmutableSet.copyOf((Collection)p.getTypes());
    }

    static {
        CLEANROOM.add(CleanroomType.CLEANROOM);
        STERILE_CLEANROOM.addAll(CLEANROOM);
        STERILE_CLEANROOM.add(CleanroomType.STERILE_CLEANROOM);
        LAW_CLEANROOM.addAll(STERILE_CLEANROOM);
        LAW_CLEANROOM.add(GTOCleanroomType.LAW_CLEANROOM);
        DUMMY_CLEANROOM = DummyCleanroom.createForTypes(CLEANROOM);
        STERILE_DUMMY_CLEANROOM = DummyCleanroom.createForTypes(STERILE_CLEANROOM);
        LAW_DUMMY_CLEANROOM = DummyCleanroom.createForTypes(LAW_CLEANROOM);
    }
}

