/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.maintenance;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredPartMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public class ACMHatchPartMachine
extends WorkableTieredPartMachine
implements IMaintenanceMachine {
    @DynamicInitialValue(key="maintenance.configurable_duration.max", typeKey="multiplier", easyValue="1.3F", normalValue="1.2F", expertValue="1.1F", cn="\u914d\u65b9\u5904\u7406\u901f\u5ea6\u8c03\u8282\u4e0a\u9650 : %s \u500d", cnComment="\u4e0d\u8ba1\u8d85\u9891\uff0c\u914d\u65b9\u5904\u7406\u901f\u5ea6\u4e3a\u6b63\u5e38\u901f\u5ea6\u7684\u6700\u9ad8\u500d\u7387", en="Configurable Recipe Speed Multiplier Maximum : %s Multiplier", enComment="Ignore overclocking, the recipe processing speed is the highest multiplier for normal speed")
    private static float MAX_DURATION_MULTIPLIER = 1.0f;
    @DynamicInitialValue(key="maintenance.configurable_duration.min", typeKey="multiplier", easyValue="0.7F", normalValue="0.8F", expertValue="0.9F", cn="\u914d\u65b9\u5904\u7406\u901f\u5ea6\u8c03\u8282\u4e0b\u9650 : %s \u500d", cnComment="\u4e0d\u8ba1\u8d85\u9891\uff0c\u914d\u65b9\u5904\u7406\u901f\u5ea6\u4e3a\u6b63\u5e38\u901f\u5ea6\u7684\u6700\u4f4e\u500d\u7387", en="Configurable Recipe Speed Multiplier Minimum : %s Multiplier", enComment="Ignore overclocking, the recipe processing speed is the lowest multiplier for normal speed")
    private static float MIN_DURATION_MULTIPLIER = 1.0f;
    private static final float DURATION_ACTION_AMOUNT = 0.01f;
    @Persisted
    private float durationMultiplier = 1.0f;

    protected void setDurationMultiplierPercent(float durationMultiplierPercent) {
        this.durationMultiplier = durationMultiplierPercent / 100.0f;
    }

    protected float getDurationMultiplierPercent() {
        return this.durationMultiplier * 100.0f;
    }

    public ACMHatchPartMachine(MetaMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId, 5);
    }

    public void setTaped(boolean ignored) {
    }

    public boolean isTaped() {
        return false;
    }

    public boolean isFullAuto() {
        return true;
    }

    public byte startProblems() {
        return 63;
    }

    public byte getMaintenanceProblems() {
        return 63;
    }

    public void setMaintenanceProblems(byte problems) {
    }

    public int getTimeActive() {
        return 0;
    }

    public void setTimeActive(int time) {
    }

    @Nullable
    public GTRecipe modifyRecipe(IWorkableMultiController controller, GTRecipe recipe) {
        recipe.duration = Math.max(1, (int)((float)recipe.duration * this.durationMultiplier));
        return recipe;
    }

    public float getTimeMultiplier() {
        float result = 1.0f;
        result = (double)this.durationMultiplier < 1.0 ? -20.0f * this.durationMultiplier + 21.0f : -8.0f * this.durationMultiplier + 9.0f;
        return BigDecimal.valueOf(result).setScale(2, RoundingMode.HALF_UP).floatValue();
    }

    protected void incInternalMultiplier(int multiplier) {
        float newDurationMultiplier = this.durationMultiplier + 0.01f * (float)multiplier;
        if (newDurationMultiplier >= MAX_DURATION_MULTIPLIER) {
            this.durationMultiplier = MAX_DURATION_MULTIPLIER;
            return;
        }
        this.durationMultiplier = newDurationMultiplier;
    }

    protected void decInternalMultiplier(int multiplier) {
        float newDurationMultiplier = this.durationMultiplier - 0.01f * (float)multiplier;
        if (newDurationMultiplier <= MIN_DURATION_MULTIPLIER) {
            this.durationMultiplier = MIN_DURATION_MULTIPLIER;
            return;
        }
        this.durationMultiplier = newDurationMultiplier;
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 150, 70);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 142, 62).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new ComponentPanelWidget(4, 5, list -> {
            list.add(ACMHatchPartMachine.getTextWidgetText(this::getDurationMultiplier));
            MutableComponent buttonText = Component.m_237115_((String)"gtceu.maintenance.configurable_duration.modify");
            buttonText.m_130946_(" ");
            buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"sub"));
            buttonText.m_130946_(" ");
            buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"add"));
            list.add(buttonText);
        }).setMaxWidthLimit(130).clickHandler((componentData, clickData) -> {
            if (!clickData.isRemote) {
                int multiplier;
                int n = clickData.isCtrlClick ? 100 : (multiplier = clickData.isShiftClick ? 10 : 1);
                if ("sub".equals(componentData)) {
                    this.decInternalMultiplier(multiplier);
                } else if ("add".equals(componentData)) {
                    this.incInternalMultiplier(multiplier);
                }
            }
        })));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    protected static Component getTextWidgetText(Supplier<Float> multiplier) {
        String format = String.format("%.2f", multiplier.get());
        MutableComponent tooltip = (double)multiplier.get().floatValue() == 1.0 ? Component.m_237115_((String)"gtceu.maintenance.configurable_duration.unchanged_description") : Component.m_237110_((String)"gtceu.maintenance.configurable_duration.changed_description", (Object[])new Object[]{format});
        return Component.m_237110_((String)"gtceu.maintenance.configurable_duration", (Object[])new Object[]{format}).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip)));
    }

    public static float getMAX_DURATION_MULTIPLIER() {
        return MAX_DURATION_MULTIPLIER;
    }

    public static float getMIN_DURATION_MULTIPLIER() {
        return MIN_DURATION_MULTIPLIER;
    }

    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }
}

