/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.SingleCustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.gtocore.common.machine.multiblock.part.ae.MEPartMachine;
import com.gtocore.data.CraftingComponents;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.IGTOMufflerMachine;
import com.gtolib.api.machine.trait.InaccessibleInfiniteHandler;
import com.gtolib.api.misc.AsyncTask;
import com.gtolib.api.misc.IAsyncTaskHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@Scanned
public class MEMufflerHatchPartMachine
extends MEPartMachine
implements IGTOMufflerMachine,
IAsyncTaskHolder {
    @Persisted
    private final KeyStorage internalBuffer = new KeyStorage();
    @Persisted
    private final NotifiableItemStackHandler mufflerHatchInv;
    @Persisted
    private final NotifiableItemStackHandler amplifierInv;
    private final InaccessibleInfiniteHandler handler = new InaccessibleInfiniteHandler((MetaMachine)this, this.internalBuffer);
    @DescSynced
    private int recoveryChance = 0;
    private AsyncTask asyncTask;
    private int muffler_tier = 0;
    @DynamicInitialValue(typeKey="amount", key="me_muffler_hatch.amplifier_max_amount", easyValue="4", normalValue="16", expertValue="64", cn="\u96c6\u63a7\u6838\u5fc3\u6700\u5927\u6570\u91cf", cnComment="\u589e\u5e45\u5230\u6700\u5927\u503c\u6240\u9700\u7684\u96c6\u63a7\u6838\u5fc3\u6570\u91cf\u4e3a%s\u3002", en="")
    private static int COUNT = 16;
    @DynamicInitialValue(typeKey="amount", key="me_muffler_hatch.amplifier_min_amount", easyValue="1", normalValue="4", expertValue="16", cn="\u96c6\u63a7\u6838\u5fc3\u6700\u5c0f\u6570\u91cf", cnComment="\u542f\u7528\u589e\u5e45\u6240\u9700\u7684\u96c6\u63a7\u6838\u5fc3\u6570\u91cf\u4e3a%s\u3002", en="")
    private static int MIN_COUNT = 4;
    @RegisterLanguage(cn="\u653e\u5165\u6d88\u58f0\u4ed3", en="Insert a Muffler Hatch")
    private static final String MUFFLER_TOOLTIP_KEY = "gtocore.machine.me_muffler_part.muffler_tooltip";
    @RegisterLanguage(cn="\u653e\u5165\u76f8\u540c\u7b49\u7ea7\u7684\u6d88\u58f0\u4ed3\u4ee5\u542f\u7528", en="Insert a Muffler Hatch of the same level to enable")
    private static final String MUFFLER_TOOLTIP_KEY_EXPERT = "gtocore.machine.me_muffler_part.muffler_tooltip_expert";
    @RegisterLanguage(cn="\u653e\u5165\u76f8\u540c\u7b49\u7ea7\u7684\u96c6\u63a7\u6838\u5fc3\u4ee5\u589e\u5e45\u6982\u7387", en="Insert a Control Core of the same level to increase the probability")
    private static final String AMPLIFIER_TOOLTIP_KEY = "gtocore.machine.me_muffler_part.apm_tooltip";

    public MEMufflerHatchPartMachine(@NotNull MetaMachineBlockEntity holder) {
        super(holder, IO.NONE);
        this.mufflerHatchInv = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, SingleCustomItemStackHandler::new);
        this.mufflerHatchInv.setFilter(stack -> Wrapper.MUFFLER_HATCH.containsKey(stack.m_41720_()));
        this.mufflerHatchInv.addChangedListener(this::onMufflerChange);
        this.amplifierInv = new NotifiableItemStackHandler(this, (MetaMachine)this, 1, IO.NONE, IO.BOTH){

            public int getSlotLimit(int slot) {
                return COUNT;
            }
        };
        this.amplifierInv.setFilter(stack -> Wrapper.AMPLIFIER_TIER_MAP.containsKey(stack.m_41720_()));
        this.amplifierInv.addChangedListener(this::onMufflerChange);
    }

    private void onMufflerChange() {
        ItemStack amplifierIs = this.amplifierInv.getStackInSlot(0);
        Item item = this.mufflerHatchInv.getStackInSlot(0).m_41720_();
        this.recoveryChance = 0;
        this.muffler_tier = this.tier;
        if (Wrapper.MUFFLER_HATCH.containsKey(item)) {
            this.muffler_tier = Wrapper.MUFFLER_HATCH.get(item);
        }
        if (Objects.equals(Wrapper.AMPLIFIER_TIER_MAP.get(amplifierIs.m_41720_()), Wrapper.MUFFLER_HATCH.get(item))) {
            int recoveryChanceMin = this.muffler_tier * 10;
            int recoveryChanceMax = recoveryChanceMin * this.muffler_tier;
            this.recoveryChance = (recoveryChanceMax - recoveryChanceMin) * (amplifierIs.m_41613_() - MIN_COUNT) / (COUNT - MIN_COUNT);
            this.recoveryChance += recoveryChanceMin;
            this.recoveryChance = Math.max(this.recoveryChance, recoveryChanceMin);
        } else {
            this.recoveryChance = this.muffler_tier * 10;
        }
    }

    @NotNull
    public RecipeHandlerList getHandlerList() {
        return RecipeHandlerList.NO_DATA;
    }

    public AsyncTask getAsyncTask() {
        return this.asyncTask;
    }

    public void setAsyncTask(AsyncTask task) {
        this.asyncTask = task;
    }

    public void gtolib$insertAsh(MultiblockControllerMachine controller, GTRecipe lastRecipe) {
        AsyncTask.addAsyncTask((IAsyncTaskHolder)this, () -> super.gtolib$insertAsh(controller, lastRecipe));
    }

    public void addedToController(@NotNull IMultiController controller) {
        super.addedToController(controller);
        this.onMufflerChange();
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.handler.updateAutoOutputSubscription();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.handler.updateAutoOutputSubscription();
    }

    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && !this.internalBuffer.isEmpty()) {
            for (Reference2LongMap.Entry entry : this.internalBuffer) {
                grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.getActionSourceField());
            }
        }
        this.clearInventory((IItemHandlerModifiable)this.mufflerHatchInv);
        this.clearInventory((IItemHandlerModifiable)this.amplifierInv);
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.superAttachConfigurators(configuratorPanel);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 110);
        WidgetGroup muffler = new WidgetGroup(0, 0, 170, 25);
        muffler.addWidget(new SlotWidget((IItemHandlerModifiable)this.mufflerHatchInv.storage, 0, 140, 10, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237115_((String)(GTOCore.isExpert() ? MUFFLER_TOOLTIP_KEY_EXPERT : MUFFLER_TOOLTIP_KEY))}));
        muffler.addWidget(new SlotWidget((IItemHandlerModifiable)this.amplifierInv.storage, 0, 120, 10, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237115_((String)AMPLIFIER_TOOLTIP_KEY)}));
        muffler.addWidget((Widget)new ComponentPanelWidget(6, 15, list -> list.add(Component.m_237110_((String)"gtceu.muffler.recovery_tooltip", (Object[])new Object[]{this.recoveryChance}))));
        group.addWidget((Widget)muffler);
        WidgetGroup meOutput = new WidgetGroup(0, 35, 170, 65);
        meOutput.addWidget((Widget)new LabelWidget(5, 0, () -> this.getOnlineField() ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        meOutput.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        meOutput.addWidget((Widget)new AEListGridWidget.Item(5, 20, 3, this.internalBuffer));
        group.addWidget((Widget)meOutput);
        return group;
    }

    public void recoverItemsTable(ItemStack recoveryItems) {
        if (!this.workingEnabled) {
            return;
        }
        this.handler.insertInternal(recoveryItems, (long)recoveryItems.m_41613_());
    }

    public boolean isFrontFaceFree() {
        return this.recoveryChance != 0;
    }

    public int gtolib$getRecoveryChance() {
        return this.recoveryChance;
    }

    public int getTier() {
        return Math.max(this.tier, this.muffler_tier);
    }

    static class Wrapper {
        public static final Map<Item, Integer> MUFFLER_HATCH;
        public static final Map<Item, Integer> AMPLIFIER_TIER_MAP;

        Wrapper() {
        }

        static {
            HashMap<MetaMachineItem, Integer> mufflerMap = new HashMap<MetaMachineItem, Integer>();
            for (MachineDefinition i : GTMachines.MUFFLER_HATCH) {
                if (i == null || i.getTier() < 6 && !GTOCore.isExpert()) continue;
                mufflerMap.put(i.asItem(), i.getTier());
            }
            MUFFLER_HATCH = Map.copyOf(mufflerMap);
            HashMap<Item, Integer> amplifierTierMap = new HashMap<Item, Integer>();
            for (int i = 8; i <= 13; ++i) {
                amplifierTierMap.put((Item)CraftingComponents.INTEGRATED_CONTROL_CORE.get(i), i);
            }
            AMPLIFIER_TIER_MAP = Map.copyOf(amplifierTierMap);
        }
    }
}

