/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridEvent;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gtocore.common.machine.multiblock.part.ae.MEPartMachine;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import org.jetbrains.annotations.NotNull;

public class MEEnergyAccessPartMachine
extends MEPartMachine
implements IAEPowerStorage {
    private double ratio;
    private TierCasingMultiblockMachine controller;

    public MEEnergyAccessPartMachine(MetaMachineBlockEntity holder) {
        super(holder, IO.NONE);
        this.ratio = ConfigHolder.INSTANCE.compat.energy.euToFeRatio;
        this.controller = null;
        this.getMainNode().addService(IAEPowerStorage.class, (IGridNodeService)this);
    }

    @Override
    public void setOnline(boolean isOnline) {
        super.setOnline(isOnline);
        this.postEnergyEvent();
    }

    private double EU2AE(long eu) {
        return PowerUnits.FE.convertTo(PowerUnits.AE, (double)eu) * this.ratio;
    }

    private long AE2EU(double ae) {
        return MathUtil.saturatedCast((double)(PowerUnits.AE.convertTo(PowerUnits.FE, ae) / this.ratio));
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        if (workingEnabled) {
            this.postEnergyEvent();
        }
    }

    private void postEnergyEvent() {
        if (this.controller == null) {
            return;
        }
        this.ratio = ConfigHolder.INSTANCE.compat.energy.euToFeRatio;
        this.ratio *= 1.0 + 0.3 * (double)this.controller.getCasingTier("g_b");
        this.ratio *= (double)(this.controller.getSubFormedAmount() + 1);
        if (this.getMainNode().getGrid() != null) {
            this.getMainNode().getGrid().postEvent((GridEvent)new GridPowerStorageStateChanged((IAEPowerStorage)this, GridPowerStorageStateChanged.PowerEventType.PROVIDE_POWER));
        }
    }

    public void removedFromController(@NotNull IMultiController controller) {
        super.removedFromController(controller);
        this.controller = null;
    }

    public void addedToController(@NotNull IMultiController controller) {
        super.addedToController(controller);
        this.controller = (TierCasingMultiblockMachine)controller;
        this.postEnergyEvent();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.postEnergyEvent();
    }

    public double injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public double getAEMaxPower() {
        return 9.223372036854776E18;
    }

    public double getAECurrentPower() {
        if (this.controller == null) {
            return 0.0;
        }
        if (!this.workingEnabled) {
            return 0.0;
        }
        return this.EU2AE(this.controller.getEnergyContainer().getEnergyStored());
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        if (this.controller == null) {
            return 0.0;
        }
        if (!this.workingEnabled) {
            return 0.0;
        }
        double can_extract = Math.min(this.getAECurrentPower(), amt);
        if (!mode.isSimulate()) {
            this.controller.getEnergyContainer().changeEnergy(-this.AE2EU(can_extract));
        }
        return can_extract;
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 65);
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.getOnlineField() ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        return group;
    }
}

