/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import com.gregtechceu.gtceu.api.cover.filter.TagFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.common.machine.multiblock.part.ae.METagFilterStockBusPartMachine;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

interface ITagFilterPartMachine
extends IDropSaveMachine {
    public String getTagWhite();

    public String getTagBlack();

    public void setTagWhite(String var1);

    public void setTagBlack(String var1);

    default public void saveToItem(CompoundTag tag) {
        super.saveToItem(tag);
        tag.m_128359_("TagWhite", this.getTagWhite());
        tag.m_128359_("TagBlack", this.getTagBlack());
    }

    default public void loadFromItem(CompoundTag tag) {
        super.loadFromItem(tag);
        if (tag.m_128441_("TagWhite")) {
            this.setTagWhite(tag.m_128461_("TagWhite"));
        }
        if (tag.m_128441_("TagBlack")) {
            this.setTagBlack(tag.m_128461_("TagBlack"));
        }
    }

    public static class TextField
    extends TextFieldWidget {
        public TextField(int x, int y, int width, int height, Supplier<String> textSupplier, Consumer<String> textConsumer) {
            super(x, y, width, height, textSupplier, textConsumer);
        }

        public void setDirectly(String newTextString) {
            this.setCurrentString(newTextString);
            this.writeClientAction(1, buf -> buf.m_130070_(newTextString));
        }
    }

    public static class FilterIFancyConfigurator
    implements IFancyConfigurator {
        private final ITagFilterPartMachine machine;
        private TagFilter.StackHandlerWidget<?, ?> handlerWidget;

        FilterIFancyConfigurator(ITagFilterPartMachine machine) {
            this.machine = machine;
        }

        public Component getTitle() {
            return Component.m_237115_((String)"gtocore.machine.tag_filter.tag_config_title");
        }

        public IGuiTexture getIcon() {
            return GuiTextures.BUTTON_BLACKLIST.getSubTexture(0.0f, 0.0f, 20.0f, 20.0f);
        }

        public Widget createConfigurator() {
            boolean isItem = this.machine instanceof METagFilterStockBusPartMachine;
            TextField t1 = new TextField(9, 16, 114, 16, this.machine::getTagWhite, this.machine::setTagWhite);
            TagItemFilter.PhantomSlot h1 = isItem ? new TagItemFilter.PhantomSlot(new CustomItemStackHandler(1)) : new TagFluidFilter.TankSlot(new CustomFluidTank(1));
            TextField t2 = new TextField(9, 48, 114, 16, this.machine::getTagBlack, this.machine::setTagBlack);
            TagItemFilter.PhantomSlot h2 = isItem ? new TagItemFilter.PhantomSlot(new CustomItemStackHandler(1)) : new TagFluidFilter.TankSlot(new CustomFluidTank(1));
            WidgetGroup wc = new WidgetGroup(-25, 0, 150, 100).addWidget((Widget)new LabelWidget(9, 4, () -> "gui.whitelist")).addWidget((Widget)t1).addWidget((Widget)h1).addWidget((Widget)new LabelWidget(9, 36, () -> "gui.blacklist")).addWidget((Widget)t2).addWidget((Widget)h2).addWidget((Widget)new LabelWidget(0, 68, () -> "gtocore.machine.tag_filter.tooltip.0")).addWidget((Widget)new LabelWidget(0, 84, () -> "gtocore.machine.tag_filter.tooltip.1"));
            DraggableScrollableWidgetGroup container = new DraggableScrollableWidgetGroup(0, 100, 140, 100);
            container.setClientSideWidget().setActive(false).setVisible(false).setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            BiFunction<TagFilter.StackHandlerWidget, TextField, Runnable> callbackFactory = (hw, tf) -> () -> {
                List<String> tags = hw.getTags().map(tag -> tag.f_203868_().toString()).toList();
                Widget[] newWidgets = this.createTagLabelContainer((TextField)((Object)tf), tags);
                container.clearAllWidgets();
                container.addWidgets(newWidgets);
                if (!hw.isEmpty()) {
                    container.setVisible(true).setActive(true);
                } else {
                    container.setVisible(false).setActive(false);
                }
            };
            h1.setOnContentsChanged(callbackFactory.apply((TagFilter.StackHandlerWidget)h1, t1));
            ((Widget)h1).setSelfPosition(t1.getSelfPositionX() + t1.getSizeWidth() + 4, t1.getSelfPositionY());
            h2.setOnContentsChanged(callbackFactory.apply((TagFilter.StackHandlerWidget)h2, t2));
            ((Widget)h2).setSelfPosition(t2.getSelfPositionX() + t2.getSizeWidth() + 4, t2.getSelfPositionY());
            return wc.addWidget((Widget)container);
        }

        protected Widget[] createTagLabelContainer(final TextField textFieldWidget, List<String> tags) {
            AtomicInteger atomicI = new AtomicInteger(0);
            Widget[] container = new Widget[tags.size()];
            for (final String tag : tags) {
                container[atomicI.get()] = new LabelWidget(this, 4, atomicI.getAndIncrement() * 12 + 4, tag){

                    public boolean mouseReleased(double mouseX, double mouseY, int button2) {
                        if (this.isMouseOverElement(mouseX, mouseY)) {
                            if (button2 == 0) {
                                textFieldWidget.setDirectly(tag);
                            } else if (button2 == 1) {
                                Minecraft.m_91087_().f_91068_.m_90911_(tag);
                            }
                            1.playButtonClickSound();
                            return true;
                        }
                        return super.mouseReleased(mouseX, mouseY, button2);
                    }
                }.setTextColor(3786171).setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.part.extendae.tag_filter.tooltip")}).setClientSideWidget();
            }
            return container;
        }
    }
}

