/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.BlockableSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.common.item.DataCrystalItem;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ScanningHolderMachine
extends MultiblockPartMachine
implements IMachineLife {
    public static final int CATALYST_SLOT = 0;
    public static final int DATA_SLOT = 1;
    public static final int SCAN_SLOT = 2;
    public static final int FLUID_TANK_CAPACITY = 64000;
    @Persisted
    private final ScanningHolder heldItems = new ScanningHolder(this);
    @Persisted
    @DescSynced
    private boolean isLocked;
    @Persisted
    private final NotifiableFluidTank catalystFluidTank = new NotifiableFluidTank((MetaMachine)this, 1, 64000, IO.IN, IO.BOTH);

    public ScanningHolderMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @NotNull
    public ItemStack getHeldItem(boolean remove) {
        return this.getHeldItem(2, remove);
    }

    public void setHeldItem(@NotNull ItemStack heldItem) {
        this.heldItems.setStackInSlot(2, heldItem);
    }

    @NotNull
    public ItemStack getDataItem(boolean remove) {
        return this.getHeldItem(1, remove);
    }

    public void setDataItem(@NotNull ItemStack dataItem) {
        this.heldItems.setStackInSlot(1, dataItem);
    }

    @NotNull
    public ItemStack getCatalystItem(boolean remove) {
        return this.getHeldItem(0, remove);
    }

    public void setCatalystItem(@NotNull ItemStack catalystItem) {
        this.heldItems.setStackInSlot(0, catalystItem);
    }

    @NotNull
    public NotifiableItemStackHandler getAsHandler() {
        return this.heldItems;
    }

    @NotNull
    private ItemStack getHeldItem(int slot, boolean remove) {
        ItemStack stackInSlot = this.heldItems.getStackInSlot(slot);
        if (remove && !stackInSlot.m_41619_()) {
            this.heldItems.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return stackInSlot;
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.heldItems.storage);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new ImageWidget(46, 15, 84, 60, (IGuiTexture)GuiTextures.PROGRESS_BAR_RESEARCH_STATION_BASE)).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 2, 79, 36).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.RESEARCH_STATION_OVERLAY})).addWidget((Widget)new ScanningWidget(this.catalystFluidTank, 79, 36, 18, 18, true, true).setBackground((IGuiTexture)GuiTextures.BLANK_TRANSPARENT).setDrawHoverOverlay(false)).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 0, 15, 15).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.MOLECULAR_OVERLAY_1})).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 1, 15, 57).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GTOGuiTextures.DATA_CRYSTAL_OVERLAY}));
        return group;
    }

    public void setFrontFacing(Direction frontFacing) {
        super.setFrontFacing(frontFacing);
        Set controllers = this.getControllers();
        for (IMultiController controller : controllers) {
            if (controller == null || !controller.isFormed()) continue;
            controller.checkPatternWithLock();
        }
    }

    @Generated
    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }

    @Generated
    public NotifiableFluidTank getCatalystFluidTank() {
        return this.catalystFluidTank;
    }

    private static final class ScanningHolder
    extends NotifiableItemStackHandler {
        private final ScanningHolderMachine machine;

        private ScanningHolder(ScanningHolderMachine machine) {
            super((MetaMachine)machine, 3, IO.IN, IO.BOTH, ScanningHolderStackHandler::new);
            this.machine = machine;
        }

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 2 -> 64;
                case 0, 1 -> 1;
                default -> super.getSlotLimit(slot);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.machine.isLocked()) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.m_41619_()) {
                return true;
            }
            boolean isDataItem = stack.m_41720_() instanceof DataCrystalItem;
            return switch (slot) {
                case 2 -> {
                    if (!isDataItem && !this.hasFluidInContainer(stack) && this.machine.getCatalystFluidTank().isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> {
                    if (!isDataItem) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> isDataItem;
                default -> super.isItemValid(slot, stack);
            };
        }

        private boolean hasFluidInContainer(ItemStack stack) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> !fluidStack.isEmpty()).orElse(false);
        }

        private static final class ScanningHolderStackHandler
        extends CustomItemStackHandler {
            private ScanningHolderStackHandler(int size) {
                super(size);
            }

            public int getSlotLimit(int slot) {
                return switch (slot) {
                    case 2 -> 64;
                    case 0, 1 -> 1;
                    default -> super.getSlotLimit(slot);
                };
            }
        }
    }

    private static final class ScanningWidget
    extends TankWidget {
        ScanningWidget(NotifiableFluidTank fluidTank, int x, int y, int width, int height, boolean allowFill, boolean allowDrain) {
            super((IFluidHandler)fluidTank, x, y, width, height, allowFill, allowDrain);
        }

        public List<Component> getFullTooltipTexts() {
            FluidStack fluid = this.getFluid();
            if (fluid.isEmpty()) {
                return Collections.emptyList();
            }
            return super.getFullTooltipTexts();
        }

        public void drawInBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            this.drawHoverOverlay = !this.getFluid().isEmpty();
        }
    }
}

