/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.CircuitHandler;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DualHatchPartMachine;
import com.gtocore.api.gui.configurators.MultiMachineModeFancyConfigurator;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.machine.trait.ExtendedRecipeHandlerList;
import com.hepdd.gtmthings.api.machine.IProgrammableMachine;
import com.hepdd.gtmthings.common.item.VirtualItemProviderBehavior;
import com.hepdd.gtmthings.data.CustomItems;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public class ProgrammableHatchPartMachine
extends DualHatchPartMachine
implements IProgrammableMachine {
    @Persisted
    @DescSynced
    private final ArrayList<GTRecipeType> recipeTypes = new ArrayList();
    @Persisted
    @DescSynced
    private GTRecipeType recipeType = GTORecipeTypes.HATCH_COMBINED;

    public ProgrammableHatchPartMachine(MetaMachineBlockEntity holder, int tier, IO io, Object ... args) {
        super(holder, tier, io, args);
    }

    private void changeMode(GTRecipeType type) {
        this.recipeType = type == null ? GTORecipeTypes.HATCH_COMBINED : type;
    }

    @NotNull
    protected NotifiableItemStackHandler createInventory(Object ... args) {
        return new NotifiableItemStackHandler((MetaMachine)this, this.getInventorySize(), this.io).setFilter(itemStack -> !itemStack.m_41782_() || !itemStack.m_150930_((Item)CustomItems.VIRTUAL_ITEM_PROVIDER.get()));
    }

    @NotNull
    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new ProgrammableCircuitHandler((MetaMachine)this);
        }
        return NotifiableItemStackHandler.empty((MetaMachine)this);
    }

    @NotNull
    public RecipeHandlerList getHandlerList() {
        if (this.recipeHandlerList == null) {
            ArrayList<IRecipeHandlerTrait> handlers = new ArrayList<IRecipeHandlerTrait>();
            for (MachineTrait trait : this.traits) {
                IRecipeHandlerTrait rht;
                if (!(trait instanceof IRecipeHandlerTrait) || !(rht = (IRecipeHandlerTrait)trait).isAvailable() || rht.getHandlerIO() != IO.IN) continue;
                handlers.add(rht);
            }
            this.recipeHandlerList = new ProgrammableRHL(IO.IN, this);
            this.recipeHandlerList.addHandlers(handlers);
        }
        return this.recipeHandlerList;
    }

    public void onLoad() {
        super.onLoad();
        if (this.recipeType == GTORecipeTypes.DUMMY_RECIPES) {
            this.recipeType = GTORecipeTypes.HATCH_COMBINED;
        }
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        super.attachSideTabs(sideTabs);
        sideTabs.attachSubTab((IFancyUIProvider)new MultiMachineModeFancyConfigurator(this.recipeTypes, this.recipeType, this::changeMode));
    }

    public void addedToController(@NotNull IMultiController controller) {
        super.addedToController(controller);
        this.recipeTypes.clear();
        this.recipeTypes.addAll(MultiMachineModeFancyConfigurator.extractRecipeTypes(this.getControllers()));
    }

    public void removedFromController(@NotNull IMultiController controller) {
        super.removedFromController(controller);
        this.recipeTypes.clear();
        this.recipeTypes.addAll(MultiMachineModeFancyConfigurator.extractRecipeTypes(this.getControllers()));
    }

    public boolean isProgrammable() {
        return true;
    }

    public void setProgrammable(boolean programmable) {
    }

    public static class ProgrammableCircuitHandler
    extends CircuitHandler {
        public ProgrammableCircuitHandler(MetaMachine machine) {
            super(machine, IO.IN, s -> new ProgrammableHandler(machine));
        }

        private static class ProgrammableHandler
        extends CircuitHandler.ItemStackHandler {
            private final IProgrammableMachine machine;

            private ProgrammableHandler(Object machine) {
                super(1);
                IProgrammableMachine programmableMachine;
                this.machine = machine instanceof IProgrammableMachine ? (programmableMachine = (IProgrammableMachine)machine) : null;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (this.machine.isProgrammable() && stack.m_150930_((Item)CustomItems.VIRTUAL_ITEM_PROVIDER.get())) {
                    this.setStackInSlot(slot, VirtualItemProviderBehavior.getVirtualItem((ItemStack)stack));
                    return ItemStack.f_41583_;
                }
                return stack;
            }
        }
    }

    private static class ProgrammableRHL
    extends ExtendedRecipeHandlerList {
        private final ProgrammableHatchPartMachine part;

        private ProgrammableRHL(IO handlerIO, ProgrammableHatchPartMachine part) {
            super(handlerIO, (IMultiPart)part);
            this.part = part;
        }

        public ExtendedRecipeHandlerList wrapper() {
            return new ProgrammableRHL(IO.IN, this.part);
        }

        public boolean findRecipe(IRecipeCapabilityHolder holder, GTRecipeType recipeType, Predicate<GTRecipe> canHandle) {
            IntLongMap map;
            IRecipeLogicMachine machine;
            GTRecipeType type = this.part.recipeType;
            if (type != GTORecipeTypes.HATCH_COMBINED && type != recipeType && holder instanceof IRecipeLogicMachine && !(machine = (IRecipeLogicMachine)holder).disabledCombined()) {
                if (GTRecipeType.available((GTRecipeType)type, (GTRecipeType[])machine.getRecipeTypes())) {
                    recipeType = type;
                } else {
                    return false;
                }
            }
            if ((map = this.getIngredientMap(recipeType)).isEmpty()) {
                return false;
            }
            holder.setCurrentHandlerList((RecipeHandlerList)this);
            return recipeType.db.find(map, canHandle);
        }
    }
}

