/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.BlockableSlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.common.item.DataCrystalItem;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class AnalyzeHolderMachine
extends MultiblockPartMachine
implements IMachineLife {
    public static final int CATALYST_SLOT = 0;
    public static final int EMPTY_SLOT = 1;
    public static final int DATA_SLOT = 2;
    protected final IO io = IO.IN;
    @Persisted
    private final AnalyzeHolder heldItems = new AnalyzeHolder(this);
    @Persisted
    @DescSynced
    private boolean isLocked;

    public AnalyzeHolderMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean isWorkingEnabled() {
        return false;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.heldItems.storage);
    }

    @NotNull
    public NotifiableItemStackHandler getAsHandler() {
        return this.heldItems;
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new ImageWidget(0, 15, 84, 60, (IGuiTexture)GuiTextures.PROGRESS_BAR_RESEARCH_STATION_BASE)).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 2, 33, 36, true, this.io.support(IO.IN)).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GTOGuiTextures.DATA_CRYSTAL_OVERLAY})).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 0, 99, 15, true, this.io.support(IO.IN)).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.MOLECULAR_OVERLAY_1})).addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.heldItems, 1, 99, 57, true, this.io.support(IO.IN)).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GTOGuiTextures.DATA_CRYSTAL_OVERLAY}));
        return group;
    }

    public void setFrontFacing(@NotNull Direction frontFacing) {
        super.setFrontFacing(frontFacing);
        Set controllers = this.getControllers();
        for (IMultiController controller : controllers) {
            if (controller == null || !controller.isFormed()) continue;
            controller.checkPatternWithLock();
        }
    }

    @Generated
    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }

    private static class AnalyzeHolder
    extends NotifiableItemStackHandler {
        private final AnalyzeHolderMachine machine;

        private AnalyzeHolder(AnalyzeHolderMachine machine) {
            super((MetaMachine)machine, 3, IO.IN, IO.BOTH, MyCustomItemStackHandler::new);
            this.machine = machine;
        }

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0, 2 -> 1;
                case 1 -> 64;
                default -> super.getSlotLimit(slot);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.machine.isLocked()) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.m_41619_()) {
                return true;
            }
            boolean isDataItem = false;
            boolean hasNBT = false;
            boolean emptyNBT = false;
            if (stack.m_41720_() instanceof DataCrystalItem) {
                isDataItem = true;
                hasNBT = stack.m_41782_();
                if (stack.m_41783_() != null && stack.m_41782_() && stack.m_41783_().m_128425_("empty_crystal", 10)) {
                    emptyNBT = true;
                }
            }
            return switch (slot) {
                case 2 -> {
                    if (hasNBT && !emptyNBT) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> emptyNBT;
                case 0 -> {
                    if (!isDataItem) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }

        private static final class MyCustomItemStackHandler
        extends CustomItemStackHandler {
            private MyCustomItemStackHandler(int size) {
                super(size);
            }

            public int getSlotLimit(int slot) {
                return switch (slot) {
                    case 0, 2 -> 1;
                    case 1 -> 64;
                    default -> super.getSlotLimit(slot);
                };
            }
        }
    }
}

