/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.part.WorkableAmountConfigurationPartMachine;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public final class AccelerateHatchPartMachine
extends WorkableAmountConfigurationPartMachine {
    @RegisterLanguage(cn="\u8017\u65f6\u767e\u5206\u6bd4", en="Percentage of duration")
    private static final String PERCENTAGE = "gtocore.machine.accelerate_hatch.percentage";

    public AccelerateHatchPartMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier, 52L - 2L * (long)tier, 100L);
    }

    public Widget createUIWidget() {
        return ((WidgetGroup)super.createUIWidget()).addWidget((Widget)new LabelWidget(24, -16, () -> PERCENTAGE));
    }

    public GTRecipe modifyRecipe(IWorkableMultiController controller, @NotNull GTRecipe recipe) {
        if (controller instanceof WorkableElectricMultiblockMachine) {
            WorkableElectricMultiblockMachine machine = (WorkableElectricMultiblockMachine)controller;
            int reduction = (int)this.getCurrent();
            int t = machine.getTier() - this.getTier();
            if (t > 0) {
                reduction = Math.min(100, reduction + 20 * t);
            }
            recipe.duration = Math.max(1, recipe.duration * reduction / 100);
        }
        return recipe;
    }

    protected long getCurrent() {
        if (this.current == -1L) {
            this.current = this.min;
        }
        return this.current;
    }
}

