/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class ThermalPowerPumpMachine
extends NoEnergyMultiblockMachine {
    private static final Fluid STEAM = GTMaterials.Steam.getFluid();
    private int biomeModifier;

    public ThermalPowerPumpMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    private Recipe getRecipe() {
        Recipe recipe;
        int production;
        if (this.biomeModifier == 0) {
            this.biomeModifier = GTUtil.getPumpBiomeModifier((Holder)Objects.requireNonNull(this.getLevel()).m_204166_(this.getPos()));
        } else if (this.biomeModifier > 0 && (production = (int)Math.min(this.getFluidAmount(new Fluid[]{STEAM})[0], (long)this.getFluidProduction())) > 0 && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)(recipe = this.getRecipeBuilder().duration(20).inputFluids(new FluidStack(STEAM, production)).outputFluids(new FluidStack((Fluid)Fluids.f_76193_, production)).buildRawRecipe()))) {
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    private boolean isRainingInBiome() {
        if (!Objects.requireNonNull(this.getLevel()).m_46471_()) {
            return false;
        }
        return ((Biome)Objects.requireNonNull(this.getLevel()).m_204166_(this.getPos()).m_203334_()).m_264600_(this.getPos()) != Biome.Precipitation.NONE;
    }

    private int getFluidProduction() {
        int value = this.biomeModifier << 8;
        if (this.isRainingInBiome()) {
            value = value * 3 / 2;
        }
        return value;
    }
}

