/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtolib.GTOCore;
import com.gtolib.api.gui.MagicProgressBarProWidget;
import com.gtolib.api.machine.feature.DummyEnergyMachine;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PrimitiveDistillationTowerMachine
extends NoEnergyMultiblockMachine
implements IExplosionMachine,
DummyEnergyMachine {
    private static final DummyEnergyMachine.DummyContainer CONTAINER = new DummyEnergyMachine.DummyContainer(120L);
    @NotNull
    private List<IFluidHandler> fluidOutputs = Collections.emptyList();
    private static final Item COAL_DUST = ChemicalHelper.getItem((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Coal);
    @Persisted
    @DescSynced
    @RequireRerender
    private int heat = 298;
    @DescSynced
    @RequireRerender
    private WaterState waterState = WaterState.NO_WATER;
    @DescSynced
    @RequireRerender
    private int waterLevel = 0;
    @Persisted
    private int tier;
    @Persisted
    private long time;
    private final ConditionalSubscriptionHandler tickSubs;
    private SensorPartMachine sensorMachine;
    private static final int HEAT_THRESHOLD = 373;
    private static final int MAX_WATER_USAGE = 9000;
    private static final int TIER_DECREASE = 1;
    private static final int TIER_INCREASE = 4;
    private static final int IDEAL_HEAT = 298;
    private static final int EXPLOSION = 850;
    private final MagicProgressBarProWidget progressBarPro = new MagicProgressBarProWidget(4, 113, 298, 930).addStartColor(-16711936).addMilestone(373, -16640, (Component)Component.m_237115_((String)"gtocore.bar.distillation.1")).addMilestone(850, -65536, (Component)Component.m_237115_((String)"gtocore.bar.exploration")).setLeftLabel((Component)Component.m_237115_((String)"gtocore.bar.heat"));

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 106).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, arg_0 -> ((PrimitiveDistillationTowerMachine)this).addDisplayText(arg_0)).textSupplier(Objects.requireNonNull(this.getLevel()).f_46443_ ? null : arg_0 -> ((PrimitiveDistillationTowerMachine)this).addDisplayText(arg_0)).setMaxWidthLimit(200).clickHandler((arg_0, arg_1) -> ((PrimitiveDistillationTowerMachine)this).handleDisplayClick(arg_0, arg_1))));
        group.addWidget((Widget)this.progressBarPro);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    public PrimitiveDistillationTowerMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::tickUpdate, 0, this::shouldTick);
    }

    private boolean shouldTick() {
        return this.isFormed || this.heat > 298 || this.time > 0L;
    }

    public void clientTick() {
        super.clientTick();
        if (this.getOffsetTimer() % 10 == 0) {
            this.scheduleRenderUpdate();
        }
    }

    private void tickUpdate() {
        long offsetTimer = this.getOffsetTimer();
        if (offsetTimer % 20L == 0L) {
            int water = (int)Math.min(9000L, this.getFluidAmount(new Fluid[]{Fluids.f_76193_})[0]);
            this.updateWaterState(water);
            this.handleHeatAndWater(water);
        }
        if (this.time > 0L) {
            this.activateMachine();
            --this.time;
        } else {
            this.deactivateMachine();
            this.checkAndRefuel(offsetTimer);
            this.adjustHeat(offsetTimer);
        }
        this.postTickActions(offsetTimer);
        this.tickSubs.updateSubscription();
    }

    private void activateMachine() {
        this.activated = true;
    }

    private void handleHeatAndWater(int water) {
        if (this.time > 0L) {
            if (this.heat > 373) {
                this.handleCooling(water > 0);
                this.adjustHeatWithWater(water);
            }
            this.heat += this.tier;
            if (this.getRecipeLogic().isWorking()) {
                --this.heat;
            }
        }
    }

    private void updateWaterState(int water) {
        this.waterState = water > 0 ? (water < 100 ? WaterState.HAS_LITTLE_WATER : WaterState.HAS_ENOUGH_WATER) : WaterState.NO_WATER;
        this.waterLevel = water;
    }

    private void handleCooling(boolean isCooling) {
        this.waterState = isCooling ? WaterState.IS_COOLING : this.waterState;
    }

    private void adjustHeatWithWater(int water) {
        if (water > 0) {
            if (water > 100) {
                this.heat -= water / 100;
            } else {
                this.heat += water / 20;
                this.time -= (long)water;
            }
            this.playCoolingSound();
            this.inputFluid((Fluid)Fluids.f_76193_, water);
        }
    }

    private void playCoolingSound() {
        if (this.shouldWorkingPlaySound() && this.getLevel() != null) {
            this.getLevel().m_5594_(null, this.getPos(), SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void deactivateMachine() {
        this.activated = false;
    }

    private void checkAndRefuel(long offsetTimer) {
        if (this.isWorkingEnabled() && offsetTimer % 10L == 0L) {
            if (this.inputItem((ItemLike)Items.f_42413_, 1L)) {
                this.tier = 4;
                this.time += 1200L;
            } else if (this.inputItem((ItemLike)Items.f_42200_, 1L)) {
                this.tier = 1;
                this.time += 21600L;
            } else if (this.inputItem((ItemLike)COAL_DUST, 1L)) {
                this.tier = 4;
                this.time += 500L;
            }
        }
    }

    private void adjustHeat(long offsetTimer) {
        if (this.heat > 298 && offsetTimer % 20L == 0L) {
            if (this.heat > 400) {
                this.getRecipeLogic().updateTickSubscription();
            }
            --this.heat;
        }
    }

    private void postTickActions(long offsetTimer) {
        if (offsetTimer % 20L == 0L) {
            if (this.heat > 850) {
                this.doExplosion(10.0f);
            }
            if (this.sensorMachine != null) {
                this.sensorMachine.update(this.heat);
            }
        }
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.heat > 400) {
            recipe.duration = (int)((double)recipe.duration * this.getDurationMultiplier());
            return recipe;
        }
        this.setIdleReason(IdleReason.INSUFFICIENT_TEMPERATURE);
        return null;
    }

    private double getDurationMultiplier() {
        return this.heat > 400 ? 800.0 / (double)((long)this.heat * Math.min(2L, Math.max(1L, this.getRecipeLogic().getTotalContinuousRunningTime() / 1000L))) : 1.0;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.rest_burn_time", (Object[])new Object[]{this.time}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.current_temperature", (Object[])new Object[]{this.heat}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.total_time", (Object[])new Object[]{this.getRecipeLogic().getTotalContinuousRunningTime()}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers((double)this.getDurationMultiplier())}));
        this.progressBarPro.setProgressSupplier(() -> this.heat);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.sensorMachine == null && part instanceof SensorPartMachine) {
            SensorPartMachine sensorPartMachine;
            this.sensorMachine = sensorPartMachine = (SensorPartMachine)part;
        }
    }

    public Comparator<IMultiPart> getPartSorter() {
        return Comparator.comparingInt(p -> p.self().getPos().m_123342_());
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        int startY = this.getPos().m_123342_() + 1;
        List<IWorkableMultiPart> parts = Arrays.stream(this.getParts()).filter(IWorkableMultiPart.class::isInstance).map(IWorkableMultiPart.class::cast).filter(part -> PartAbility.EXPORT_FLUIDS.isApplicable(part.self().getBlockState().m_60734_())).filter(part -> part.self().getPos().m_123342_() >= startY).toList();
        if (!parts.isEmpty()) {
            int maxY = parts.get(parts.size() - 1).self().getPos().m_123342_();
            this.fluidOutputs = new ArrayList<IFluidHandler>(maxY - startY);
            int outputIndex = 0;
            for (int y = startY; y <= maxY; ++y) {
                if (parts.size() <= outputIndex) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                IWorkableMultiPart part2 = parts.get(outputIndex);
                if (part2.self().getPos().m_123342_() == y) {
                    IFluidHandler handler = ((RecipeHandlerList)part2.getRecipeHandlers().get(0)).getCapability((RecipeCapability)FluidRecipeCapability.CAP).stream().filter(IFluidHandler.class::isInstance).findFirst().map(IFluidHandler.class::cast).orElse((IFluidHandler)VoidFluidHandler.INSTANCE);
                    this.addOutput(handler);
                    ++outputIndex;
                    continue;
                }
                if (part2.self().getPos().m_123342_() <= y) continue;
                this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
            }
        }
        this.tickSubs.initialize(this.getLevel());
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.sensorMachine = null;
        this.fluidOutputs = Collections.emptyList();
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new DistillationTowerLogic((IRecipeLogicMachine)this);
    }

    private void addOutput(IFluidHandler handler) {
        this.fluidOutputs.add(handler);
    }

    @NotNull
    public IEnergyContainer gtolib$getEnergyContainer() {
        return CONTAINER;
    }

    public boolean jade() {
        return false;
    }

    public static int getMaxHeat() {
        return 850;
    }

    public static int getMaxWaterUsage() {
        return 9000;
    }

    @NotNull
    private List<IFluidHandler> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Generated
    public int getHeat() {
        return this.heat;
    }

    @Generated
    public WaterState getWaterState() {
        return this.waterState;
    }

    @Generated
    public int getWaterLevel() {
        return this.waterLevel;
    }

    public static enum WaterState {
        NO_WATER(null),
        HAS_LITTLE_WATER("block/multiblock/primitive_distillation_tower/water"),
        HAS_ENOUGH_WATER("block/multiblock/primitive_distillation_tower/water"),
        IS_COOLING("block/multiblock/primitive_distillation_tower/steam");

        @Nullable
        public final ResourceLocation overlay;

        private WaterState(String overlay) {
            this.overlay = Optional.ofNullable(overlay).map(GTOCore::id).orElse(null);
        }
    }

    private static final class DistillationTowerLogic
    extends RecipeLogic {
        private static final ResourceLocation ID = RecipeBuilder.getTypeID((ResourceLocation)GTCEu.id((String)"distill_water_large"), (GTRecipeType)GTORecipeTypes.DISTILLATION_RECIPES);
        @Persisted
        @DescSynced
        @Nullable
        private GTRecipe workingRecipe = null;

        private DistillationTowerLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @NotNull
        public PrimitiveDistillationTowerMachine getMachine() {
            return (PrimitiveDistillationTowerMachine)super.getMachine();
        }

        @Nullable
        public GTRecipe getLastRecipe() {
            return this.workingRecipe;
        }

        protected boolean matchRecipe(GTRecipe recipe) {
            if (recipe.id.equals((Object)ID)) {
                return false;
            }
            if (RecipeHelper.getRecipeEUtTier((GTRecipe)recipe) > 2) {
                this.getMachine().setIdleReason(IdleReason.VOLTAGE_TIER_NOT_SATISFIES);
                return false;
            }
            return this.matchDTRecipe((Recipe)recipe);
        }

        public void findAndHandleRecipe() {
            this.workingRecipe = null;
            super.findAndHandleRecipe();
        }

        private boolean matchDTRecipe(Recipe recipe) {
            if (!RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this.machine, (Recipe)recipe)) {
                return false;
            }
            List items = recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
            if (!items.isEmpty() && !RecipeRunner.handleRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe, (IO)IO.OUT, Map.of(ItemRecipeCapability.CAP, items), Collections.emptyMap(), (boolean)true) || !this.applyFluidOutputs((GTRecipe)recipe, IFluidHandler.FluidAction.SIMULATE)) {
                this.getMachine().setIdleReason(IdleReason.OUTPUT_FULL);
                return false;
            }
            return true;
        }

        private void updateWorkingRecipe(GTRecipe recipe) {
            this.workingRecipe = recipe.copy();
            List contents = recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP);
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            ArrayList<Content> trimmed = new ArrayList<Content>(12);
            for (int i = 0; i < Math.min(contents.size(), outputs.size()); ++i) {
                if (outputs.get(i) instanceof VoidFluidHandler) continue;
                trimmed.add((Content)contents.get(i));
            }
            this.workingRecipe.outputs.put(FluidRecipeCapability.CAP, trimmed);
        }

        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                boolean handleIO = super.handleRecipeIO(recipe, io);
                if (handleIO) {
                    this.updateWorkingRecipe(recipe);
                } else {
                    this.workingRecipe = null;
                }
                return handleIO;
            }
            List items = recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
            if (!items.isEmpty()) {
                Map<ItemRecipeCapability, List> out = Map.of(ItemRecipeCapability.CAP, items);
                RecipeRunner.handleRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)((Recipe)recipe), (IO)io, out, (Map)this.chanceCaches, (boolean)false);
            }
            if (this.applyFluidOutputs(recipe, IFluidHandler.FluidAction.EXECUTE)) {
                this.workingRecipe = null;
                return true;
            }
            return false;
        }

        private boolean applyFluidOutputs(GTRecipe recipe, IFluidHandler.FluidAction action) {
            List<FluidIngredient> fluids = recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP).stream().map(Content::getContent).map(arg_0 -> ((FluidRecipeCapability)FluidRecipeCapability.CAP).of(arg_0)).toList();
            boolean valid = true;
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            for (int i = 0; i < Math.min(fluids.size(), outputs.size()); ++i) {
                int filled;
                IFluidHandler handler = outputs.get(i);
                FluidStack fluid = fluids.get(i).getStacks()[0];
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    v0 = nft.fillInternal(fluid, action);
                } else {
                    v0 = filled = handler.fill(fluid, action);
                }
                if (filled != fluid.getAmount()) {
                    valid = false;
                }
                if (action.simulate() && !valid) break;
            }
            return valid;
        }
    }
}

