/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gtocore.api.machine.part.GTOPartAbility;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.noenergy.NeutronActivatorMachine;
import com.gtolib.api.machine.feature.IElectricMachine;
import com.gtolib.api.machine.feature.multiblock.IMultiStructureMachine;
import com.gtolib.api.machine.trait.ElectricTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NeutronVortexMachine
extends NeutronActivatorMachine
implements IMultiStructureMachine,
IElectricMachine {
    private static final Int2ObjectOpenHashMap<BlockPattern> PATTERNS = new Int2ObjectOpenHashMap(3, 0.9f);
    @Persisted
    private boolean energy;
    private final ElectricTrait electricTrait = new ElectricTrait((IElectricMachine)this);

    public NeutronVortexMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (this.energy) {
            int ev = (recipe.data.m_128451_("ev_max") + recipe.data.m_128451_("ev_min")) * 5;
            this.eV = ev * 100000;
            recipe.duration /= 5;
            recipe.eut = ev;
            return RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe);
        }
        return super.getRealRecipe(recipe);
    }

    public void afterWorking() {
        this.eV = 0;
        super.afterWorking();
    }

    @Override
    protected void neutronEnergyUpdate() {
        if (this.energy) {
            return;
        }
        super.neutronEnergyUpdate();
    }

    @Override
    protected boolean working() {
        return true;
    }

    @Override
    protected double getEVtMultiplier() {
        return 1.0;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.height = 100;
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON.getSubTexture(0.0, 0.5, 1.0, 0.5), () -> this.energy, (clickData, pressed) -> {
            this.energy = pressed;
            this.updateCheck();
        }).setTooltipsSupplier(pressed -> List.of(Component.m_237115_((String)"block.ae2.energy_acceptor").m_130946_(" ").m_7220_((Component)(pressed != false ? Component.m_237115_((String)"gtceu.creative.activity.on") : Component.m_237115_((String)"gtceu.creative.activity.off")))))});
    }

    public static BlockPattern getBlockPattern(int tier, MultiblockMachineDefinition definition) {
        return (BlockPattern)PATTERNS.computeIfAbsent(tier, t -> {
            FactoryBlockPattern builder = FactoryBlockPattern.start((MultiblockMachineDefinition)definition, (RelativeDirection)RelativeDirection.BACK, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.LEFT).where(' ', Predicates.any());
            if (t == 1) {
                return builder.aisle(new String[]{"    JPPPPPJ     AAAAA    ", "    JPPPPPJ     AHHHA    ", "    J     J     AHHHA    ", "    J     J     AHHHA    ", "    J     J     AAAAA    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     AAAAA    ", "    J     J     AHHHA    ", "    J     J     AHHHA    ", "    JJJJJJJ     AHHHA    ", "    JJJJJJJ     AAAAA    "}).aisle(new String[]{"   JAAAAAAAJ   AAAAAAA   ", "   J       J   C HHH C   ", "               A HHH A   ", "         L     C HHH C   ", "        L      AAAAAAA   ", "       L                 ", "      L                  ", "     L                   ", "                         ", "                         ", "         K               ", "        K                ", "       K                 ", "      K                  ", "     K                   ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "         L               ", "        L                ", "       L                 ", "      L                  ", "     L                   ", "                         ", "                         ", "         K               ", "        K                ", "       K                 ", "      K        AAAAAAA   ", "     K         C HHH C   ", "               A HHH A   ", "   J       J   C HHH C   ", "   JAAAAAAAJ   AAAAAAA   "}).aisle(new String[]{"   JAMMMMMAJ   AAAAAAAA  ", "   J NNNNN J   CC    CC  ", "     NNNNNL    AA    AA  ", "     NNNNN     CC    CC  ", "     NNNNN     AAABABAA  ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "    LNNNNN               ", "     NNNNNK              ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "    KNNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNNL              ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "    LNNNNN               ", "     NNNNNK              ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN     AAABABAA  ", "     NNNNN     CC    CC  ", "    KNNNNN     AA    AA  ", "   J NNNNN J   CC    CC  ", "   JAMMMMMAJ   AAAAAAAA  "}).aisle(new String[]{"  JAAMMMMMAAJ   AAAAAAA  ", "  J  NONONL J   C     C  ", "     NONON      A     A  ", "     NONON      C     C  ", "     NONON      AAAAAAA  ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONONK              ", "    LNONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "    KNONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONONL              ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONONK              ", "    LNONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON      AAAAAAA  ", "     NONON      C     C  ", "     NONON      A     A  ", "  J KNONON  J   C     C  ", "  JAAMMMMMAAJ   AAAAAAA  "}).aisle(new String[]{"  JAMMMMMMMAJ   AAAAAAAA ", "  J NNNNNNN J   CC    CC ", "    NNNNNNN     AA    AA ", "    NNNNNNN     CC    CC ", "    NNNNNNN     AABABAAA ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNK             ", "    NNNNNNN              ", "    NNNNNNN              ", "   LNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "   KNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNL             ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNK             ", "    NNNNNNN              ", "    NNNNNNN              ", "   LNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN     AABABAAA ", "    NNNNNNN     CC    CC ", "    NNNNNNN     AA    AA ", "  J NNNNNNN J   CC    CC ", "  JAMMMMMMMAJ   AAAAAAAA "}).aisle(new String[]{" JAAMMMMMMMAAJ   AAAAAAA ", " J  NONONON  J   C     C ", "    NONONON      A     A ", "    NONONON      C     C ", "    NONONON      AAAAAAA ", "    NONONON              ", "    NONONONK             ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "   LNONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "   KNONONON              ", "    NONONON              ", "    NONONON              ", "    NONONONL             ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONONK             ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "   LNONONON              ", "    NONONON              ", "    NONONON      AAAAAAA ", "    NONONON      C     C ", "    NONONON      A     A ", " J  NONONON  J   C     C ", " JAAMMMMMMMAAJ   AAAAAAA "}).aisle(new String[]{" JAMMMMMMMMMAJ   AAAAAAAA", " J NNNNNNNNN J   CADDDDDA", "   NNNNNNNNN     AADDDDDA", "   NNNNNNNNN     CADDDDDA", "   NNNNNNNNN     AAAGGGAA", "   NNNNNNNNNK           A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "  LNNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "  KNNNNNNNNN            A", "   NNNNNNNNNL           A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNNK           A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "  LNNNNNNNNN            A", "   NNNNNNNNN     AAAGGGAA", "   NNNNNNNNN     CADDDDDA", "   NNNNNNNNN     AADDDDDA", " J NNNNNNNNN J   CADDDDDA", " JAMMMMMMMMMAJ   AAAAAAAA"}).aisle(new String[]{"JAAMMMMMMMMMAAJIIIAAAAAAA", "J  NONONONON  JIIIAEEEEEB", "J  NONONONON  JIIIADDDDDA", "J  NONONONON  J   AEEEEEB", "J  NONONONONK J   AAGGGAA", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J LNONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONONL J   A      ", "J KNONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONONK J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J LNONONONON  J   AAGGGAA", "J  NONONONON  J   AEEEEEB", "J  NONONONON  JIIIADDDDDA", "J  NONONONON  JIIIAEEEEEB", "JAAMMMMMMMMMAAJIIIAAAAAAA"}).aisle(new String[]{"PAMMMMMMMMMMMAJIIIAAAAAAA", "P NNNQQQQQNNN JFFFFFFFFFB", "  NNNQQQQQNNN  IIIADDDDDA", "  NNNQQQQQNNNK    ADDDDDB", "  NNNQQQQQNNN     AAGGGAA", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " LNNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNNL           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " KNNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNNK           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN     AAGGGAA", " LNNNQQQQQNNN     ADDDDDB", "  NNNQQQQQNNN  IIIADDDDDA", "J NNNQQQQQNNN JFFFFFFFFFB", "JAMMMMMMMMMMMAJIIIAAAAAAA"}).aisle(new String[]{"PAMMMMMMMMMMMAJIIIAAAAAAA", "P NONQRQRQNON JIIIAEEEEEA", "  NONQRQRQNONK IIIADDDDDA", "  NONQRQRQNON     AEEEEEA", "  NONQRQRQNON     AAGGGAA", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", " LNONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNONL           ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", " KNONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNONK           ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON     AAGGGAA", "  NONQRQRQNON     AEEEEEA", " LNONQRQRQNON  IIIADDDDDA", "J NONQRQRQNON JIIIAEEEEEA", "JAMMMMMMMMMMMAJIIIAAAAAAA"}).aisle(new String[]{"PAMMMMMMMMMMMAJIIIAAAAAAA", "SKNNNQQQQQNNNKJFFFFFFFFFA", "  NNNQQQQQNNN  IIIADDDDDA", "  NNNQQQQQNNN     ADDDDDA", "  NNNQQQQQNNN     AAGGGAA", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " LNNNQQQQQNNNL           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " KNNNQQQQQNNNK           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN     AAGGGAA", "  NNNQQQQQNNN     ADDDDDA", "  NNNQQQQQNNN  IIIADDDDDA", "JLNNNQQQQQNNNLJFFFFFFFFFA", "JAMMMMMMMMMMMAJIIIAAAAAAA"}).aisle(new String[]{"PAMMMMMMMMMMMAJIIIAAAAAAA", "P NONQRQRQNON JIIIAEEEEEA", " KNONQRQRQNON  IIIADDDDDA", "  NONQRQRQNON     AEEEEEA", "  NONQRQRQNON     AAGGGAA", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNONL           ", "  NONQRQRQNON            ", " LNONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNONK           ", "  NONQRQRQNON            ", " KNONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON            ", "  NONQRQRQNON     AAGGGAA", "  NONQRQRQNON     AEEEEEA", "  NONQRQRQNONL IIIADDDDDA", "J NONQRQRQNON JIIIAEEEEEA", "JAMMMMMMMMMMMAJIIIAAAAAAA"}).aisle(new String[]{"PAMMMMMMMMMMMAJIIIAAAAAAA", "P NNNQQQQQNNN JFFFFFFFFFB", "  NNNQQQQQNNN  IIIADDDDDA", " KNNNQQQQQNNN     ADDDDDB", "  NNNQQQQQNNN     AAGGGAA", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNNL           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " LNNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNNK           ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", " KNNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN            ", "  NNNQQQQQNNN     AAGGGAA", "  NNNQQQQQNNNL    ADDDDDB", "  NNNQQQQQNNN  IIIADDDDDA", "J NNNQQQQQNNN JFFFFFFFFFB", "JAMMMMMMMMMMMAJIIIAAAAAAA"}).aisle(new String[]{"JAAMMMMMMMMMAAJIIIAAAAAAA", "J  NONONONON  JIIIAEEEEEB", "J  NONONONON  JIIIADDDDDA", "J  NONONONON  J   AEEEEEB", "J KNONONONON  J   AAGGGAA", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONONL J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J LNONONONON  J   A      ", "J  NONONONONK J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J KNONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONON  J   A      ", "J  NONONONONL J   AAGGGAA", "J  NONONONON  J   AEEEEEB", "J  NONONONON  JIIIADDDDDA", "J  NONONONON  JIIIAEEEEEB", "JAAMMMMMMMMMAAJIIIAAAAAAA"}).aisle(new String[]{" JAMMMMMMMMMAJ   AAAAAAAA", " J NNNNNNNNN J   CADDDDDA", "   NNNNNNNNN     AADDDDDA", "   NNNNNNNNN     CADDDDDA", "   NNNNNNNNN     AAAGGGAA", "  KNNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNNL           A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNNK           A", "  LNNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "  KNNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNN            A", "   NNNNNNNNNL           A", "   NNNNNNNNN     AAAGGGAA", "   NNNNNNNNN     CADDDDDA", "   NNNNNNNNN     AADDDDDA", " J NNNNNNNNN J   CADDDDDA", " JAMMMMMMMMMAJ   AAAAAAAA"}).aisle(new String[]{" JAAMMMMMMMAAJ   AAAAAAA ", " J  NONONON  J   C     C ", "    NONONON      A     A ", "    NONONON      C     C ", "    NONONON      AAAAAAA ", "    NONONON              ", "   KNONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONONL             ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONONK             ", "    NONONON              ", "    NONONON              ", "   LNONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "   KNONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONON              ", "    NONONONL             ", "    NONONON              ", "    NONONON      AAAAAAA ", "    NONONON      C     C ", "    NONONON      A     A ", " J  NONONON  J   C     C ", " JAAMMMMMMMAAJ   AAAAAAA "}).aisle(new String[]{"  JAMMMMMMMAJ   AAAAAAAA ", "  J NNNNNNN J   CC    CC ", "    NNNNNNN     AA    AA ", "    NNNNNNN     CC    CC ", "    NNNNNNN     AABABAAA ", "    NNNNNNN              ", "    NNNNNNN              ", "   KNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNL             ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNK             ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "   LNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "   KNNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNNL             ", "    NNNNNNN              ", "    NNNNNNN              ", "    NNNNNNN     AABABAAA ", "    NNNNNNN     CC    CC ", "    NNNNNNN     AA    AA ", "  J NNNNNNN J   CC    CC ", "  JAMMMMMMMAJ   AAAAAAAA "}).aisle(new String[]{"  JAAMMMMMAAJ   AAAAAAA  ", "  J LNONON  J   C     C  ", "     NONON      A     A  ", "     NONON      C     C  ", "     NONON      AAAAAAA  ", "     NONON               ", "     NONON               ", "     NONON               ", "    KNONON               ", "     NONONL              ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONONK              ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "    LNONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON               ", "    KNONON               ", "     NONONL              ", "     NONON               ", "     NONON               ", "     NONON               ", "     NONON      AAAAAAA  ", "     NONON      C     C  ", "     NONON      A     A  ", "  J  NONONK J   C     C  ", "  JAAMMMMMAAJ   AAAAAAA  "}).aisle(new String[]{"   JAMMMMMAJ   AAAAAAAA  ", "   J NNNNN J   CC    CC  ", "    LNNNNN     AA    AA  ", "     NNNNN     CC    CC  ", "     NNNNN     AAABABAA  ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNNL              ", "    KNNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNNK              ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "    LNNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNNL              ", "    KNNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN               ", "     NNNNN     AAABABAA  ", "     NNNNN     CC    CC  ", "     NNNNNK    AA    AA  ", "   J NNNNN J   CC    CC  ", "   JAMMMMMAJ   AAAAAAAA  "}).aisle(new String[]{"   JAAAAAAAJ   AAAAAAA   ", "   J       J   C HHH C   ", "               A HHH A   ", "     L         C HHH C   ", "      L        AAAAAAA   ", "       L                 ", "        L                ", "         L               ", "                         ", "                         ", "     K                   ", "      K                  ", "       K                 ", "        K                ", "         K               ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "     L                   ", "      L                  ", "       L                 ", "        L                ", "         L               ", "                         ", "                         ", "     K                   ", "      K                  ", "       K                 ", "        K      AAAAAAA   ", "         K     C HHH C   ", "               A HHH A   ", "   J       J   C HHH C   ", "   JAAAAAAAJ   AAAAAAA   "}).aisle(new String[]{"    JPPPPPJ     AAAAA    ", "    JPPPPPJ     AHHHA    ", "    J     J     AHHHA    ", "    J     J     AHHHA    ", "    J     J     AAAAA    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     A   A    ", "    J     J     AAAAA    ", "    J     J     AHHHA    ", "    J     J     AHHHA    ", "    JJJJJJJ     AHHHA    ", "    JJJJJJJ     AAAAA    "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.DIMENSIONALLY_TRANSCENDENT_CASING.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.DIMENSIONAL_BRIDGE_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.CONTAINMENT_FIELD_GENERATOR.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPS_CASING.get()})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.RESTRAINT_DEVICE.get()})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ACCELERATED_PIPELINE.get()})).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.DEGENERATE_RHENIUM_CONSTRAINED_CASING.get()})).where('H', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HIGH_POWER_CASING.get()})).where('I', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TITANIUM_BOROSILICATE_GLASS.get()})).where('J', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_REINFORCED_PLANT_CASING.get()})).where('K', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTOMaterials.Quantanium)})).where('L', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTOMaterials.Vibranium)})).where('M', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STRONTIUM_CARBONATE_CERAMIC_RAY_ABSORBING_MECHANICAL_CUBE.get()})).where('N', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FUSION_GLASS.get()})).where('O', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPEEDING_PIPE.get()})).where('P', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_REINFORCED_PLANT_CASING.get()}).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes())).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTOMachines.NEUTRON_SENSOR.get()}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.NEUTRON_ACCELERATOR}).setMaxGlobalLimited(4)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('Q', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ENDERIUM_BOROSILICATE_GLASS.get()})).where('R', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.AMPROSIUM_ACTIVE_CASING.get()})).where('S', Predicates.controller((MachineDefinition)definition)).build();
            }
            return builder.aisle(new String[]{"    AHHHHHA    ", "    AHHHHHA    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    AAAAAAA    ", "    AAAAAAA    "}).aisle(new String[]{"   ABBBBBBBA   ", "   A       A   ", "               ", "         D     ", "        D      ", "       D       ", "      D        ", "     D         ", "               ", "               ", "         C     ", "        C      ", "       C       ", "      C        ", "     C         ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "         D     ", "        D      ", "       D       ", "      D        ", "     D         ", "               ", "               ", "         C     ", "        C      ", "       C       ", "      C        ", "     C         ", "               ", "   A       A   ", "   ABBBBBBBA   "}).aisle(new String[]{"   ABEEEEEBA   ", "   A FFFFF A   ", "     FFFFFD    ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "    DFFFFF     ", "     FFFFFC    ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "    CFFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFFD    ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "    DFFFFF     ", "     FFFFFC    ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "    CFFFFF     ", "   A FFFFF A   ", "   ABEEEEEBA   "}).aisle(new String[]{"  ABBEEEEEBBA  ", "  A  FGFGFD A  ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGFC    ", "    DFGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "    CFGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGFD    ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGFC    ", "    DFGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "  A CFGFGF  A  ", "  ABBEEEEEBBA  "}).aisle(new String[]{"  ABEEEEEEEBA  ", "  A FFFFFFF A  ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFC   ", "    FFFFFFF    ", "    FFFFFFF    ", "   DFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "   CFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFD   ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFC   ", "    FFFFFFF    ", "    FFFFFFF    ", "   DFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "  A FFFFFFF A  ", "  ABEEEEEEEBA  "}).aisle(new String[]{" ABBEEEEEEEBBA ", " A  FGFGFGF  A ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFC   ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "   DFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "   CFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFD   ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFC   ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "   DFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", " A  FGFGFGF  A ", " ABBEEEEEEEBBA "}).aisle(new String[]{" ABEEEEEEEEEBA ", " A FFFFFFFFF A ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFFC  ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "  DFFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "  CFFFFFFFFF   ", "   FFFFFFFFFD  ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFFC  ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "  DFFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", " A FFFFFFFFF A ", " ABEEEEEEEEEBA "}).aisle(new String[]{"ABBEEEEEEEEEBBA", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGFC A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A DFGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGFD A", "A CFGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGFC A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A DFGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "ABBEEEEEEEEEBBA"}).aisle(new String[]{"HBEEEEEEEEEEEBA", "H FFFIIIIIFFF A", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFC ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " DFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFD ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " CFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFC ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " DFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "A FFFIIIIIFFF A", "ABEEEEEEEEEEEBA"}).aisle(new String[]{"HBEEEEEEEEEEEBA", "H FGFIJIJIFGF A", "  FGFIJIJIFGFC ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", " DFGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGFD ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", " CFGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGFC ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", " DFGFIJIJIFGF  ", "A FGFIJIJIFGF A", "ABEEEEEEEEEEEBA"}).aisle(new String[]{"HBEEEEEEEEEEEBA", "KCFFFIIIIIFFFCA", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " DFFFIIIIIFFFD ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " CFFFIIIIIFFFC ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "ADFFFIIIIIFFFDA", "ABEEEEEEEEEEEBA"}).aisle(new String[]{"HBEEEEEEEEEEEBA", "H FGFIJIJIFGF A", " CFGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGFD ", "  FGFIJIJIFGF  ", " DFGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGFC ", "  FGFIJIJIFGF  ", " CFGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGF  ", "  FGFIJIJIFGFD ", "A FGFIJIJIFGF A", "ABEEEEEEEEEEEBA"}).aisle(new String[]{"HBEEEEEEEEEEEBA", "H FFFIIIIIFFF A", "  FFFIIIIIFFF  ", " CFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFD ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " DFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFC ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", " CFFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFF  ", "  FFFIIIIIFFFD ", "  FFFIIIIIFFF  ", "A FFFIIIIIFFF A", "ABEEEEEEEEEEEBA"}).aisle(new String[]{"ABBEEEEEEEEEBBA", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A CFGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGFD A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A DFGFGFGFGF  A", "A  FGFGFGFGFC A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A CFGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGFD A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "A  FGFGFGFGF  A", "ABBEEEEEEEEEBBA"}).aisle(new String[]{" ABEEEEEEEEEBA ", " A FFFFFFFFF A ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "  CFFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFFD  ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFFC  ", "  DFFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "  CFFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFFD  ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", "   FFFFFFFFF   ", " A FFFFFFFFF A ", " ABEEEEEEEEEBA "}).aisle(new String[]{" ABBEEEEEEEBBA ", " A  FGFGFGF  A ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "   CFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFD   ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFC   ", "    FGFGFGF    ", "    FGFGFGF    ", "   DFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "   CFGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGFD   ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", "    FGFGFGF    ", " A  FGFGFGF  A ", " ABBEEEEEEEBBA "}).aisle(new String[]{"  ABEEEEEEEBA  ", "  A FFFFFFF A  ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "   CFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFD   ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFC   ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "   DFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "   CFFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFFD   ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "    FFFFFFF    ", "  A FFFFFFF A  ", "  ABEEEEEEEBA  "}).aisle(new String[]{"  ABBEEEEEBBA  ", "  A DFGFGF  A  ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "    CFGFGF     ", "     FGFGFD    ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGFC    ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "    DFGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "    CFGFGF     ", "     FGFGFD    ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "     FGFGF     ", "  A  FGFGFC A  ", "  ABBEEEEEBBA  "}).aisle(new String[]{"   ABEEEEEBA   ", "   A FFFFF A   ", "    DFFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFFD    ", "    CFFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFFC    ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "    DFFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFFD    ", "    CFFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFF     ", "     FFFFFC    ", "   A FFFFF A   ", "   ABEEEEEBA   "}).aisle(new String[]{"   ABBBBBBBA   ", "   A       A   ", "               ", "     D         ", "      D        ", "       D       ", "        D      ", "         D     ", "               ", "               ", "     C         ", "      C        ", "       C       ", "        C      ", "         C     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "     D         ", "      D        ", "       D       ", "        D      ", "         D     ", "               ", "               ", "     C         ", "      C        ", "       C       ", "        C      ", "         C     ", "               ", "   A       A   ", "   ABBBBBBBA   "}).aisle(new String[]{"    AHHHHHA    ", "    AHHHHHA    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    A     A    ", "    AAAAAAA    ", "    AAAAAAA    "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_REINFORCED_PLANT_CASING.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.DIMENSIONALLY_TRANSCENDENT_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTOMaterials.Quantanium)})).where('D', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTOMaterials.Vibranium)})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STRONTIUM_CARBONATE_CERAMIC_RAY_ABSORBING_MECHANICAL_CUBE.get()})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FUSION_GLASS.get()})).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPEEDING_PIPE.get()})).where('H', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_REINFORCED_PLANT_CASING.get()}).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes())).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTOMachines.NEUTRON_SENSOR.get()}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.NEUTRON_ACCELERATOR}).setMaxGlobalLimited(4)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('I', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ENDERIUM_BOROSILICATE_GLASS.get()})).where('J', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.AMPROSIUM_ACTIVE_CASING.get()})).where('K', Predicates.controller((MachineDefinition)definition)).build();
        });
    }

    public BlockPattern getPattern() {
        return NeutronVortexMachine.getBlockPattern(this.energy ? 1 : 0, this.getDefinition());
    }

    public List<BlockPattern> getMultiPattern() {
        return List.of(NeutronVortexMachine.getBlockPattern(0, this.getDefinition()), NeutronVortexMachine.getBlockPattern(1, this.getDefinition()));
    }

    @NotNull
    public IEnergyContainer gtolib$getEnergyContainer() {
        return this.electricTrait.getEnergyContainer();
    }
}

