/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeatExchangerMachine
extends NoEnergyMultiblockMachine
implements IExplosionMachine {
    private static final Fluid Steam = GTMaterials.Steam.getFluid();
    private static final Fluid HighPressureSteam = GTOMaterials.HighPressureSteam.getFluid();
    private static final Fluid SupercriticalSteam = GTOMaterials.SupercriticalSteam.getFluid();
    private static final Fluid DistilledWater = GTMaterials.DistilledWater.getFluid();
    @Persisted
    private long hs;
    @Persisted
    private boolean water;

    public HeatExchangerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        this.water = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)((List)recipe.inputs.get(FluidRecipeCapability.CAP)).get(1)).getContent())).getStacks()[0].getFluid() == Fluids.f_76193_;
        Recipe result = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)this.getRecipeBuilder().inputFluids(new FluidIngredient[]{(FluidIngredient)FluidRecipeCapability.CAP.of(((Content)((List)recipe.inputs.get(FluidRecipeCapability.CAP)).get(0)).getContent())}).outputFluids(new FluidIngredient[]{(FluidIngredient)FluidRecipeCapability.CAP.of(((Content)((List)recipe.outputs.get(FluidRecipeCapability.CAP)).get(0)).getContent())}).duration(200).buildRawRecipe(), (long)Integer.MAX_VALUE);
        if (result == null) {
            return null;
        }
        this.hs = result.parallels * recipe.data.m_128454_("eu") / 2L;
        if (this.inputFluid((Fluid)(this.water ? Fluids.f_76193_ : DistilledWater), this.hs / 40L)) {
            return result;
        }
        this.doExplosion(Math.min(10L, this.hs / 10000L));
        return null;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        if (this.hs != 0L) {
            if (this.getRecipeLogic().getTotalContinuousRunningTime() > 800L) {
                if (this.water) {
                    this.outputFluid(HighPressureSteam, this.hs);
                } else {
                    this.outputFluid(SupercriticalSteam, this.hs >> 2);
                }
            } else if (this.water) {
                this.outputFluid(Steam, this.hs << 2);
            } else {
                this.outputFluid(HighPressureSteam, this.hs);
            }
        }
        this.hs = 0L;
    }
}

