/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTODamageTypes;
import com.gtolib.api.machine.multiblock.NoEnergyCustomParallelMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.FunctionContainer;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class AdvancedPrimitiveBlastFurnaceMachine
extends NoEnergyCustomParallelMultiblockMachine {
    @DescSynced
    private BlockPos pos;
    @DescSynced
    private int height;
    @Persisted
    private double duration = 1.0;
    @Persisted
    private int temperature = 298;
    private final ConditionalSubscriptionHandler tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::tickUpdate, 0, () -> this.isFormed || this.temperature > 298);

    public AdvancedPrimitiveBlastFurnaceMachine(MetaMachineBlockEntity holder) {
        super(holder, false, m -> (long)((AdvancedPrimitiveBlastFurnaceMachine)m).height << 1);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.height = 0;
        FunctionContainer container = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"SteelFrame");
        if (container != null) {
            this.height = (Integer)container.getValue();
        }
        this.pos = MachineUtils.getOffsetPos((int)7, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
        this.tickSubs.initialize(this.getLevel());
    }

    private void tickUpdate() {
        if (this.getRecipeLogic().isWorking()) {
            if (this.temperature < 2000) {
                ++this.temperature;
            }
        } else if (this.temperature > 298) {
            this.temperature -= 2;
        }
        this.tickSubs.updateSubscription();
    }

    public boolean onWorking() {
        GTRecipe recipe;
        if (this.getOffsetTimer() % 40 == 0 && this.getLevel() != null && (recipe = this.getRecipeLogic().getLastRecipe()) != null) {
            List entities = this.getLevel().m_45976_(Entity.class, new AABB((double)(this.pos.m_123341_() - 4), (double)(this.pos.m_123342_() + 1), (double)(this.pos.m_123343_() - 4), (double)(this.pos.m_123341_() + 4), (double)(this.pos.m_123342_() + 8 + this.height), (double)(this.pos.m_123343_() + 4)));
            for (Entity entity : entities) {
                if (entity instanceof LivingEntity) {
                    entity.m_6469_(GTODamageTypes.getBlastFurnaceDamageSource(entity), (float)(recipe.parallels * 5L));
                    continue;
                }
                entity.m_6074_();
            }
        }
        return super.onWorking();
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        double dm;
        this.duration = dm = Math.min(1.0, 400.0 / (double)this.temperature);
        if ((recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.getParallel())) == null) {
            return null;
        }
        recipe.duration = (int)((double)recipe.duration * dm);
        return recipe;
    }

    public void afterWorking() {
        super.afterWorking();
        this.duration = 1.0;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.height", (Object[])new Object[]{this.height}));
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.temperature", (Object[])new Object[]{this.temperature}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.total_time.duration", (Object[])new Object[]{FormattingUtil.formatNumbers((double)this.duration)}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.getRecipeLogic().isWorking() && this.pos != null && this.getLevel() != null) {
            BlockPos pos1 = MachineUtils.getOffsetPos((int)-1, (int)(7 + this.height), (Direction)this.getFrontFacing(), (BlockPos)this.pos);
            Direction facing = this.getFrontFacing().m_122424_();
            float xPos = (float)facing.m_122429_() * 0.76f + (float)pos1.m_123341_() + 0.5f;
            float yPos = (float)facing.m_122430_() * 0.76f + (float)pos1.m_123342_() + 0.25f;
            float zPos = (float)facing.m_122431_() * 0.76f + (float)pos1.m_123343_() + 0.5f;
            float ySpd = (float)facing.m_122430_() * 0.1f + 0.2f + 0.1f * GTValues.RNG.m_188501_();
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0);
        }
    }

    public void animateTick(RandomSource random) {
        if (this.getRecipeLogic().isWorking() && this.pos != null && this.getLevel() != null && ConfigHolder.INSTANCE.machines.machineSounds && GTValues.RNG.m_188500_() < 0.1) {
            this.getLevel().m_7785_((double)this.pos.m_123341_(), (double)(this.pos.m_123342_() + 2), (double)this.pos.m_123343_(), SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public long getParallel() {
        return super.getParallel() * (long)Math.max(1, this.temperature / 500);
    }
}

