/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.machine.part.GTOPartAbility;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.machines.ManaMachine;
import com.gtocore.data.IdleReason;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.feature.multiblock.ICustomHighlightMachine;
import com.gtolib.api.machine.feature.multiblock.IMultiStructureMachine;
import com.gtolib.api.machine.mana.feature.IManaMultiblock;
import com.gtolib.api.machine.mana.trait.ManaTrait;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.misc.ManaContainerList;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.tterrag.registrate.util.entry.BlockEntry;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;

public final class PhotovoltaicPowerStationMachine
extends StorageMultiblockMachine
implements IManaMultiblock,
IMultiStructureMachine,
ICustomHighlightMachine {
    private final int basic_rate;
    private final ManaTrait manaTrait;
    private final BlockPattern patternInSpace;
    private int refreshSky = 0;
    private boolean canSeeSky;
    private IdleReason idleReason = null;
    @DescSynced
    private BlockPos highlightStartPos_1 = BlockPos.f_121853_;
    @DescSynced
    private BlockPos highlightEndPos_1 = BlockPos.f_121853_;
    @DescSynced
    private BlockPos highlightStartPos_2 = BlockPos.f_121853_;
    @DescSynced
    private BlockPos highlightEndPos_2 = BlockPos.f_121853_;

    public PhotovoltaicPowerStationMachine(MetaMachineBlockEntity holder, int basicRate, Supplier<? extends Block> casing, BlockEntry<?> photovoltaicBlock) {
        super(holder, 64, i -> i.m_41720_() == BotaniaBlocks.motifDaybloom.m_5456_());
        this.basic_rate = basicRate;
        this.manaTrait = new ManaTrait((IManaMultiblock)this);
        this.patternInSpace = PhotovoltaicPowerStationMachine.getPatternInSpace(this.getDefinition(), casing, photovoltaicBlock);
    }

    public boolean handleTickRecipe(@Nullable Recipe recipe) {
        if (recipe != null) {
            long eu = recipe.eut;
            if (eu != 0L && !this.generateEnergy(-eu, false)) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (com.gtolib.api.recipe.IdleReason)IdleReason.INSUFFICIENT_OUT);
                return false;
            }
            long mana = recipe.manat;
            if (mana != 0L && !this.useMana(mana, false)) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (com.gtolib.api.recipe.IdleReason)IdleReason.INSUFFICIENT_OUT);
                return false;
            }
        }
        return true;
    }

    public BlockPattern getPattern() {
        if (this.isInSpace()) {
            return this.patternInSpace;
        }
        return super.getPattern();
    }

    private boolean isInSpace() {
        Level level = this.getLevel();
        return level != null && PlanetApi.API.isSpace(level);
    }

    @NotNull
    public ManaContainerList getManaContainer() {
        return this.manaTrait.getManaContainers();
    }

    public boolean isGeneratorMana() {
        return true;
    }

    private boolean canSeeSky(Level level) {
        BlockPos pos;
        if (this.isInSpace()) {
            if (this.getFrontFacing().m_122434_() == Direction.Axis.Y) {
                this.setIdleReason(IdleReason.INCORRECT_DIRECTION_VOLTA);
                this.idleReason = IdleReason.INCORRECT_DIRECTION_VOLTA;
                return false;
            }
            pos = MachineUtils.getOffsetPos((int)-11, (int)0, (int)0, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
            upwards = this.getFrontFacing();
            boolean bl = permuteXZ = upwards.m_122434_() == Direction.Axis.Z;
            if (permuteXZ) {
                this.highlightStartPos_1 = pos.m_7918_(-1, 0, -7);
                this.highlightEndPos_1 = pos.m_7918_(1, 0, -1);
                this.highlightStartPos_2 = pos.m_7918_(-1, 0, 1);
                this.highlightEndPos_2 = pos.m_7918_(1, 0, 7);
            } else {
                this.highlightStartPos_1 = pos.m_7918_(-7, 0, -1);
                this.highlightEndPos_1 = pos.m_7918_(-1, 0, 1);
                this.highlightStartPos_2 = pos.m_7918_(1, 0, -1);
                this.highlightEndPos_2 = pos.m_7918_(7, 0, 1);
            }
        } else {
            if (this.getFrontFacing().m_122434_() == Direction.Axis.Y || this.getUpwardsFacing() != Direction.NORTH) {
                this.setIdleReason(IdleReason.INCORRECT_DIRECTION_VOLTA);
                this.idleReason = IdleReason.INCORRECT_DIRECTION_VOLTA;
                return false;
            }
            pos = MachineUtils.getOffsetPos((int)1, (int)4, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
            upwards = this.getFrontFacing();
            boolean bl = permuteXZ = upwards.m_122434_() == Direction.Axis.Z;
            if (permuteXZ) {
                this.highlightStartPos_1 = pos.m_7918_(-3, 0, 1);
                this.highlightEndPos_1 = pos.m_7918_(3, 0, 2);
                this.highlightStartPos_2 = pos.m_7918_(-3, 0, -2);
                this.highlightEndPos_2 = pos.m_7918_(3, 0, -1);
            } else {
                this.highlightStartPos_1 = pos.m_7918_(1, 0, -3);
                this.highlightEndPos_1 = pos.m_7918_(2, 0, 3);
                this.highlightStartPos_2 = pos.m_7918_(-2, 0, -3);
                this.highlightEndPos_2 = pos.m_7918_(-1, 0, 3);
            }
        }
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)this.highlightStartPos_1, (BlockPos)this.highlightEndPos_1)) {
            if (level.m_45527_(new BlockPos(checkPos.m_123341_(), pos.m_123342_() + 1, checkPos.m_123343_()))) continue;
            this.setIdleReason(IdleReason.OBSTRUCTED_VOLTA);
            this.idleReason = IdleReason.OBSTRUCTED_VOLTA;
            return false;
        }
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)this.highlightStartPos_2, (BlockPos)this.highlightEndPos_2)) {
            if (level.m_45527_(new BlockPos(checkPos.m_123341_(), pos.m_123342_() + 1, checkPos.m_123343_()))) continue;
            this.setIdleReason(IdleReason.OBSTRUCTED_VOLTA);
            this.idleReason = IdleReason.OBSTRUCTED_VOLTA;
            return false;
        }
        return true;
    }

    public boolean keepSubscribing() {
        return true;
    }

    @Nullable
    private Recipe getRecipe() {
        block9: {
            int eut;
            block11: {
                int basic;
                Level level;
                block10: {
                    boolean canSeeSky;
                    level = this.getLevel();
                    if (level == null) break block9;
                    if (this.refreshSky > 0) {
                        --this.refreshSky;
                        canSeeSky = this.canSeeSky;
                    } else {
                        this.canSeeSky = canSeeSky = this.canSeeSky(level);
                        this.refreshSky = 10;
                    }
                    if (!canSeeSky) {
                        this.setIdleReason(this.idleReason);
                        return null;
                    }
                    basic = (int)((long)this.basic_rate * PlanetApi.API.getSolarPower(level));
                    if (!PlanetApi.API.isSpace(level)) break block10;
                    int n = eut = this.inputFluid(GTMaterials.DistilledWater.getFluid(), basic / 4) ? basic << 4 : 0;
                    if (eut == 0) {
                        ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_((Component)GTMaterials.DistilledWater.getLocalizedName()));
                    }
                    break block11;
                }
                eut = (int)((double)basic * (GTODimensions.isVoid((ResourceLocation)level.m_46472_().m_135782_()) ? 14.0 : GTOUtils.getSunIntensity((long)level.m_46468_()) * 15.0 / 100.0 * (double)(level.m_46471_() ? (level.m_46470_() ? 0.3f : 0.7f) : 1.0f)));
                if (eut == 0) {
                    ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)"recipe.condition.daytime.day.tooltip"));
                }
            }
            if (eut == 0) {
                return null;
            }
            RecipeBuilder builder = this.getRecipeBuilder().duration(20);
            if (this.getStorageStack().m_41613_() == 64) {
                builder.MANAt((long)(-eut));
            } else {
                builder.EUt((long)(-eut));
            }
            Recipe recipe = builder.buildRawRecipe();
            if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
                return recipe;
            }
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public static BlockPattern getPatternCommon(MultiblockMachineDefinition definition, Supplier<? extends Block> casing, BlockEntry<?> photovoltaicBlock) {
        return FactoryBlockPattern.start((MultiblockMachineDefinition)definition, (RelativeDirection)RelativeDirection.BACK, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.LEFT).aisle(new String[]{"       ", "       ", "       ", "       ", "AAAAAAA"}).aisle(new String[]{"       ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"   D   ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"   D   ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"  ~CD  ", "   C   ", "   C   ", " AACAA ", "ABBCBBA"}).aisle(new String[]{"   D   ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"   D   ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"       ", "       ", "       ", "       ", "ABBCBBA"}).aisle(new String[]{"       ", "       ", "       ", "       ", "AAAAAAA"}).where('A', Predicates.frames((Material[])new Material[]{GTMaterials.Aluminium})).where('B', Predicates.blocks((Block[])new Block[]{(Block)photovoltaicBlock.get()})).where('C', Predicates.blocks((Block[])new Block[]{casing.get()})).where('D', Predicates.blocks((Block[])new Block[]{casing.get()}).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTMachines.CONTROL_HATCH.get()}).setMaxGlobalLimited(1).setPreviewCount(0)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.OUTPUT_MANA}).setMaxGlobalLimited(4)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('~', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build();
    }

    public static MultiblockShapeInfo getPatternCommonPreview(MultiblockMachineDefinition definition, Supplier<? extends Block> casing, BlockEntry<?> photovoltaicBlock) {
        return ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"       ", "       ", "       ", "       ", "AAAAAAA"})).aisle(new String[]{"       ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"   q   ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"   p   ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"  ~CC  ", "   C   ", "   C   ", " AACAA ", "ABBCBBA"})).aisle(new String[]{"   n   ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"   m   ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"       ", "       ", "       ", "       ", "ABBCBBA"})).aisle(new String[]{"       ", "       ", "       ", "       ", "AAAAAAA"})).where('A', ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Aluminium)).where('B', photovoltaicBlock).where('C', casing).where('m', (Supplier)ManaMachine.WIRELESS_MANA_OUTPUT_HATCH[3], Direction.WEST).where('n', (Supplier)GTOMachines.ENERGY_OUTPUT_HATCH_16A[3], Direction.WEST).where('p', (Supplier)GTMachines.CONTROL_HATCH, Direction.WEST).where('q', (Supplier)GTMachines.MAINTENANCE_HATCH, Direction.WEST).where('~', (Supplier)definition, Direction.WEST).where(' ', Blocks.f_50016_).build();
    }

    public static BlockPattern getPatternInSpace(MultiblockMachineDefinition definition, Supplier<? extends Block> casing, BlockEntry<?> photovoltaicBlock) {
        return FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{" CDC "}).aisle(new String[]{"CC CC"}).aisle(new String[]{"C   C"}).aisle(new String[]{"AAAAA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"AAAAA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"ABBBA"}).aisle(new String[]{"AAAAA"}).where('A', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Aluminium)})).where('B', Predicates.blocks((Block[])new Block[]{(Block)photovoltaicBlock.get()})).where('C', Predicates.blocks((Block[])new Block[]{casing.get()}).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTMachines.CONTROL_HATCH.get()}).setMaxGlobalLimited(1).setPreviewCount(0)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.OUTPUT_MANA}).setMaxGlobalLimited(4)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('D', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build();
    }

    public static MultiblockShapeInfo getPatternInSpacePreview(MultiblockMachineDefinition definition, Supplier<? extends Block> casing, BlockEntry<?> photovoltaicBlock) {
        return ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"AAAAA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"AAAAA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"ABBBA"})).aisle(new String[]{"AAAAA"})).aisle(new String[]{"C   o"})).aisle(new String[]{"mn pq"})).aisle(new String[]{" CDC "})).where('A', ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Aluminium)).where('B', photovoltaicBlock).where('C', casing).where('m', (Supplier)ManaMachine.WIRELESS_MANA_OUTPUT_HATCH[3], Direction.UP).where('n', (Supplier)GTOMachines.ENERGY_OUTPUT_HATCH_16A[3], Direction.UP).where('o', (Supplier)GTMachines.FLUID_IMPORT_HATCH[3], Direction.UP).where('p', (Supplier)GTMachines.CONTROL_HATCH, Direction.UP).where('q', (Supplier)GTMachines.MAINTENANCE_HATCH, Direction.UP).where('D', definition.defaultBlockState()).where(' ', Blocks.f_50016_).build();
    }

    public List<BlockPattern> getMultiPattern() {
        return List.of(super.getPattern(), this.patternInSpace);
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        this.attachHighlightConfigurators(configuratorPanel);
    }

    public List<ForgeClientEvent.HighlightNeed> getCustomHighlights() {
        return List.of(new ForgeClientEvent.HighlightNeed(this.highlightStartPos_1, this.highlightEndPos_1, ChatFormatting.YELLOW.m_126665_()), new ForgeClientEvent.HighlightNeed(this.highlightStartPos_2, this.highlightEndPos_2, ChatFormatting.YELLOW.m_126665_()));
    }

    public List<Component> getHighlightText() {
        return List.of(Component.m_237115_((String)"gtocore.machine.highlight_obstruction"));
    }
}

