/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.capability.IExtendWirelessEnergyContainerHolder;
import com.gtolib.api.machine.feature.multiblock.IArrayMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.gtolib.utils.GTOUtils;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public final class GeneratorArrayMachine
extends StorageMultiblockMachine
implements IArrayMachine,
IExtendWirelessEnergyContainerHolder {
    @DynamicInitialValue(key="generator_array.multiply", easyValue="2", normalValue="1.3", expertValue="1.3", typeKey="multiplier", cn="\u53d1\u7535\u9635\u5217\u4e58\u6570", cnComment="\u53d1\u7535\u9635\u5217\u7684\u529f\u7387\u5956\u52b1\u4e58\u6570\uff0c\u5f71\u54cd\u6bcf\u4e2a\u53d1\u7535\u673a\u7684\u8f93\u51fa\u529f\u7387\u3002\n\u6570\u503c\u8d8a\u5927\uff0c\u53d1\u7535\u673a\u7684\u8f93\u51fa\u529f\u7387\u8d8a\u9ad8\u3002\n\u6b64\u503c\u4ec5\u4e0e\u96be\u5ea6\u6302\u94a9\uff0c\u4ee3\u8868\u4e0d\u540c\u96be\u5ea6\u4e0b\u7684\u53d1\u7535\u673a\u6548\u7387\u3002", en="Generator Array Multiply", enComment="The power multiplier bonus of the generator array, which affects the output power of each generator.\nThe larger the value, the higher the output power of the generator.\nThis value is only related to difficulty, representing the efficiency of generators at different difficulty levels.")
    private static double multiply;
    @DynamicInitialValue(key="generator_array.loss", typeKey="multiplier", easyValue="4", normalValue="5", expertValue="8", cn="\u53d1\u7535\u9635\u5217\u65e0\u7ebf\u6a21\u5f0f\u635f\u8017 : 0.0%s", cnComment="\u53d1\u7535\u9635\u5217\u5728\u65e0\u7ebf\u6a21\u5f0f\u4e0b\u7684\u635f\u8017\uff0c\u5f71\u54cd\u4f20\u8f93\u5230\u65e0\u7ebf\u7f51\u7edc\u7684\u80fd\u91cf\u635f\u5931\u3002\n\u6570\u503c\u8d8a\u5927\uff0c\u8fde\u63a5\u65e0\u7ebf\u7f51\u7edc\u7684\u635f\u8017\u8d8a\u5927\u3002", en="Generator Array Wireless Loss : 0.0%s", enComment="The loss of the generator array in wireless mode, which affects the loss of energy transferred to the wireless network.\nThe larger the value, the greater the connection loss to the wireless network.")
    private static int f_loss;
    @DynamicInitialValue(key="generator_array.limit", easyValue="16", normalValue="4", expertValue="4", cn="\u53d1\u7535\u9635\u5217\u5185\u90e8\u53d1\u7535\u673a\u9650\u5236", cnComment="\u53d1\u7535\u9635\u5217\u53d1\u7535\u91cf\u548c\u6d88\u8017\u91cf\u53d6\u51b3\u4e8e\u5185\u90e8\u53d1\u7535\u673a\u79cd\u7c7b\u548c\u4e2a\u6570\n\u5185\u90e8\u53d1\u7535\u673a\u4e2a\u6570\u8d8a\u591a\uff0c\u5176\u53d1\u7535\u91cf\u548c\u6d88\u8017\u91cf\u8d8a\u9ad8\u3002\n\u4f8b\u5982\uff1a\u653e4\u4e2a\u84b8\u6c7d\u53d1\u7535\u673a\uff0c\u53d1\u7535\u91cf\u4e3a(4*\u53d1\u7535\u9635\u5217\u4e58\u6570*\u84b8\u6c7d\u53d1\u7535\u673a\u7684\u53d1\u7535\u91cf)\uff0c", en="Generator Array Internal Generator Limit", enComment="The power generation and consumption of the generator array depend on the types and number of internal generators.\nThe more internal generators, the higher the power generation and consumption.\nFor example: placing 4 steam generators will result in a power generation of (4 * generator array multiplier * steam generator's power generation).")
    private static int generatorLimit;
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    private MachineDefinition machineDefinitionCache;
    private GTRecipeType[] RecipeTypeCache;
    @Persisted
    private boolean isw;
    @Persisted
    private long eut;

    private static boolean isEligibleRecipeType(GTRecipeType type) {
        return Wrapper.ELIGIBLE_RECIPE_TYPES.contains(type);
    }

    public GeneratorArrayMachine(MetaMachineBlockEntity holder) {
        super(holder, generatorLimit, GeneratorArrayMachine::filter);
    }

    private static boolean filter(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            MachineDefinition definition = metaMachineItem.getDefinition();
            if (definition instanceof MultiblockMachineDefinition) {
                return false;
            }
            GTRecipeType[] recipeTypes = definition.getRecipeTypes();
            if (recipeTypes == null) {
                return false;
            }
            for (GTRecipeType type : recipeTypes) {
                if (!GeneratorArrayMachine.isEligibleRecipeType(type)) continue;
                return true;
            }
        }
        return false;
    }

    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes();
    }

    public RecipeType getRecipeType() {
        return (RecipeType)this.recipeTypes()[this.getActiveRecipeType()];
    }

    public void onMachineChanged() {
        this.onStorageChanged();
    }

    public int getTier() {
        int definitionTier;
        MachineDefinition definition = this.getMachineDefinition();
        int n = definitionTier = definition == null ? 0 : definition.getTier();
        if (this.isw) {
            return definitionTier;
        }
        return Math.min(definitionTier, this.tier);
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.isw) {
            if (this.eut > 0L) {
                ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
                if (container != null) {
                    int loss = container.getLoss();
                    container.setLoss(loss + f_loss * 10);
                    container.addEnergy(this.eut, (MetaMachine)this);
                    container.setLoss(loss);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return true;
    }

    protected boolean beforeWorking(Recipe recipe) {
        if (this.isEmpty()) {
            return false;
        }
        return super.beforeWorking(recipe);
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        long EUt;
        int a2 = this.machineStorage.storage.getStackInSlot(0).m_41613_();
        if (a2 > 0 && (EUt = recipe.getOutputEUt()) > 0L) {
            recipe.outputs.clear();
            recipe = ParallelLogic.accurateContentParallel((MetaMachine)this, (Recipe)recipe, (long)((long)(multiply * (double)GTValues.V[this.getOverclockTier()] * (double)a2 * (double)GTOUtils.getGeneratorAmperage((int)this.getTier()) / (double)EUt)));
            if (recipe == null) {
                return null;
            }
            recipe.duration = recipe.duration * GTOUtils.getGeneratorEfficiency((GTRecipeType)this.getRecipeType(), (int)this.getTier()) / 100;
            if (this.isw) {
                recipe.setOutputEUt(0L);
                this.eut = EUt * recipe.parallels;
            }
            return recipe;
        }
        return null;
    }

    public void customText(List<Component> textList) {
        GTRecipe r;
        super.customText(textList);
        textList.add((Component)Component.m_237115_((String)"gtocore.machine.generator_array.wireless").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[").m_7220_((Component)(this.isw ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off"))).m_7220_((Component)Component.m_237113_((String)"]")), (String)"wireless_switch")));
        if (this.isActive() && this.isw && (r = this.getRecipeLogic().getLastRecipe()) != null) {
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.eut), Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage((long)this.eut)])}));
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            if ("wireless_switch".equals(componentData)) {
                this.isw = !this.isw;
                this.eut = 0L;
                this.getRecipeLogic().markLastRecipeDirty();
            } else {
                super.handleDisplayClick(componentData, clickData);
            }
        }
    }

    public Item getStorageItem() {
        return this.getStorageStack().m_41720_();
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public boolean matchRecipe(Recipe recipe) {
        return RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this, (Recipe)recipe);
    }

    public boolean matchTickRecipe(Recipe recipe) {
        return this.isw || super.matchTickRecipe(recipe);
    }

    public static double getMultiply() {
        return multiply;
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer WirelessEnergyContainerCache) {
        this.WirelessEnergyContainerCache = WirelessEnergyContainerCache;
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    public void setMachineDefinitionCache(MachineDefinition machineDefinitionCache) {
        this.machineDefinitionCache = machineDefinitionCache;
    }

    public MachineDefinition getMachineDefinitionCache() {
        return this.machineDefinitionCache;
    }

    public void setRecipeTypeCache(GTRecipeType[] RecipeTypeCache) {
        this.RecipeTypeCache = RecipeTypeCache;
    }

    public GTRecipeType[] getRecipeTypeCache() {
        return this.RecipeTypeCache;
    }

    static {
        generatorLimit = 16;
    }

    private static class Wrapper {
        private static final Set<GTRecipeType> ELIGIBLE_RECIPE_TYPES = Set.of(GTRecipeTypes.STEAM_TURBINE_FUELS, GTRecipeTypes.GAS_TURBINE_FUELS, GTRecipeTypes.COMBUSTION_GENERATOR_FUELS, GTORecipeTypes.SEMI_FLUID_GENERATOR_FUELS, GTORecipeTypes.ROCKET_ENGINE_FUELS, GTORecipeTypes.NAQUADAH_REACTOR);

        private Wrapper() {
        }
    }
}

