/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.machine.trait.INFFluidDrillLogic;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class INFFluidDrillMachine
extends ElectricMultiblockMachine {
    private final int t;
    private final int basis;

    public INFFluidDrillMachine(MetaMachineBlockEntity holder, int tier, int basis) {
        super(holder);
        this.t = tier;
        this.basis = basis;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new INFFluidDrillLogic(this);
    }

    public INFFluidDrillLogic getRecipeLogic() {
        return (INFFluidDrillLogic)super.getRecipeLogic();
    }

    public int getEnergyTier() {
        return Math.min(this.t + 1, this.tier);
    }

    public void addDisplayText(List<Component> textList) {
        if (this.isFormed()) {
            int energyContainer = this.getEnergyTier();
            long maxVoltage = GTValues.V[energyContainer];
            String voltageName = GTValues.VNF[energyContainer];
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
            if (this.getRecipeLogic().getVeinFluid() != null) {
                Fluid drilledFluid = this.getRecipeLogic().getVeinFluid();
                MutableComponent fluidInfo = drilledFluid.getFluidType().getDescription().m_6881_().m_130940_(ChatFormatting.GREEN);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fluid_rig.drilled_fluid", (Object[])new Object[]{fluidInfo}).m_130940_(ChatFormatting.GRAY));
                MutableComponent amountInfo = Component.m_237113_((String)(FormattingUtil.formatNumbers((long)((long)this.getRecipeLogic().getFluidToProduce() * 20L / 20L)) + " mB/s")).m_130940_(ChatFormatting.BLUE);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fluid_rig.fluid_amount", (Object[])new Object[]{amountInfo}).m_130940_(ChatFormatting.GRAY));
            } else {
                MutableComponent noFluid = Component.m_237115_((String)"gtceu.multiblock.fluid_rig.no_fluid_in_area").m_130940_(ChatFormatting.RED);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fluid_rig.drilled_fluid", (Object[])new Object[]{noFluid}).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            MutableComponent tooltip = Component.m_237115_((String)"gtceu.multiblock.invalid_structure.tooltip").m_130940_(ChatFormatting.GRAY);
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.invalid_structure").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip))));
        }
    }

    public int getTier() {
        return this.t;
    }

    @Generated
    public int getBasis() {
        return this.basis;
    }
}

